/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.network.packet.server;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerks;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktSyncKnowledge
implements IMessage,
IMessageHandler<PktSyncKnowledge, IMessage> {
    public static final byte STATE_ADD = 0;
    public static final byte STATE_WIPE = 1;
    private byte state;
    public List<String> knownConstellations = new ArrayList<String>();
    public List<String> seenConstellations = new ArrayList<String>();
    public List<ResearchProgression> researchProgression = new ArrayList<ResearchProgression>();
    public List<SextantFinder.TargetObject> usedTargets = new ArrayList<SextantFinder.TargetObject>();
    public IMajorConstellation attunedConstellation = null;
    public Map<ConstellationPerk, Integer> appliedPerks = new HashMap<ConstellationPerk, Integer>();
    public int progressTier = 0;
    public boolean wasOnceAttuned = false;
    public double alignmentCharge = 0.0;

    public PktSyncKnowledge() {
    }

    public PktSyncKnowledge(byte state) {
        this.state = state;
    }

    public void load(PlayerProgress progress) {
        this.knownConstellations = progress.getKnownConstellations();
        this.seenConstellations = progress.getSeenConstellations();
        this.researchProgression = progress.getResearchProgression();
        this.progressTier = progress.getTierReached().ordinal();
        this.attunedConstellation = progress.getAttunedConstellation();
        this.appliedPerks = progress.getAppliedPerks();
        this.alignmentCharge = progress.getAlignmentCharge();
        this.wasOnceAttuned = progress.wasOnceAttuned();
        this.usedTargets = progress.getUsedTargets();
    }

    public void fromBytes(ByteBuf buf) {
        int targetLength;
        int perkLength;
        byte attunementPresent;
        int rLength;
        String val;
        int i;
        this.state = buf.readByte();
        int cLength = buf.readInt();
        if (cLength != -1) {
            this.knownConstellations = new ArrayList<String>(cLength);
            for (i = 0; i < cLength; ++i) {
                val = ByteBufUtils.readString(buf);
                this.knownConstellations.add(val);
            }
        } else {
            this.knownConstellations = new ArrayList<String>();
        }
        if ((cLength = buf.readInt()) != -1) {
            this.seenConstellations = new ArrayList<String>(cLength);
            for (i = 0; i < cLength; ++i) {
                val = ByteBufUtils.readString(buf);
                this.seenConstellations.add(val);
            }
        } else {
            this.seenConstellations = new ArrayList<String>();
        }
        if ((rLength = buf.readInt()) != -1) {
            this.researchProgression = new ArrayList<ResearchProgression>(rLength);
            for (int i2 = 0; i2 < rLength; ++i2) {
                this.researchProgression.add(ResearchProgression.getById(buf.readInt()));
            }
        } else {
            this.researchProgression = new ArrayList<ResearchProgression>();
        }
        if ((attunementPresent = buf.readByte()) != -1) {
            String attunement = ByteBufUtils.readString(buf);
            IConstellation c = ConstellationRegistry.getConstellationByName(attunement);
            if (c == null || !(c instanceof IMajorConstellation)) {
                AstralSorcery.log.warn("[AstralSorcery] received constellation-attunement progress-packet with unknown constellation: " + attunement);
            } else {
                this.attunedConstellation = (IMajorConstellation)c;
            }
        }
        if ((perkLength = buf.readInt()) != -1) {
            this.appliedPerks = new HashMap<ConstellationPerk, Integer>(perkLength);
            for (int i3 = 0; i3 < perkLength; ++i3) {
                int id = buf.readInt();
                int lvl = buf.readInt();
                this.appliedPerks.put(ConstellationPerks.getById(id).getSingleInstance(), lvl);
            }
        } else {
            this.appliedPerks = new HashMap<ConstellationPerk, Integer>();
        }
        if ((targetLength = buf.readInt()) != -1) {
            this.usedTargets = new ArrayList<SextantFinder.TargetObject>(targetLength);
            for (int i4 = 0; i4 < targetLength; ++i4) {
                String str = ByteBufUtils.readString(buf);
                SextantFinder.TargetObject to = SextantFinder.getByName(str);
                if (to == null) continue;
                this.usedTargets.add(to);
            }
        } else {
            this.usedTargets = new ArrayList<SextantFinder.TargetObject>();
        }
        this.wasOnceAttuned = buf.readBoolean();
        this.progressTier = buf.readInt();
        this.alignmentCharge = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.state);
        if (this.knownConstellations != null) {
            buf.writeInt(this.knownConstellations.size());
            for (String dat : this.knownConstellations) {
                ByteBufUtils.writeString(buf, dat);
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.seenConstellations != null) {
            buf.writeInt(this.seenConstellations.size());
            for (String dat : this.seenConstellations) {
                ByteBufUtils.writeString(buf, dat);
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.researchProgression != null) {
            buf.writeInt(this.researchProgression.size());
            for (ResearchProgression progression : this.researchProgression) {
                buf.writeInt(progression.getProgressId());
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.attunedConstellation != null) {
            buf.writeByte(1);
            ByteBufUtils.writeString(buf, this.attunedConstellation.getUnlocalizedName());
        } else {
            buf.writeByte(-1);
        }
        if (this.appliedPerks != null) {
            buf.writeInt(this.appliedPerks.size());
            for (ConstellationPerk perk : this.appliedPerks.keySet()) {
                buf.writeInt(perk.getId());
                buf.writeInt(this.appliedPerks.get(perk).intValue());
            }
        } else {
            buf.writeInt(-1);
        }
        if (this.usedTargets != null) {
            buf.writeInt(this.usedTargets.size());
            for (SextantFinder.TargetObject to : this.usedTargets) {
                ByteBufUtils.writeString(buf, to.getRegistryName());
            }
        } else {
            buf.writeInt(-1);
        }
        buf.writeBoolean(this.wasOnceAttuned);
        buf.writeInt(this.progressTier);
        buf.writeDouble(this.alignmentCharge);
    }

    public PktSyncKnowledge onMessage(PktSyncKnowledge message, MessageContext ctx) {
        switch (message.state) {
            case 0: {
                ResearchManager.recieveProgressFromServer(message);
                break;
            }
            case 1: {
                ResearchManager.clientProgress = new PlayerProgress();
            }
        }
        return null;
    }
}

