/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import hellfirepvp.astralsorcery.common.data.config.entry.ConfigEntry;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.amulet.registry.AmuletEnchantmentRegistry;
import hellfirepvp.astralsorcery.common.item.wearable.ItemEnchantmentAmulet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class AmuletEnchantHelper {
    private static final Random rand = new Random();
    private static float chance2nd = 0.8f;
    private static float chance3rd = 0.25f;
    private static float chance2Level = 0.15f;
    private static float chanceToAll = 0.02f;
    private static float chanceToNonExisting = 0.35f;

    public static void rollAmulet(ItemStack stack, float perfectionDegree) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            return;
        }
        ArrayList<AmuletEnchantment> ench = new ArrayList<AmuletEnchantment>();
        while (AmuletEnchantHelper.mayGetAdditionalRoll(ench, perfectionDegree)) {
            AmuletEnchantment.Type type = AmuletEnchantHelper.getRollType(ench, perfectionDegree);
            if (type == null) continue;
            int lvl = AmuletEnchantHelper.getRollLevel(perfectionDegree);
            if (type.hasEnchantmentTag()) {
                Enchantment e = AmuletEnchantmentRegistry.getRandomEnchant();
                if (e == null) continue;
                ench.add(new AmuletEnchantment(type, e, lvl));
                continue;
            }
            ench.add(new AmuletEnchantment(type, lvl));
        }
        ItemEnchantmentAmulet.setAmuletEnchantments(stack, AmuletEnchantHelper.collapseEnchantments(ench));
    }

    @Nullable
    private static AmuletEnchantment.Type getRollType(List<AmuletEnchantment> existing, float perfection) {
        int exAll = AmuletEnchantHelper.getAdditionAll(existing);
        switch (existing.size()) {
            case 0: 
            case 1: {
                if (rand.nextFloat() < chanceToAll) {
                    return AmuletEnchantment.Type.ADD_TO_EXISTING_ALL;
                }
                if (rand.nextFloat() < chanceToNonExisting) {
                    return AmuletEnchantment.Type.ADD_TO_SPECIFIC;
                }
                return AmuletEnchantment.Type.ADD_TO_EXISTING_SPECIFIC;
            }
            case 2: {
                if (exAll > 1) {
                    return null;
                }
                if (exAll == 1) {
                    if (rand.nextFloat() < chanceToNonExisting) {
                        return AmuletEnchantment.Type.ADD_TO_SPECIFIC;
                    }
                    return AmuletEnchantment.Type.ADD_TO_EXISTING_SPECIFIC;
                }
                if (rand.nextFloat() < chanceToAll) {
                    return AmuletEnchantment.Type.ADD_TO_EXISTING_ALL;
                }
                if (rand.nextFloat() < chanceToNonExisting) {
                    return AmuletEnchantment.Type.ADD_TO_SPECIFIC;
                }
                return AmuletEnchantment.Type.ADD_TO_EXISTING_SPECIFIC;
            }
        }
        return null;
    }

    private static int getRollLevel(float perfection) {
        if (rand.nextFloat() < chance2Level) {
            return 2;
        }
        return 1;
    }

    private static boolean mayGetAdditionalRoll(List<AmuletEnchantment> existing, float perfection) {
        if (existing.isEmpty()) {
            return true;
        }
        switch (existing.size()) {
            case 1: {
                return rand.nextFloat() < chance2nd;
            }
            case 2: {
                return AmuletEnchantHelper.getAdditionAll(existing) < 2 && rand.nextFloat() < chance3rd;
            }
        }
        return false;
    }

    private static int getAdditionAll(List<AmuletEnchantment> ench) {
        int i = 0;
        for (AmuletEnchantment e : ench) {
            if (!e.getType().equals((Object)AmuletEnchantment.Type.ADD_TO_EXISTING_ALL)) continue;
            ++i;
        }
        return i;
    }

    private static List<AmuletEnchantment> collapseEnchantments(List<AmuletEnchantment> ench) {
        LinkedList<AmuletEnchantment> enchantments = new LinkedList<AmuletEnchantment>();
        for (AmuletEnchantment e : ench) {
            boolean found = false;
            for (AmuletEnchantment ex : enchantments) {
                if (!ex.canMerge(e)) continue;
                ex.merge(e);
                found = true;
                break;
            }
            if (found) continue;
            enchantments.add(e);
        }
        return enchantments;
    }

    public static class CfgEntry
    extends ConfigEntry {
        public CfgEntry() {
            super(ConfigEntry.Section.TOOLS, "enchantment_amulet");
        }

        @Override
        public String getConfigurationSection() {
            return super.getConfigurationSection() + "." + this.getKey();
        }

        @Override
        public void loadFromConfig(Configuration cfg) {
            chance2nd = cfg.getFloat("chance2nd", this.getConfigurationSection(), chance2nd, 0.0f, 1.0f, "Defines the chance to roll a 2nd-enchantment-manipulating roll on the amulet. Value defines a percent chance from 0% to 100%. Setting this to 0 also prevents a 3rd roll");
            chance3rd = cfg.getFloat("chance3rd", this.getConfigurationSection(), chance3rd, 0.0f, 1.0f, "Defines the chance to roll a 3rd-enchantment-manipulation roll on the amulet. Value defines a percent chance from 0% to 100%.");
            chance2Level = cfg.getFloat("chanceLevel2", this.getConfigurationSection(), chance2Level, 0.0f, 1.0f, "Defines the chance the roll will be +2 instead of +1 to existing enchantment/to enchantment/to all enchantments");
            chanceToAll = cfg.getFloat("chanceToAll", this.getConfigurationSection(), chanceToAll, 0.0f, 1.0f, "Defines the chance the amulet-roll 'to all existing enchantments' will appear.");
            chanceToNonExisting = cfg.getFloat("chanceToNonExisting", this.getConfigurationSection(), chanceToNonExisting, 0.0f, 1.0f, "Defines the chance the amulet roll 'to <encahntment>' will appear. (Don't mistake this for 'to exsting <enchantment>'!)");
        }
    }
}

