/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.data.research;

import com.google.common.io.Files;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.event.ClientRenderEventHandler;
import hellfirepvp.astralsorcery.common.block.network.BlockAltar;
import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerkLevelManager;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerks;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.infusion.ActiveInfusionTask;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgressTestAccess;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.item.ItemHandTelescope;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktProgressionUpdate;
import hellfirepvp.astralsorcery.common.network.packet.server.PktSyncKnowledge;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileStarlightInfuser;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResearchManager {
    public static PlayerProgress clientProgress = new PlayerProgress();
    private static Map<UUID, PlayerProgress> playerProgressServer = new HashMap<UUID, PlayerProgress>();

    @Nonnull
    public static PlayerProgress getProgressTestAccess(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, player.func_130014_f_().field_72995_K ? Side.CLIENT : Side.SERVER);
        if (progress == null) {
            return new PlayerProgressTestAccess();
        }
        return progress;
    }

    @Nullable
    public static PlayerProgress getProgress(EntityPlayer player, Side side) {
        if (side == Side.CLIENT) {
            return clientProgress;
        }
        if (player instanceof EntityPlayerMP) {
            return ResearchManager.getProgress((EntityPlayerMP)player);
        }
        return null;
    }

    @Nonnull
    public static PlayerProgress getProgress(EntityPlayerMP player) {
        if (MiscUtils.isPlayerFakeMP(player)) {
            return new PlayerProgressTestAccess();
        }
        return ResearchManager.getProgress(player.func_110124_au());
    }

    @Nonnull
    private static PlayerProgress getProgress(UUID uuid) {
        PlayerProgress progress = playerProgressServer.get(uuid);
        if (progress == null) {
            ResearchManager.loadPlayerKnowledge(uuid);
            progress = playerProgressServer.get(uuid);
        }
        if (progress == null) {
            progress = new PlayerProgress();
        }
        return progress;
    }

    public static void wipeKnowledge(EntityPlayerMP p) {
        ResearchManager.wipeFile(p);
        playerProgressServer.remove(p.func_110124_au());
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, p);
        PktSyncKnowledge pk = new PktSyncKnowledge(1);
        PacketChannel.CHANNEL.sendTo((IMessage)pk, p);
        ResearchManager.loadPlayerKnowledge(p);
        ResearchManager.pushProgressToClientUnsafe(p);
    }

    public static void sendInitClientKnowledge(EntityPlayerMP p) {
        UUID uuid = p.func_110124_au();
        if (playerProgressServer.get(uuid) == null) {
            ResearchManager.loadPlayerKnowledge(p);
        }
        if (playerProgressServer.get(uuid) == null) {
            AstralSorcery.log.warn("[AstralSorcery] Failed to load AstralSocery Progress data for " + p.func_70005_c_());
            AstralSorcery.log.warn("[AstralSorcery] Erroneous file: " + uuid.toString() + ".astral");
            return;
        }
        ResearchManager.pushProgressToClientUnsafe(p);
    }

    public static void unsafeForceGiveResearch(EntityPlayerMP player, ResearchProgression prog) {
        PlayerProgress progress = ResearchManager.getProgress((EntityPlayer)player, Side.SERVER);
        if (progress == null) {
            return;
        }
        ProgressionTier reqTier = prog.getRequiredProgress();
        if (!progress.getTierReached().isThisLaterOrEqual(reqTier)) {
            progress.setTierReached(reqTier);
        }
        LinkedList<ResearchProgression> progToGive = new LinkedList<ResearchProgression>();
        progToGive.add(prog);
        while (!progToGive.isEmpty()) {
            ResearchProgression give = (ResearchProgression)((Object)progToGive.pop());
            if (!progress.getResearchProgression().contains((Object)give)) {
                progress.forceGainResearch(give);
            }
            progToGive.addAll(give.getPreConditions());
        }
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, player);
        ResearchManager.pushProgressToClientUnsafe(player);
        ResearchManager.savePlayerKnowledge(player);
    }

    public static void giveResearchIgnoreFail(EntityPlayer player, ResearchProgression prog) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return;
        }
        ProgressionTier tier = prog.getRequiredProgress();
        if (!progress.getTierReached().isThisLaterOrEqual(tier)) {
            return;
        }
        for (ResearchProgression other : prog.getPreConditions()) {
            if (progress.getResearchProgression().contains((Object)other)) continue;
            return;
        }
        if (progress.forceGainResearch(prog)) {
            PktProgressionUpdate pkt = new PktProgressionUpdate(prog);
            PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
    }

    public static void giveProgressionIgnoreFail(EntityPlayer player, ProgressionTier tier) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return;
        }
        ProgressionTier t = progress.getTierReached();
        if (!t.hasNextTier()) {
            return;
        }
        ProgressionTier next = t.next();
        if (!next.equals((Object)tier)) {
            return;
        }
        progress.setTierReached(next);
        PktProgressionUpdate pkt = new PktProgressionUpdate(next);
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
    }

    public static boolean mergeApplyPlayerprogress(PlayerProgress toMergeFrom, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.acceptMergeFrom(toMergeFrom);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean useSextantTarget(SextantFinder.TargetObject to, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.useTarget(to);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean discoverConstellations(Collection<IConstellation> csts, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        for (IConstellation c : csts) {
            progress.discoverConstellation(c.getUnlocalizedName());
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean discoverConstellation(IConstellation c, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.discoverConstellation(c.getUnlocalizedName());
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean memorizeConstellation(IConstellation c, EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.memorizeConstellation(c.getUnlocalizedName());
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean maximizeTier(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.setTierReached(ProgressionTier.values()[ProgressionTier.values().length - 1]);
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean setAttunedBefore(EntityPlayer player, boolean wasAttunedBefore) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.setAttunedBefore(wasAttunedBefore);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean setAttunedConstellation(EntityPlayer player, @Nullable IMajorConstellation constellation) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.clearPerks();
        progress.forceCharge(0);
        progress.setAttunedConstellation(constellation);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean applyPerk(EntityPlayer player, @Nonnull ConstellationPerks perk) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        if (!progress.hasFreeAlignmentLevel()) {
            return false;
        }
        if (progress.hasPerkUnlocked(perk)) {
            return false;
        }
        int free = progress.getNextFreeLevel();
        if (free == -1) {
            return false;
        }
        progress.addPerk(perk.getSingleInstance(), free);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean resetPerks(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.clearPerks();
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean forceCharge(EntityPlayer player, int charge) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.forceCharge(charge);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static boolean modifyAlignmentCharge(EntityPlayer player, double charge) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        progress.modifyCharge(charge);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    public static void forceMaximizeAll(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return;
        }
        ProgressionTier before = progress.getTierReached();
        ResearchManager.discoverConstellations(ConstellationRegistry.getAllConstellations(), player);
        ResearchManager.maximizeTier(player);
        ResearchManager.forceMaximizeResearch(player);
        ResearchManager.setAttunedBefore(player, true);
        for (SextantFinder.TargetObject to : SextantFinder.getSelectableTargets()) {
            progress.useTarget(to);
        }
        if (progress.getTierReached().isThisLater(before)) {
            PktProgressionUpdate pkt = new PktProgressionUpdate(progress.getTierReached());
            PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        }
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
    }

    public static boolean forceMaximizeResearch(EntityPlayer player) {
        PlayerProgress progress = ResearchManager.getProgress(player, Side.SERVER);
        if (progress == null) {
            return false;
        }
        for (ResearchProgression progression : ResearchProgression.values()) {
            progress.forceGainResearch(progression);
        }
        PktProgressionUpdate pkt = new PktProgressionUpdate();
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, (EntityPlayerMP)player);
        ResearchManager.pushProgressToClientUnsafe((EntityPlayerMP)player);
        ResearchManager.savePlayerKnowledge((EntityPlayerMP)player);
        return true;
    }

    private static void pushProgressToClientUnsafe(EntityPlayerMP p) {
        PlayerProgress progress = playerProgressServer.get(p.func_110124_au());
        PktSyncKnowledge pkt = new PktSyncKnowledge(0);
        pkt.load(progress);
        PacketChannel.CHANNEL.sendTo((IMessage)pkt, p);
    }

    private static void wipeFile(EntityPlayerMP player) {
        ResearchManager.getPlayerFile((EntityPlayer)player).delete();
    }

    public static void savePlayerKnowledge(EntityPlayerMP p) {
        if (!MiscUtils.isPlayerFakeMP(p)) {
            ResearchManager.savePlayerKnowledge(p.func_110124_au());
        }
    }

    private static void savePlayerKnowledge(UUID pUUID) {
        if (playerProgressServer.get(pUUID) == null) {
            return;
        }
        File playerFile = ResearchManager.getPlayerFile(pUUID);
        try {
            Files.copy((File)playerFile, (File)ResearchManager.getPlayerBackupFile(pUUID));
        }
        catch (IOException exc) {
            AstralSorcery.log.warn("[AstralSorcery] Failed copying progress file contents to backup file!");
            exc.printStackTrace();
        }
        try {
            NBTTagCompound cmp = new NBTTagCompound();
            playerProgressServer.get(pUUID).store(cmp);
            CompressedStreamTools.func_74795_b((NBTTagCompound)cmp, (File)playerFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadPlayerKnowledge(EntityPlayerMP p) {
        if (!MiscUtils.isPlayerFakeMP(p)) {
            ResearchManager.loadPlayerKnowledge(p.func_110124_au());
        }
    }

    private static void loadPlayerKnowledge(UUID pUUID) {
        File playerFile = ResearchManager.getPlayerFile(pUUID);
        try {
            ResearchManager.load_unsafe(pUUID, playerFile);
        }
        catch (Exception e) {
            AstralSorcery.log.warn("[AstralSorcery] Unable to load progress from default progress file. Attempting loading backup.");
            AstralSorcery.log.warn("[AstralSorcery] Erroneous file: " + playerFile.getName());
            e.printStackTrace();
            playerFile = ResearchManager.getPlayerBackupFile(pUUID);
            try {
                ResearchManager.load_unsafe(pUUID, playerFile);
                Files.copy((File)playerFile, (File)ResearchManager.getPlayerFile(pUUID));
            }
            catch (Exception e1) {
                AstralSorcery.log.warn("[AstralSorcery] Unable to load progress from backup progress file. Copying relevant files to error files.");
                AstralSorcery.log.warn("[AstralSorcery] Erroneous file: " + playerFile.getName());
                e1.printStackTrace();
                File plOriginal = ResearchManager.getPlayerFile(pUUID);
                File plBackup = ResearchManager.getPlayerBackupFile(pUUID);
                try {
                    Files.copy((File)plOriginal, (File)new File(plOriginal.getParent(), plOriginal.getName() + ".lerror"));
                    Files.copy((File)plBackup, (File)new File(plBackup.getParent(), plBackup.getName() + ".lerror"));
                    AstralSorcery.log.warn("[AstralSorcery] Copied progression files to error files. In case you would like to try me (HellFirePvP) to maybe see what i can do about maybe recovering the files,");
                    AstralSorcery.log.warn("[AstralSorcery] send them over to me at the issue tracker https://github.com/HellFirePvP/AstralSorcery/issues - 90% that i won't be able to do anything, but reporting it would still be great.");
                }
                catch (IOException e2) {
                    AstralSorcery.log.warn("[AstralSorcery] Unable to copy files to error-files.");
                    AstralSorcery.log.warn("[AstralSorcery] I've had enough. I can't even access or open the files apparently. I'm giving up.");
                    e2.printStackTrace();
                }
                plOriginal.delete();
                plBackup.delete();
                ResearchManager.informPlayersAboutProgressionLoss(pUUID);
                ResearchManager.load_unsafeFromNBT(pUUID, null);
                ResearchManager.savePlayerKnowledge(pUUID);
            }
        }
    }

    private static void load_unsafe(UUID pUUID, File playerFile) throws Exception {
        NBTTagCompound compound = CompressedStreamTools.func_74797_a((File)playerFile);
        ResearchManager.load_unsafeFromNBT(pUUID, compound);
    }

    private static void load_unsafeFromNBT(UUID pUUID, @Nullable NBTTagCompound compound) {
        PlayerProgress progress = new PlayerProgress();
        if (compound != null) {
            progress.load(compound);
        }
        progress.forceGainResearch(ResearchProgression.DISCOVERY);
        playerProgressServer.put(pUUID, progress);
    }

    public static File getPlayerFile(EntityPlayer player) {
        return ResearchManager.getPlayerFile(player.func_110124_au());
    }

    public static File getPlayerFile(UUID pUUID) {
        File f = new File(ResearchManager.getPlayerDirectory(), pUUID.toString() + ".astral");
        if (!f.exists()) {
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    public static boolean doesPlayerFileExist(EntityPlayer player) {
        return new File(ResearchManager.getPlayerDirectory(), player.func_110124_au().toString() + ".astral").exists();
    }

    public static File getPlayerBackupFile(EntityPlayer player) {
        return ResearchManager.getPlayerBackupFile(player.func_110124_au());
    }

    public static File getPlayerBackupFile(UUID pUUID) {
        File f = new File(ResearchManager.getPlayerDirectory(), pUUID.toString() + ".astralback");
        if (!f.exists()) {
            try {
                CompressedStreamTools.func_74795_b((NBTTagCompound)new NBTTagCompound(), (File)f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return f;
    }

    private static File getPlayerDirectory() {
        File wDir = DimensionManager.getWorld((int)0).func_72860_G().func_75765_b();
        File pDir = new File(wDir, "playerdata");
        if (!pDir.exists()) {
            pDir.mkdirs();
        }
        return pDir;
    }

    public static void saveAndClearServerCache() {
        playerProgressServer.keySet().forEach(ResearchManager::savePlayerKnowledge);
        playerProgressServer.clear();
    }

    public static void recieveProgressFromServer(PktSyncKnowledge message) {
        int currentLvl = clientProgress == null ? 0 : ConstellationPerkLevelManager.getAlignmentLevel(clientProgress);
        clientProgress = new PlayerProgress();
        clientProgress.receive(message);
        if (ConstellationPerkLevelManager.getAlignmentLevel(clientProgress) > currentLvl) {
            ResearchManager.showBar();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void showBar() {
        ClientRenderEventHandler.requestPermChargeReveal(160);
    }

    public static void informCraftingGridCompletion(EntityPlayer player, ItemStack out) {
        Item iOut = out.func_77973_b();
        ResearchManager.informCraft(player, out, iOut, Block.func_149634_a((Item)iOut));
    }

    public static void informCraftingInfusionCompletion(TileStarlightInfuser infuser, ActiveInfusionTask recipe) {
        EntityPlayer crafter = recipe.tryGetCraftingPlayerServer();
        if (crafter == null) {
            AstralSorcery.log.warn("[AstralSorcery] Infusion finished, player that initialized crafting could not be found!");
            AstralSorcery.log.warn("[AstralSorcery] Affected tile: " + infuser.func_174877_v() + " in dim " + infuser.func_145831_w().field_73011_w.getDimension());
            return;
        }
        ItemStack out = recipe.getRecipeToCraft().getOutput(infuser);
        Item iOut = out.func_77973_b();
        ResearchManager.informCraft(crafter, out, iOut, Block.func_149634_a((Item)iOut));
    }

    public static void informCraftingAltarCompletion(TileAltar altar, ActiveCraftingTask recipeToCraft) {
        EntityPlayer crafter = recipeToCraft.tryGetCraftingPlayerServer();
        if (crafter == null) {
            AstralSorcery.log.warn("[AstralSorcery] Crafting finished, player that initialized crafting could not be found!");
            AstralSorcery.log.warn("[AstralSorcery] Affected tile: " + altar.func_174877_v() + " in dim " + altar.func_145831_w().field_73011_w.getDimension());
            return;
        }
        ItemStack out = recipeToCraft.getRecipeToCraft().getOutputForMatching();
        Item iOut = out.func_77973_b();
        ResearchManager.informCraft(crafter, out, iOut, Block.func_149634_a((Item)iOut));
    }

    private static void informCraft(EntityPlayer crafter, ItemStack crafted, Item itemCrafted, @Nullable Block iBlock) {
        if (itemCrafted instanceof ItemHandTelescope) {
            // empty if block
        }
        if (iBlock != null && iBlock instanceof BlockAltar) {
            ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.BASIC_CRAFT);
            ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.BASIC_CRAFT);
            TileAltar.AltarLevel to = TileAltar.AltarLevel.values()[crafted.func_77952_i()];
            switch (to) {
                case ATTUNEMENT: {
                    ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.ATTUNEMENT);
                    ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.ATTUNEMENT);
                    break;
                }
                case CONSTELLATION_CRAFT: {
                    ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.CONSTELLATION_CRAFT);
                    ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.CONSTELLATION);
                    break;
                }
                case TRAIT_CRAFT: {
                    ResearchManager.giveProgressionIgnoreFail(crafter, ProgressionTier.TRAIT_CRAFT);
                    ResearchManager.giveResearchIgnoreFail(crafter, ResearchProgression.RADIANCE);
                    break;
                }
            }
        }
    }

    private static void informPlayersAboutProgressionLoss(UUID pUUID) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            EntityPlayerMP player = server.func_184103_al().func_177451_a(pUUID);
            if (player != null) {
                player.func_145747_a(new TextComponentString("AstralSorcery: Your progression could not be loaded and can't be recovered from backup. Please contact an administrator to lookup what went wrong and/or potentially recover your data from a backup.").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            String resolvedName = player != null ? player.func_70005_c_() : pUUID.toString() + " (Not online)";
            for (String opName : server.func_184103_al().func_152606_n()) {
                EntityPlayerMP pl = server.func_184103_al().func_152612_a(opName);
                if (pl == null) continue;
                pl.func_145747_a(new TextComponentString("AstralSorcery: The progression of " + resolvedName + " could not be loaded and can't be recovered from backup. Error files might be created from the unloadable progression files, check the console for additional information!").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
    }
}

