/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar.recipes;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.ItemColorizationHelper;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.common.block.network.BlockCollectorCrystalBase;
import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.crafting.ICraftingProgress;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.ActiveCraftingTask;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import hellfirepvp.astralsorcery.common.tile.TileAttunementRelay;
import hellfirepvp.astralsorcery.common.tile.base.TileReceiverBaseInventory;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.nbt.NBTUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class TraitRecipe
extends ConstellationRecipe
implements ICraftingProgress {
    private List<ItemHandle> additionallyRequiredStacks = Lists.newLinkedList();
    private Map<TraitRecipeSlot, ItemHandle> matchTraitStacks = new HashMap<TraitRecipeSlot, ItemHandle>();
    private IConstellation requiredConstellation = null;

    protected TraitRecipe(TileAltar.AltarLevel neededLevel, AccessibleRecipe recipe) {
        super(neededLevel, recipe);
    }

    public TraitRecipe(AccessibleRecipe recipe) {
        super(TileAltar.AltarLevel.TRAIT_CRAFT, recipe);
        this.setPassiveStarlightRequirement(7500);
    }

    public TraitRecipe setInnerTraitItem(Item i, TraitRecipeSlot ... slots) {
        return this.setInnerTraitItem(new ItemStack(i), slots);
    }

    public TraitRecipe setInnerTraitItem(Block b, TraitRecipeSlot ... slots) {
        return this.setInnerTraitItem(new ItemStack(b), slots);
    }

    public TraitRecipe setInnerTraitItem(ItemStack stack, TraitRecipeSlot ... slots) {
        return this.setInnerTraitItem(new ItemHandle(stack), slots);
    }

    public TraitRecipe setInnerTraitItem(String oreDict, TraitRecipeSlot ... slots) {
        return this.setInnerTraitItem(new ItemHandle(oreDict), slots);
    }

    public TraitRecipe setInnerTraitItem(FluidStack fluid, TraitRecipeSlot ... slots) {
        return this.setInnerTraitItem(new ItemHandle(fluid), slots);
    }

    public TraitRecipe setInnerTraitItem(Fluid fluid, int mbAmount, TraitRecipeSlot ... slots) {
        return this.setInnerTraitItem(new FluidStack(fluid, mbAmount), slots);
    }

    public TraitRecipe setInnerTraitItem(Fluid fluid, TraitRecipeSlot ... slots) {
        return this.setInnerTraitItem(fluid, 1000, slots);
    }

    public TraitRecipe setInnerTraitItem(ItemHandle handle, TraitRecipeSlot ... slots) {
        for (TraitRecipeSlot slot : slots) {
            this.matchTraitStacks.put(slot, handle);
        }
        return this;
    }

    public TraitRecipe addOuterTraitItem(Item i) {
        return this.addOuterTraitItem(new ItemStack(i));
    }

    public TraitRecipe addOuterTraitItem(Block b) {
        return this.addOuterTraitItem(new ItemStack(b));
    }

    public TraitRecipe addOuterTraitItem(ItemStack stack) {
        return this.addOuterTraitItem(new ItemHandle(stack));
    }

    public TraitRecipe addOuterTraitItem(String oreDict) {
        return this.addOuterTraitItem(new ItemHandle(oreDict));
    }

    public TraitRecipe addOuterTraitItem(FluidStack fluid) {
        return this.addOuterTraitItem(new ItemHandle(fluid));
    }

    public TraitRecipe addOuterTraitItem(Fluid fluid, int mbAmount) {
        return this.addOuterTraitItem(new FluidStack(fluid, mbAmount));
    }

    public TraitRecipe addOuterTraitItem(Fluid fluid) {
        return this.addOuterTraitItem(fluid, 1000);
    }

    public TraitRecipe addOuterTraitItem(ItemHandle handle) {
        this.additionallyRequiredStacks.add(handle);
        return this;
    }

    @Nonnull
    public List<NonNullList<ItemStack>> getTraitItems() {
        ArrayList out = Lists.newArrayList();
        for (ItemHandle handle : this.additionallyRequiredStacks) {
            out.add(handle.getApplicableItems());
        }
        return out;
    }

    @Nonnull
    public List<ItemHandle> getTraitItemHandles() {
        return Lists.newArrayList(this.additionallyRequiredStacks);
    }

    @Nonnull
    public List<ItemStack> getInnerTraitItems(TraitRecipeSlot slot) {
        ItemHandle handle = this.matchTraitStacks.get((Object)slot);
        if (handle != null) {
            return handle.getApplicableItems();
        }
        return Lists.newArrayList();
    }

    @Nullable
    public ItemHandle getInnerTraitItemHandle(TraitRecipeSlot slot) {
        return this.matchTraitStacks.get((Object)slot);
    }

    public void setRequiredConstellation(IConstellation requiredConstellation) {
        this.requiredConstellation = requiredConstellation;
    }

    @Nullable
    public IConstellation getRequiredConstellation() {
        return this.requiredConstellation;
    }

    @Override
    public int craftingTickTime() {
        return 700;
    }

    @Override
    public void handleInputConsumption(TileAltar ta, ActiveCraftingTask craftingTask, ItemStackHandler inventory) {
        super.handleInputConsumption(ta, craftingTask, inventory);
        for (TraitRecipeSlot slot : TraitRecipeSlot.values()) {
            int slotId = slot.getSlotId();
            if (this.mayDecrement(ta, slot)) {
                ItemUtils.decrStackInInventory(inventory, slotId);
                continue;
            }
            this.handleItemConsumption(ta, slot);
        }
        this.consumeOuterInputs(ta, craftingTask);
    }

    @Override
    public boolean tryProcess(TileAltar altar, ActiveCraftingTask runningTask, NBTTagCompound craftingData, int activeCraftingTick, int totalCraftingTime) {
        if (!this.fulfillesStarlightRequirement(altar)) {
            return false;
        }
        List<CraftingFocusStack> stacks = this.collectCurrentStacks(craftingData);
        if (!this.matchFocusStacks(altar, stacks)) {
            return false;
        }
        int required = this.additionallyRequiredStacks.size();
        int part = totalCraftingTime / 2;
        int offset = totalCraftingTime / 10;
        int cttPart = part / required;
        for (int i = 0; i < required; ++i) {
            int timing = i * cttPart + offset;
            if (activeCraftingTick < timing) continue;
            CraftingFocusStack found = null;
            for (CraftingFocusStack stack : stacks) {
                if (stack.stackIndex != i) continue;
                found = stack;
                break;
            }
            if (found != null) continue;
            BlockPos next = this.findUnusedRelay(altar, stacks);
            if (next != null) {
                CraftingFocusStack stack;
                stack = new CraftingFocusStack(i, next);
                stacks.add(stack);
                this.storeCurrentStacks(craftingData, stacks);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(TileAltar altar, TileReceiverBaseInventory.ItemHandlerTile invHandler, boolean ignoreStarlightRequirement) {
        IConstellation req = this.getRequiredConstellation();
        if (req != null) {
            IConstellation focus = altar.getFocusedConstellation();
            if (focus == null) {
                return false;
            }
            if (!req.equals(focus)) {
                return false;
            }
        }
        for (TraitRecipeSlot slot : TraitRecipeSlot.values()) {
            ItemStack altarItem;
            ItemHandle expected = this.matchTraitStacks.get((Object)slot);
            if (!(expected != null ? !expected.matchCrafting(altarItem = invHandler.getStackInSlot(slot.getSlotId())) : !invHandler.getStackInSlot(slot.getSlotId()).func_190926_b())) continue;
            return false;
        }
        return super.matches(altar, invHandler, ignoreStarlightRequirement);
    }

    public void consumeOuterInputs(TileAltar altar, ActiveCraftingTask craftingTask) {
        List<CraftingFocusStack> stacks = this.collectCurrentStacks(craftingTask.getCraftingData());
        for (CraftingFocusStack stack : stacks) {
            if (stack.stackIndex < 0 || stack.stackIndex >= this.additionallyRequiredStacks.size()) continue;
            ItemHandle required = this.additionallyRequiredStacks.get(stack.stackIndex);
            TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)altar.func_145831_w(), altar.func_174877_v().func_177971_a((Vec3i)stack.offset), TileAttunementRelay.class, true);
            if (tar == null) continue;
            ItemStack found = tar.getInventoryHandler().getStackInSlot(0);
            if (required.getFluidTypeAndAmount() != null) {
                FluidActionResult fas;
                if (found.func_190926_b() || !(fas = ItemUtils.drainFluidFromItem(found, required.getFluidTypeAndAmount(), true)).isSuccess()) continue;
                tar.getInventoryHandler().setStackInSlot(0, fas.getResult());
                tar.markForUpdate();
                continue;
            }
            if (!ForgeHooks.getContainerItem((ItemStack)found).func_190926_b()) {
                tar.getInventoryHandler().setStackInSlot(0, ForgeHooks.getContainerItem((ItemStack)found));
                tar.markForUpdate();
                continue;
            }
            ItemUtils.decrStackInInventory(tar.getInventoryHandler(), 0);
            tar.markForUpdate();
        }
    }

    @Override
    @Nonnull
    public ResearchProgression getRequiredProgression() {
        return ResearchProgression.RADIANCE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftClientTick(TileAltar altar, ActiveCraftingTask.CraftingState state, long tick, Random rand) {
        super.onCraftClientTick(altar, state, tick, rand);
        Vector3 thisAltar = new Vector3(altar).add(0.5, 0.5, 0.5);
        ActiveCraftingTask act = altar.getActiveCraftingTask();
        if (act != null) {
            List<CraftingFocusStack> stacks = this.collectCurrentStacks(act.getCraftingData());
            for (CraftingFocusStack stack : stacks) {
                if (stack.stackIndex < 0 || stack.stackIndex >= this.additionallyRequiredStacks.size()) continue;
                ItemHandle required = this.additionallyRequiredStacks.get(stack.stackIndex);
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)altar.func_145831_w(), altar.func_174877_v().func_177971_a((Vec3i)stack.offset), TileAttunementRelay.class, true);
                if (tar == null) continue;
                ItemStack found = tar.getInventoryHandler().getStackInSlot(0);
                if (!found.func_190926_b() && required.matchCrafting(found)) {
                    Color c = ItemColorizationHelper.getDominantColorFromItemStack(found);
                    if (c == null) {
                        c = BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor;
                    }
                    if (ClientScheduler.getClientTick() % 35L == 0L) {
                        EffectLightbeam beam = EffectHandler.getInstance().lightbeam(new Vector3(tar).add(0.5, 0.1, 0.5), new Vector3(altar).add(0.5, 4.5, 0.5), 0.8);
                        beam.setColorOverlay(c);
                    }
                    if (rand.nextBoolean()) {
                        Vector3 at = new Vector3(tar);
                        at.add((double)rand.nextFloat() * 0.8 + 0.1, 0.0, (double)rand.nextFloat() * 0.8 + 0.1);
                        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                        p.setAlphaMultiplier(0.7f);
                        p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                        p.gravity(0.01).scale(0.3f + rand.nextFloat() * 0.1f);
                        p.setColor(c);
                        if (rand.nextInt(3) == 0) {
                            p.gravity(0.004).scale(0.1f + rand.nextFloat() * 0.1f);
                            p.setColor(Color.WHITE);
                        }
                    }
                    if (rand.nextInt(5) != 0) continue;
                    EntityFXFacingParticle p = EffectHelper.genericFlareParticle((float)(altar.func_174877_v().func_177958_n() - 3) + rand.nextFloat() * 7.0f, (double)altar.func_174877_v().func_177956_o() + 0.02, (float)(altar.func_174877_v().func_177952_p() - 3) + rand.nextFloat() * 7.0f);
                    p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.15f);
                    p.setColor(c);
                    continue;
                }
                NonNullList<ItemStack> stacksApplicable = required.getApplicableItemsForRender();
                if (stacksApplicable.size() <= 0) continue;
                int mod = (int)(ClientScheduler.getClientTick() % (long)(stacksApplicable.size() * 60));
                ItemStack element = (ItemStack)stacksApplicable.get(MathHelper.func_76141_d((float)MathHelper.func_76125_a((int)(stacksApplicable.size() * (mod / (stacksApplicable.size() * 60))), (int)0, (int)(stacksApplicable.size() - 1))));
                Color c = ItemColorizationHelper.getDominantColorFromItemStack(element);
                if (c == null) {
                    c = BlockCollectorCrystalBase.CollectorCrystalType.CELESTIAL_CRYSTAL.displayColor;
                }
                if (ClientScheduler.getClientTick() % 35L == 0L) {
                    EffectLightbeam beam = EffectHandler.getInstance().lightbeam(new Vector3(tar).add(0.5, 0.1, 0.5), new Vector3(altar).add(0.5, 4.5, 0.5), 0.8);
                    beam.setColorOverlay(c);
                }
                if (!rand.nextBoolean()) continue;
                Vector3 at = new Vector3(tar);
                at.add((double)rand.nextFloat() * 0.8 + 0.1, 0.0, (double)rand.nextFloat() * 0.8 + 0.1);
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX(), at.getY(), at.getZ());
                p.setAlphaMultiplier(0.7f);
                p.setMaxAge((int)(30.0f + rand.nextFloat() * 50.0f));
                p.gravity(0.01).scale(0.3f + rand.nextFloat() * 0.1f);
                p.setColor(c);
                if (rand.nextInt(3) != 0) continue;
                p.gravity(0.004).scale(0.1f + rand.nextFloat() * 0.1f);
                p.setColor(Color.WHITE);
            }
        }
        if (state == ActiveCraftingTask.CraftingState.ACTIVE) {
            Vector3 r;
            int i;
            EntityFXFacingParticle p;
            if (rand.nextInt(4) == 0) {
                p = EffectHelper.genericFlareParticle((float)(altar.func_174877_v().func_177958_n() - 3) + rand.nextFloat() * 7.0f, (double)altar.func_174877_v().func_177956_o() + 0.02, (float)(altar.func_174877_v().func_177952_p() - 3) + rand.nextFloat() * 7.0f);
                p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.15f);
                p.setColor(Color.WHITE);
            }
            for (i = 0; i < 1; ++i) {
                r = Vector3.random().setY(0).normalize().multiply(1.3 + (double)rand.nextFloat() * 0.5).add(thisAltar.clone().addY(2.0 + (double)rand.nextFloat() * 0.4));
                p = EffectHelper.genericFlareParticle(r.getX(), r.getY(), r.getZ());
                p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.1f);
                p.setColor(Color.WHITE);
            }
            for (i = 0; i < 2; ++i) {
                r = Vector3.random().setY(0).normalize().multiply(2.0 + (double)rand.nextFloat() * 0.5).add(thisAltar.clone().addY(1.1 + (double)rand.nextFloat() * 0.4));
                p = EffectHelper.genericFlareParticle(r.getX(), r.getY(), r.getZ());
                p.gravity(0.004).enableAlphaFade(EntityComplexFX.AlphaFunction.FADE_OUT).scale(rand.nextFloat() * 0.2f + 0.1f);
                p.setColor(Color.WHITE);
            }
            if (rand.nextInt(20) == 0) {
                Vector3 from = new Vector3((double)((float)(altar.func_174877_v().func_177958_n() - 3) + rand.nextFloat() * 7.0f), (double)altar.func_174877_v().func_177956_o() + 0.02, (double)((float)(altar.func_174877_v().func_177952_p() - 3) + rand.nextFloat() * 7.0f));
                MiscUtils.applyRandomOffset(from, rand, 0.4f);
                EffectLightbeam lightbeam = EffectHandler.getInstance().lightbeam(from.clone().addY(4 + rand.nextInt(2)), from, 1.0);
                lightbeam.setMaxAge(64);
                lightbeam.setColorOverlay(Color.WHITE);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onCraftTESRRender(TileAltar altar, double x, double y, double z, float partialTicks) {
        super.onCraftTESRRender(altar, x, y, z, partialTicks);
        ActiveCraftingTask act = altar.getActiveCraftingTask();
        if (act != null) {
            List<CraftingFocusStack> stacks = this.collectCurrentStacks(act.getCraftingData());
            for (CraftingFocusStack stack : stacks) {
                if (stack.stackIndex < 0 || stack.stackIndex >= this.additionallyRequiredStacks.size()) continue;
                ItemHandle required = this.additionallyRequiredStacks.get(stack.stackIndex);
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)altar.func_145831_w(), altar.func_174877_v().func_177971_a((Vec3i)stack.offset), TileAttunementRelay.class, true);
                if (tar != null) {
                    ItemStack found = tar.getInventoryHandler().getStackInSlot(0);
                    if (!found.func_190926_b() && required.matchCrafting(found)) continue;
                    NonNullList<ItemStack> stacksApplicable = required.getApplicableItemsForRender();
                    int mod = (int)(ClientScheduler.getClientTick() % (long)(stacksApplicable.size() * 60));
                    ItemStack element = (ItemStack)stacksApplicable.get(MathHelper.func_76141_d((float)MathHelper.func_76125_a((int)(stacksApplicable.size() * (mod / (stacksApplicable.size() * 60))), (int)0, (int)(stacksApplicable.size() - 1))));
                    this.renderTranslucentItem(element, x + (double)stack.offset.func_177958_n(), y + (double)stack.offset.func_177956_o(), z + (double)stack.offset.func_177952_p(), partialTicks);
                    continue;
                }
                NonNullList<ItemStack> stacksApplicable = required.getApplicableItemsForRender();
                int mod = (int)(ClientScheduler.getClientTick() % (long)(stacksApplicable.size() * 60));
                ItemStack element = (ItemStack)stacksApplicable.get(MathHelper.func_76141_d((float)MathHelper.func_76125_a((int)(stacksApplicable.size() * (mod / (stacksApplicable.size() * 60))), (int)0, (int)(stacksApplicable.size() - 1))));
                this.renderTranslucentItem(element, x + (double)stack.offset.func_177958_n(), y + (double)stack.offset.func_177956_o(), z + (double)stack.offset.func_177952_p(), partialTicks);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderTranslucentItem(ItemStack stack, double x, double y, double z, float partialTicks) {
        GlStateManager.func_179094_E();
        IBakedModel bakedModel = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null);
        float sinBobY = MathHelper.func_76126_a((float)(((float)ClientScheduler.getClientTick() + partialTicks) / 10.0f)) * 0.1f + 0.1f;
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + (double)sinBobY + 0.25), (double)(z + 0.5));
        float ageRotate = ((float)ClientScheduler.getClientTick() + partialTicks) / 20.0f * 57.295776f;
        GlStateManager.func_179114_b((float)ageRotate, (float)0.0f, (float)1.0f, (float)0.0f);
        bakedModel = ForgeHooksClient.handleCameraTransforms((IBakedModel)bakedModel, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND, (boolean)false);
        TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.001f);
        GlStateManager.func_179147_l();
        Blending.CONSTANT_ALPHA.applyStateManager();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        RenderingUtils.tryRenderItemWithColor(stack, bakedModel, Color.WHITE, 0.1f);
        GlStateManager.func_179089_o();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        Blending.DEFAULT.applyStateManager();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        textureManager.func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179121_F();
    }

    @Nullable
    protected BlockPos findUnusedRelay(TileAltar center, List<CraftingFocusStack> found) {
        LinkedList eligableRelayOffsets = Lists.newLinkedList();
        for (int xx = -3; xx <= 3; ++xx) {
            for (int zz = -3; zz <= 3; ++zz) {
                if (xx == 0 && zz == 0) continue;
                BlockPos offset = new BlockPos(xx, 0, zz);
                TileAttunementRelay tar = MiscUtils.getTileAt((IBlockAccess)center.func_145831_w(), center.func_174877_v().func_177971_a((Vec3i)offset), TileAttunementRelay.class, true);
                if (tar == null) continue;
                eligableRelayOffsets.add(offset);
            }
        }
        for (CraftingFocusStack stack : found) {
            eligableRelayOffsets.remove(stack.offset);
        }
        if (eligableRelayOffsets.size() <= 0) {
            return null;
        }
        return (BlockPos)eligableRelayOffsets.get(center.func_145831_w().field_73012_v.nextInt(eligableRelayOffsets.size()));
    }

    protected boolean matchFocusStacks(TileAltar altar, List<CraftingFocusStack> stacks) {
        for (CraftingFocusStack stack : stacks) {
            int index = stack.stackIndex;
            if (index < 0 || index >= this.additionallyRequiredStacks.size()) continue;
            ItemHandle required = this.additionallyRequiredStacks.get(index);
            TileAttunementRelay relay = MiscUtils.getTileAt((IBlockAccess)altar.func_145831_w(), altar.func_174877_v().func_177971_a((Vec3i)stack.offset), TileAttunementRelay.class, true);
            if (relay == null) {
                return false;
            }
            ItemStack in = relay.getInventoryHandler().getStackInSlot(0);
            if (!in.func_190926_b() && required.matchCrafting(in)) continue;
            return false;
        }
        return true;
    }

    protected void storeCurrentStacks(NBTTagCompound craftingStorage, List<CraftingFocusStack> stacks) {
        NBTTagList list = new NBTTagList();
        for (CraftingFocusStack stack : stacks) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("focusIndex", stack.stackIndex.intValue());
            NBTUtils.writeBlockPosToNBT(stack.offset, tag);
            list.func_74742_a((NBTBase)tag);
        }
        craftingStorage.func_74782_a("offsetFocusList", (NBTBase)list);
    }

    protected List<CraftingFocusStack> collectCurrentStacks(NBTTagCompound craftingStorage) {
        LinkedList stacks = Lists.newLinkedList();
        NBTTagList list = craftingStorage.func_150295_c("offsetFocusList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cmp = list.func_150305_b(i);
            int index = cmp.func_74762_e("focusIndex");
            BlockPos pos = NBTUtils.readBlockPosFromNBT(cmp);
            stacks.add(new CraftingFocusStack(index, pos));
        }
        return stacks;
    }

    public static enum TraitRecipeSlot {
        UPPER_CENTER(21),
        LEFT_CENTER(22),
        RIGHT_CENTER(23),
        LOWER_CENTER(24);

        private final int slotId;

        private TraitRecipeSlot(int slotId) {
            this.slotId = slotId;
        }

        public int getSlotId() {
            return this.slotId;
        }
    }

    protected static class CraftingFocusStack {
        protected final Integer stackIndex;
        protected final BlockPos offset;

        protected CraftingFocusStack(Integer stackIndex, BlockPos offset) {
            this.stackIndex = stackIndex;
            this.offset = offset;
        }
    }
}

