/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.impl;

import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class PerkDestructionStack
extends ConstellationPerk {
    private static int multiplierCap = 10;
    private static float harvestSpeedMultiplier = 0.2f;
    private static float attackDamageMultiplier = 0.3f;

    public PerkDestructionStack() {
        super("DTR_STACK", ConstellationPerk.Target.ENTITY_ATTACK, ConstellationPerk.Target.PLAYER_HARVEST_SPEED);
    }

    @Override
    public float onEntityAttack(EntityPlayer attacker, EntityLivingBase attacked, float dmgIn) {
        int mul = MathHelper.func_76125_a((int)(this.getMultiplier(attacker) + 1), (int)1, (int)multiplierCap);
        this.setMultiplier(attacker, mul);
        return dmgIn *= 1.0f + attackDamageMultiplier * (float)mul;
    }

    @Override
    public float onHarvestSpeed(EntityPlayer harvester, IBlockState broken, @Nullable BlockPos at, float breakSpeedIn) {
        int mul = MathHelper.func_76125_a((int)(this.getMultiplier(harvester) + 1), (int)1, (int)multiplierCap);
        this.setMultiplier(harvester, mul);
        return breakSpeedIn *= 1.0f + harvestSpeedMultiplier * (float)mul;
    }

    private int getMultiplier(EntityPlayer player) {
        return MathHelper.func_76123_f((float)((float)this.getActiveCooldownForPlayer(player) / 30.0f));
    }

    private void setMultiplier(EntityPlayer player, int multiplier) {
        this.forceSetCooldownForPlayer(player, multiplier * 30);
    }

    @Override
    public boolean hasConfigEntries() {
        return true;
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        multiplierCap = cfg.getInt(this.getKey() + "MultiplierCap", this.getConfigurationSection(), multiplierCap, 1, 128, "Defines the cap for the harvestSpeed + damageIncrease multiplier-stacks.");
        harvestSpeedMultiplier = cfg.getFloat(this.getKey() + "HarvestSpeedMultiplier", this.getConfigurationSection(), harvestSpeedMultiplier, 0.0f, 32.0f, "Defines the multiplier per harvestSpeed stack. Multiple multipliers are additive.");
        attackDamageMultiplier = cfg.getFloat(this.getKey() + "AttackDamageMultiplier", this.getConfigurationSection(), attackDamageMultiplier, 0.0f, 32.0f, "Defines the multiplier per damageIncrease stack. Multiple multipliers are additive.");
    }
}

