/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk;

import hellfirepvp.astralsorcery.common.auxiliary.tick.ITickHandler;
import hellfirepvp.astralsorcery.common.constellation.perk.ConstellationPerk;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.enchantment.EnchantmentPlayerWornTick;
import hellfirepvp.astralsorcery.common.registry.RegistryEnchantments;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerPerkHandler
implements ITickHandler {
    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        EntityPlayer ticked = (EntityPlayer)context[0];
        PlayerProgress prog = ResearchManager.getProgress(ticked, (Side)context[1]);
        if (prog != null) {
            HashMap<ConstellationPerk, Integer> perks = new HashMap<ConstellationPerk, Integer>(prog.getAppliedPerks());
            for (ConstellationPerk perk : perks.keySet()) {
                if (!prog.isPerkActive(perk) || !perk.mayExecute(ConstellationPerk.Target.PLAYER_TICK)) continue;
                perk.onPlayerTick(ticked, (Side)context[1]);
            }
        }
        boolean client = ticked.func_130014_f_().field_72995_K;
        for (EnchantmentPlayerWornTick e : RegistryEnchantments.wearableTickEnchantments) {
            int max = EnchantmentHelper.func_185284_a((Enchantment)e, (EntityLivingBase)ticked);
            if (max <= 0) continue;
            e.onWornTick(client, ticked, max);
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.PLAYER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "PlayerPerkHandler";
    }
}

