/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.TileAccelerationBlacklist;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.effect.CEffectPositionList;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.GenListEntries;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopController;
import hellfirepvp.astralsorcery.common.util.effect.time.TimeStopZone;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectHorologium
extends CEffectPositionList {
    public boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static int searchRange = 16;
    public static int maxCount = 30;

    public CEffectHorologium(@Nullable ILocatable origin) {
        super(origin, Constellations.horologium, "horologium", maxCount, (world, pos) -> TileAccelerationBlacklist.canAccelerate(world.func_175625_s(pos)));
    }

    @Override
    public boolean playEffect(World world, BlockPos pos, float percStrength, ConstellationEffectProperties modified, @Nullable IMinorConstellation possibleTraitEffect) {
        BlockPos sel;
        if (!this.enabled) {
            return false;
        }
        if ((percStrength = (float)((double)percStrength * potencyMultiplier)) < 1.0f && world.field_73012_v.nextFloat() > percStrength) {
            return false;
        }
        if (modified.isCorrupted()) {
            TimeStopZone zone = TimeStopController.tryGetZoneAt(world, pos);
            if (zone == null) {
                zone = TimeStopController.freezeWorldAt(TimeStopZone.EntityTargetController.noPlayers(), world, pos, true, (float)modified.getSize(), 100);
            }
            if (zone == null) {
                return false;
            }
            zone.setTicksToLive(100);
            return true;
        }
        boolean changed = false;
        GenListEntries.SimpleBlockPosEntry entry = (GenListEntries.SimpleBlockPosEntry)this.getRandomElementByChance(rand);
        if (entry != null && MiscUtils.isChunkLoaded(world, new ChunkPos(sel = entry.getPos()))) {
            TileEntity te = world.func_175625_s(sel);
            if (TileAccelerationBlacklist.canAccelerate(te)) {
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.CE_ACCEL_TILE, sel.func_177958_n(), sel.func_177956_o(), sel.func_177952_p());
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)sel, 16.0));
                try {
                    long startNs = System.nanoTime();
                    for (int times = 5 + rand.nextInt(3); times > 0; --times) {
                        ((ITickable)te).func_73660_a();
                        if (System.nanoTime() - startNs >= 80000L) break;
                    }
                }
                catch (Exception exc) {
                    TileAccelerationBlacklist.errored(te.getClass());
                    this.removeElement(entry);
                    AstralSorcery.log.warn("[AstralSorcery] Couldn't accelerate TileEntity " + te.getClass().getName() + " properly.");
                    AstralSorcery.log.warn("[AstralSorcery] Temporarily blacklisting that class. Consider adding that to the blacklist if it persists?");
                    exc.printStackTrace();
                }
            } else {
                this.removeElement(entry);
                changed = true;
            }
        }
        if (this.findNewPosition(world, pos, modified)) {
            changed = true;
        }
        return changed;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playParticles(PktParticleEvent event) {
        Vector3 at = event.getVec();
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX() + 0.5, at.getY() + 0.5, at.getZ() + 0.5);
        p.motion(rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1), rand.nextFloat() * 0.03f * (float)(rand.nextBoolean() ? 1 : -1));
        p.scale(0.25f).setColor(Color.CYAN.brighter());
    }

    @Override
    public ConstellationEffectProperties provideProperties(int mirrorCount) {
        return new ConstellationEffectProperties(searchRange);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        searchRange = cfg.getInt(this.getKey() + "Range", this.getConfigurationSection(), searchRange, 1, 64, "Defines the radius (in blocks) in which the ritual will search for valid tileEntities to accelerate");
        maxCount = cfg.getInt(this.getKey() + "Count", this.getConfigurationSection(), 30, 1, 4000, "Defines the amount of tileEntities the ritual can cache and accelerate at max count");
        this.enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

