/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block.network;

import hellfirepvp.astralsorcery.common.block.network.BlockStarlightNetwork;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.Sounds;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.tile.network.TileCrystalPrismLens;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.SoundHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPrism
extends BlockStarlightNetwork
implements CrystalPropertyItem {
    private static final AxisAlignedBB boxPrismDown = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125);
    private static final AxisAlignedBB boxPrismUp = new AxisAlignedBB(0.1875, 0.125, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB boxPrismNorth = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.875);
    private static final AxisAlignedBB boxPrismSouth = new AxisAlignedBB(0.1875, 0.1875, 0.125, 0.8125, 0.8125, 1.0);
    private static final AxisAlignedBB boxPrismEast = new AxisAlignedBB(0.125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB boxPrismWest = new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.875, 0.8125, 0.8125);
    public static PropertyEnum<EnumFacing> PLACED_AGAINST = PropertyEnum.func_177709_a((String)"against", EnumFacing.class);

    public BlockPrism() {
        super(Material.field_151576_e, MapColor.field_151677_p);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149752_b(12.0f);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(PLACED_AGAINST, (Comparable)EnumFacing.DOWN));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        ItemStack stack = new ItemStack((Block)this);
        CrystalProperties.applyCrystalProperties(stack, CrystalProperties.getMaxCelestialProperties());
        list.add((Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        CrystalProperties.addPropertyTooltip(CrystalProperties.getCrystalProperties(stack), tooltip, this.getMaxSize(stack));
    }

    @Override
    public int getMaxSize(ItemStack stack) {
        return 900;
    }

    @Override
    @Nullable
    public CrystalProperties provideCurrentPropertiesOrNull(ItemStack stack) {
        return CrystalProperties.getCrystalProperties(stack);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b(PLACED_AGAINST)) {
            case NORTH: {
                return boxPrismNorth;
            }
            case SOUTH: {
                return boxPrismSouth;
            }
            case WEST: {
                return boxPrismWest;
            }
            case EAST: {
                return boxPrismEast;
            }
            case UP: {
                return boxPrismUp;
            }
        }
        return boxPrismDown;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.UP;
        for (EnumFacing f : EnumFacing.values()) {
            if (f.ordinal() != meta) continue;
            facing = f;
            break;
        }
        return this.func_176223_P().func_177226_a(PLACED_AGAINST, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(PLACED_AGAINST)).ordinal();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(PLACED_AGAINST, (Comparable)facing.func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PLACED_AGAINST});
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = super.getPickBlock(this.func_176221_a(state, (IBlockAccess)world, pos), target, world, pos, player);
        TileCrystalPrismLens lens = MiscUtils.getTileAt((IBlockAccess)world, pos, TileCrystalPrismLens.class, true);
        if (lens != null && lens.getCrystalProperties() != null) {
            CrystalProperties.applyCrystalProperties(stack, lens.getCrystalProperties());
        } else {
            CrystalProperties.applyCrystalProperties(stack, CrystalProperties.getMaxCelestialProperties());
        }
        return stack;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileCrystalPrismLens lens = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalPrismLens.class, true);
        if (lens != null && !worldIn.field_72995_K && !player.func_184812_l_()) {
            ItemStack drop;
            if (lens.getLensColor() != null) {
                drop = lens.getLensColor().asStack();
                ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
            }
            drop = new ItemStack((Block)BlocksAS.lensPrism);
            CrystalProperties.applyCrystalProperties(drop, lens.getCrystalProperties());
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileCrystalPrismLens lens;
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && (lens = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalPrismLens.class, true)) != null && lens.getLensColor() != null) {
            ItemStack drop = lens.getLensColor().asStack();
            ItemUtils.dropItemNaturally(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop);
            SoundHelper.playSoundAround((SoundEvent)Sounds.clipSwitch, worldIn, (Vec3i)pos, 0.8f, 1.5f);
            lens.setLensColor(null);
            return true;
        }
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileCrystalPrismLens();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileCrystalPrismLens te = MiscUtils.getTileAt((IBlockAccess)worldIn, pos, TileCrystalPrismLens.class, true);
        if (te == null) {
            return;
        }
        te.onPlace(CrystalProperties.getCrystalProperties(stack));
    }
}

