/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.block;

import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.block.BlockCustomName;
import hellfirepvp.astralsorcery.common.block.BlockVariants;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.RockCrystalBuffer;
import hellfirepvp.astralsorcery.common.item.crystal.base.ItemRockCrystalBase;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCustomOre
extends Block
implements BlockCustomName,
BlockVariants {
    public static boolean allowCrystalHarvest = false;
    private static final Random rand = new Random();
    public static PropertyEnum<OreType> ORE_TYPE = PropertyEnum.func_177709_a((String)"oretype", OreType.class);

    public BlockCustomOre() {
        super(Material.field_151576_e, MapColor.field_151670_w);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 3);
        this.func_149752_b(25.0f);
        this.func_149647_a(RegistryItems.creativeTabAstralSorcery);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (((OreType)((Object)state.func_177229_b(ORE_TYPE))).equals((Object)OreType.STARMETAL)) {
            ((RockCrystalBuffer)WorldCacheManager.getOrLoadData(worldIn, WorldCacheManager.SaveKey.ROCK_CRYSTAL)).removeOre(pos);
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (OreType t : OreType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, t.ordinal()));
        }
    }

    public int func_176201_c(IBlockState state) {
        OreType type = (OreType)((Object)state.func_177229_b(ORE_TYPE));
        return type.getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return meta < OreType.values().length ? this.func_176223_P().func_177226_a(ORE_TYPE, (Comparable)((Object)OreType.values()[meta])) : this.func_176223_P();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORE_TYPE});
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        OreType type = (OreType)((Object)state.func_177229_b(ORE_TYPE));
        if (type != OreType.ROCK_CRYSTAL || allowCrystalHarvest || this.securityCheck(worldIn, pos, player) && this.checkSafety(worldIn, pos)) {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        OreType type = (OreType)((Object)state.func_177229_b(ORE_TYPE));
        switch (type) {
            case ROCK_CRYSTAL: {
                if (world == null || !(world instanceof World) || !allowCrystalHarvest && (!this.checkSafety((World)world, pos) || !this.securityCheck((World)world, pos, (EntityPlayer)this.harvesters.get()))) break;
                drops.add((Object)ItemRockCrystalBase.createRandomBaseCrystal());
                for (int i = 0; i < fortune + 1; ++i) {
                    if (!((World)world).field_73012_v.nextBoolean()) continue;
                    drops.add((Object)ItemRockCrystalBase.createRandomBaseCrystal());
                }
                if (!((World)world).field_73012_v.nextBoolean()) break;
                drops.add((Object)ItemRockCrystalBase.createRandomBaseCrystal());
                break;
            }
            case STARMETAL: {
                drops.add((Object)new ItemStack((Block)this, 1, OreType.STARMETAL.ordinal()));
            }
        }
    }

    private boolean securityCheck(World world, BlockPos pos, EntityPlayer player) {
        return !world.field_72995_K && player != null && !MiscUtils.isPlayerFakeMP((EntityPlayerMP)player);
    }

    private boolean checkSafety(World world, BlockPos pos) {
        EntityPlayer player = world.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 10.0, false);
        return player != null && player.func_174818_b(pos) < 100.0;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return true;
    }

    public boolean func_149686_d(IBlockState state) {
        return true;
    }

    public boolean func_149730_j(IBlockState state) {
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return true;
    }

    @Override
    public String getIdentifierForMeta(int meta) {
        OreType ot = (OreType)((Object)this.func_176203_a(meta).func_177229_b(ORE_TYPE));
        return ot.func_176610_l();
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.singleEnumPropertyStates(this.func_176223_P(), (IProperty)ORE_TYPE, (Comparable[])OreType.values());
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        OreType ot = (OreType)((Object)state.func_177229_b(ORE_TYPE));
        return ot == OreType.ROCK_CRYSTAL && Config.rockCrystalOreSilkTouchHarvestable;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((OreType)((Object)state.func_177229_b(ORE_TYPE))).func_176610_l();
    }

    @SideOnly(value=Side.CLIENT)
    public static void playStarmetalOreEffects(PktParticleEvent event) {
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(event.getVec().getX() + (double)rand.nextFloat(), event.getVec().getY() + (double)rand.nextFloat(), event.getVec().getZ() + (double)rand.nextFloat());
        p.motion(0.0, (double)rand.nextFloat() * 0.05, 0.0);
        p.scale(0.2f);
    }

    public static enum OreType implements IStringSerializable
    {
        ROCK_CRYSTAL(0),
        STARMETAL(1);

        private final int meta;

        private OreType(int meta) {
            this.meta = meta;
        }

        public ItemStack asStack() {
            return new ItemStack((Block)BlocksAS.customOre, 1, this.meta);
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

