/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util.resource;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.awt.geom.Point2D;

public class SpriteSheetResource
extends AbstractRenderableTexture {
    private final double uPart;
    private final double vPart;
    private final int frameCount;
    private final int rows;
    private final int columns;
    private final AbstractRenderableTexture resource;

    public SpriteSheetResource(AbstractRenderableTexture resource, int rows, int columns) {
        if (rows <= 0 || columns <= 0) {
            throw new IllegalArgumentException("Can't instantiate a sprite sheet without any rows or columns!");
        }
        this.frameCount = rows * columns;
        this.rows = rows;
        this.columns = columns;
        this.resource = resource;
        this.uPart = 1.0 / (double)columns;
        this.vPart = 1.0 / (double)rows;
    }

    @Override
    public void bindTexture() {
        this.resource.bindTexture();
    }

    @Override
    public Point2D.Double getUVOffset() {
        long timer = ClientScheduler.getClientTick();
        Tuple<Double, Double> offset = this.getUVOffset(timer);
        return new Point2D.Double((Double)offset.key, (Double)offset.value);
    }

    @Override
    public double getUWidth() {
        return this.getULength();
    }

    @Override
    public double getVWidth() {
        return this.getVLength();
    }

    public AbstractRenderableTexture getResource() {
        return this.resource;
    }

    public double getULength() {
        return this.uPart;
    }

    public double getVLength() {
        return this.vPart;
    }

    public Tuple<Double, Double> getUVOffset(long frameTimer) {
        int frame = (int)(frameTimer % (long)this.frameCount);
        return new Tuple<Double, Double>((double)(frame % this.columns) * this.uPart, (double)(frame / this.columns) * this.vPart);
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }
}

