/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.event.ClientGatewayHandler;
import hellfirepvp.astralsorcery.client.sky.RenderAstralSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.ClientScreenshotCache;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.auxiliary.CelestialGatewaySystem;
import hellfirepvp.astralsorcery.common.data.world.data.GatewayCache;
import hellfirepvp.astralsorcery.common.tile.TileCelestialGateway;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;

public class UIGateway {
    private List<GatewayEntry> gatewayEntries = new LinkedList<GatewayEntry>();
    private final Vector3 origin;
    private final BlockPos gatewayPos;
    private final double radius;

    private UIGateway(BlockPos gatewayPos, Vector3 pos, double radius) {
        this.gatewayPos = gatewayPos;
        this.origin = pos;
        this.radius = radius;
    }

    public Vector3 getPos() {
        return this.origin;
    }

    public double getRadius() {
        return this.radius;
    }

    public static UIGateway initialize(World world, BlockPos gatewayPos, Vector3 source, double sphereRadius) {
        UIGateway ui = new UIGateway(gatewayPos, source, sphereRadius);
        CelestialGatewaySystem system = CelestialGatewaySystem.instance;
        int dimid = world.field_73011_w.getDimension();
        List<GatewayCache.GatewayNode> sameDimensionPositions = system.getGatewaysForWorld(world, Side.CLIENT);
        if (sameDimensionPositions != null) {
            UIGateway.gatherStars(ui, world.field_73011_w.getDimension(), sameDimensionPositions, true, sphereRadius);
        }
        for (Map.Entry<Integer, List<GatewayCache.GatewayNode>> entries : system.getGatewayCache(Side.CLIENT).entrySet()) {
            if (entries.getKey() == dimid) continue;
            List<GatewayCache.GatewayNode> otherPositions = entries.getValue();
            UIGateway.gatherStars(ui, entries.getKey(), otherPositions, false, sphereRadius);
        }
        return ui;
    }

    @Nullable
    public GatewayEntry findMatchingEntry(float yaw, float pitch) {
        float matchAccurancy = 4.0f;
        for (GatewayEntry entry : this.gatewayEntries) {
            if (!(Math.abs(entry.pitch - pitch) < matchAccurancy) || !(Math.abs(entry.yaw - yaw) <= matchAccurancy) && !(Math.abs(entry.yaw - yaw - 360.0f) <= matchAccurancy)) continue;
            return entry;
        }
        return null;
    }

    public boolean isValid(World w) {
        return MiscUtils.getTileAt((IBlockAccess)w, this.gatewayPos, TileCelestialGateway.class, true) != null;
    }

    private static void gatherStars(UIGateway gateway, int dimId, List<GatewayCache.GatewayNode> otherPositions, boolean sameWorld, double sphereRadius) {
        Vector3 gatePosition = gateway.getPos();
        for (GatewayCache.GatewayNode other : otherPositions) {
            Vector3 otherPos = new Vector3(other);
            if (sameWorld && otherPos.distance(gatePosition) < 16.0) continue;
            Vector3 direction = otherPos.subtract(gatePosition).normalize().multiply(sphereRadius);
            GatewayEntry potentialEntry = new GatewayEntry(other, dimId, direction);
            if (sameWorld) {
                boolean mayAdd = true;
                for (GatewayEntry entry : gateway.gatewayEntries) {
                    if (!(Math.abs(entry.pitch - potentialEntry.pitch) < 10.0f) || !(Math.abs(entry.yaw - potentialEntry.yaw) <= 10.0f) && !(Math.abs(entry.yaw - potentialEntry.yaw - 360.0f) <= 10.0f)) continue;
                    mayAdd = false;
                }
                if (!mayAdd) continue;
                gateway.gatewayEntries.add(potentialEntry);
                continue;
            }
            long seed = -6395079716991528811L;
            seed |= (long)other.func_177958_n() << 48;
            seed |= (long)other.func_177956_o() << 24;
            Random rand = new Random(seed |= (long)other.func_177952_p());
            direction = Vector3.positiveYRandom(rand).normalize().multiply(sphereRadius);
            potentialEntry = new GatewayEntry(other, dimId, direction);
            boolean foundSpace = false;
            for (int tries = 50; !foundSpace && tries > 0; --tries) {
                boolean mayAdd = true;
                for (GatewayEntry entry : gateway.gatewayEntries) {
                    if (!(Math.abs(entry.pitch - potentialEntry.pitch) < 25.0f) || !(Math.abs(entry.yaw - potentialEntry.yaw) <= 25.0f) && !(Math.abs(entry.yaw - potentialEntry.yaw - 360.0f) <= 25.0f)) continue;
                    mayAdd = false;
                }
                if (mayAdd) {
                    foundSpace = true;
                    continue;
                }
                direction = Vector3.positiveYRandom(rand).normalize().multiply(sphereRadius);
                potentialEntry = new GatewayEntry(other, dimId, direction);
            }
            if (!foundSpace) continue;
            gateway.gatewayEntries.add(potentialEntry);
        }
    }

    public void renderIntoWorld(float pticks) {
        String display;
        float a;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double dst = new Vector3(this.origin).distance(Vector3.atEntityCorner((Entity)player).addY(1.5));
        if (dst > 3.0) {
            return;
        }
        float alpha = 1.0f - (float)(dst / 2.0);
        alpha = MathHelper.func_76131_a((float)alpha, (float)0.0f, (float)1.0f);
        Color c = new Color(15777024);
        float red = (float)c.getRed() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        long seed = -6376616654017193693L;
        seed |= (long)this.origin.getBlockX() << 48;
        seed |= (long)this.origin.getBlockY() << 24;
        Random rand = new Random(seed |= (long)this.origin.getBlockZ());
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179118_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderAstralSkybox.TEX_STAR_1.bind();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        for (int i = 0; i < 300; ++i) {
            Vector3 dir = Vector3.random(rand).normalize().multiply(this.radius);
            a = RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), pticks, rand.nextInt(7) + 6);
            RenderingUtils.renderFacingFullQuadVB(vb, this.origin.getX() + dir.getX(), this.origin.getY() + dir.getY(), this.origin.getZ() + dir.getZ(), pticks, 0.07f, 0.0f, 1.0f, 1.0f, 1.0f, a *= alpha);
        }
        for (GatewayEntry entry : this.gatewayEntries) {
            a = RenderConstellation.conCFlicker(ClientScheduler.getClientTick(), pticks, rand.nextInt(7) + 6);
            a = 0.4f + 0.6f * a;
            RenderingUtils.renderFacingFullQuadVB(vb, this.origin.getX() + entry.relativePos.getX(), this.origin.getY() + entry.relativePos.getY(), this.origin.getZ() + entry.relativePos.getZ(), pticks, 0.16f, 0.0f, red, green, blue, a *= alpha);
        }
        RenderingUtils.sortVertexData(vb);
        tes.func_78381_a();
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GatewayEntry entry = this.findMatchingEntry(MathHelper.func_76142_g((float)player.field_70177_z), MathHelper.func_76142_g((float)player.field_70125_A));
        if (entry != null && (display = entry.originalBlockPos.display) != null && !display.isEmpty()) {
            GlStateManager.func_179094_E();
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            Vector3 pos = entry.relativePos.clone().add(this.origin);
            RenderingUtils.removeStandartTranslationFromTESRMatrix(pticks);
            GlStateManager.func_179137_b((double)pos.getX(), (double)(pos.getY() + 0.25), (double)pos.getZ());
            GlStateManager.func_179139_a((double)0.015, (double)-0.015, (double)0.015);
            GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-0.010416667f);
            float plRot = RenderingUtils.interpolateRotation(MathHelper.func_76142_g((float)player.field_70126_B), MathHelper.func_76142_g((float)player.field_70177_z), pticks);
            GlStateManager.func_179114_b((float)(-plRot + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            int length = fr.func_78256_a(display);
            fr.func_78276_b(display, -(length / 2), 0, -1997488896);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
    }

    public void renderGatewayTarget(float pTicks) {
        ResourceLocation screenshot;
        int focusTicks = ClientGatewayHandler.focusTicks;
        GatewayEntry focusingEntry = ClientGatewayHandler.focusingEntry;
        float perc = Math.min(40.0f, (float)focusTicks) / 40.0f * 0.5f;
        if (focusTicks > 50) {
            perc = (float)(focusTicks - 50) / 25.0f;
            perc = MathHelper.func_76131_a((float)perc, (float)0.5f, (float)1.0f);
        }
        if ((screenshot = ClientScreenshotCache.tryQueryTextureFor(focusingEntry.originalDimId, focusingEntry.originalBlockPos)) != null) {
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(screenshot);
            GlStateManager.func_179147_l();
            Blending.DEFAULT.applyStateManager();
            GlStateManager.func_179118_c();
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            vb.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            Vector3 pos = focusingEntry.relativePos.clone().multiply(0.85).add(this.origin);
            RenderingUtils.renderFacingFullQuadVB(vb, pos.getX(), pos.getY(), pos.getZ(), pTicks, 0.4f, 0.0f, 1.0f, 1.0f, 1.0f, perc);
            tes.func_78381_a();
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
        }
    }

    public static class GatewayEntry {
        public final GatewayCache.GatewayNode originalBlockPos;
        public final int originalDimId;
        public final Vector3 relativePos;
        private final float yaw;
        private final float pitch;

        private GatewayEntry(GatewayCache.GatewayNode originalBlockPos, int originalDimId, Vector3 relativePos) {
            this.originalBlockPos = originalBlockPos;
            this.originalDimId = originalDimId;
            this.relativePos = relativePos.clone();
            if (this.relativePos.getY() < 0.0) {
                this.relativePos.setY(0);
            }
            Vector3 angles = relativePos.copyToPolar();
            this.yaw = (float)(180.0 - angles.getZ());
            this.pitch = Math.min(0.0f, (float)(-90.0 + angles.getY()));
        }
    }
}

