/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui;

import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.base.GuiSkyScreen;
import hellfirepvp.astralsorcery.client.gui.base.GuiWHScreen;
import hellfirepvp.astralsorcery.client.sky.RenderAstralSkybox;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.UISextantCache;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.distribution.WorldSkyHandler;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.item.tool.sextant.ItemSextant;
import hellfirepvp.astralsorcery.common.item.tool.sextant.SextantFinder;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.client.PktSetSextantTarget;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiSextantSelector
extends GuiWHScreen
implements GuiSkyScreen {
    private static final Random rand = new Random();
    private static final AbstractRenderableTexture textureSextant = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "gridsextant");
    private static final Rectangle2D.Float partFrame = new Rectangle2D.Float(0.0f, 0.0f, 0.8974359f, 1.0f);
    private static final Rectangle2D.Float partSelectFrame = new Rectangle2D.Float(0.8974359f, 0.39285713f, 0.09615385f, 0.10714286f);
    private static final Rectangle2D.Float partIconSize = new Rectangle2D.Float(0.0f, 0.0f, 0.051282052f, 0.114285715f);
    private static final Rectangle2D.Float partArrowDown = new Rectangle2D.Float(0.8974359f, 0.2857143f, 0.03846154f, 0.028571429f);
    private static final Rectangle2D.Float partArrowUp = new Rectangle2D.Float(0.8974359f, 0.31428573f, 0.03846154f, 0.028571429f);
    private static final Rectangle2D.Float partFrameCornerUpLeft = new Rectangle2D.Float(0.8974359f, 0.34642857f, 0.01923077f, 0.021428572f);
    private static final Rectangle2D.Float partFrameCornerUpRight = new Rectangle2D.Float(0.9198718f, 0.34642857f, 0.01923077f, 0.021428572f);
    private static final Rectangle2D.Float partFrameCornerDownLeft = new Rectangle2D.Float(0.8974359f, 0.37142858f, 0.01923077f, 0.021428572f);
    private static final Rectangle2D.Float partFrameCornerDownRight = new Rectangle2D.Float(0.9198718f, 0.37142858f, 0.01923077f, 0.021428572f);
    private static final Rectangle2D.Float partFrameEdgeLeft = new Rectangle2D.Float(0.8974359f, 0.36785713f, 0.01923077f, 0.0035714286f);
    private static final Rectangle2D.Float partFrameEdgeUp = new Rectangle2D.Float(0.9166667f, 0.34642857f, 0.0032051282f, 0.021428572f);
    private static final Rectangle2D.Float partFrameEdgeRight = new Rectangle2D.Float(0.9198718f, 0.36785713f, 0.01923077f, 0.0035714286f);
    private static final Rectangle2D.Float partFrameEdgeDown = new Rectangle2D.Float(0.9166667f, 0.37142858f, 0.0032051282f, 0.021428572f);
    private static final int selectionsPerFrame = 4;
    private static final int randomStars = 85;
    private List<StarPosition> usedStars = new ArrayList<StarPosition>(85);
    private static final int showupDelay = 20;
    private Map<SextantFinder.TargetObject, Tuple<BlockPos, Integer>> showupTargets = new HashMap<SextantFinder.TargetObject, Tuple<BlockPos, Integer>>();
    private List<SextantFinder.TargetObject> availableTargets = new LinkedList<SextantFinder.TargetObject>();
    private SextantFinder.TargetObject selectedTarget = null;
    private int selectionOffset;
    private final EnumHand usedHand;
    private Rectangle2D.Double rArrowDown;
    private Rectangle2D.Double rArrowUp;
    private Map<Rectangle2D.Double, SextantFinder.TargetObject> selectMap = new HashMap<Rectangle2D.Double, SextantFinder.TargetObject>();
    private Map<Rectangle2D.Double, SextantFinder.TargetObject> dropMap = new HashMap<Rectangle2D.Double, SextantFinder.TargetObject>();
    private SextantFinder.TargetObject dragging = null;
    private boolean grabCursor = false;

    public GuiSextantSelector(ItemStack sextant, EnumHand hand) {
        super(280, 280);
        SextantFinder.TargetObject selectedTarget;
        this.usedHand = hand;
        Optional<Long> currSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
        currSeed.ifPresent(this::setupInitialStars);
        Tuple<BlockPos, Integer> target = ItemSextant.getCurrentTargetInformation(sextant);
        if (target != null && Minecraft.func_71410_x().field_71441_e != null && ((Integer)target.value).intValue() == Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() && (selectedTarget = ItemSextant.getTarget(sextant)) != null) {
            this.selectedTarget = selectedTarget;
            this.showupTargets.put(selectedTarget, target);
        }
        for (SextantFinder.TargetObject to : SextantFinder.getSelectableTargets()) {
            if (!to.isSelectable(sextant, ResearchManager.clientProgress)) continue;
            this.availableTargets.add(to);
        }
        this.selectionOffset = this.selectedTarget == null ? 0 : this.availableTargets.indexOf(this.selectedTarget);
    }

    private void setupInitialStars(long seed) {
        int i;
        int offsetX = 6;
        int offsetY = 6;
        int width = this.guiWidth - 6;
        int height = this.guiHeight - 6;
        Random rand = new Random(seed);
        int day = (int)(Minecraft.func_71410_x().field_71441_e.func_72820_D() / 24000L);
        for (i = 0; i < day; ++i) {
            rand.nextLong();
        }
        for (i = 0; i < 85; ++i) {
            this.usedStars.add(new StarPosition((float)offsetX + rand.nextFloat() * (float)width, (float)offsetY + rand.nextFloat() * (float)height));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        for (SextantFinder.TargetObject to : this.availableTargets) {
            BlockPos target;
            if (this.showupTargets.containsKey(to) || (target = UISextantCache.queryLocation(Minecraft.func_71410_x().field_71439_g.func_180425_c(), Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension(), to)) == null) continue;
            this.showupTargets.put(to, new Tuple<BlockPos, Integer>(target, 0));
        }
        for (SextantFinder.TargetObject to : this.showupTargets.keySet()) {
            Tuple<BlockPos, Integer> showupTpl = this.showupTargets.get(to);
            if ((Integer)showupTpl.value >= 20) continue;
            this.showupTargets.put(to, new Tuple(showupTpl.key, (Integer)showupTpl.value + 1));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (!Minecraft.field_142025_a) {
            KeyBinding.func_186704_a();
        }
        this.field_146297_k.field_71417_B.func_74372_a();
        this.field_146297_k.field_71415_G = true;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (!Minecraft.field_142025_a) {
            KeyBinding.func_186704_a();
        }
        this.field_146297_k.field_71417_B.func_74372_a();
        this.field_146297_k.field_71415_G = true;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.selectMap.clear();
        this.dropMap.clear();
        this.rArrowDown = null;
        this.rArrowUp = null;
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        this.handleMouseMovement(partialTicks);
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((this.guiLeft + 8) * res.func_78325_e()), (int)((this.guiTop + 8) * res.func_78325_e()), (int)((this.guiWidth - 16) * res.func_78325_e()), (int)((this.guiHeight - 15) * res.func_78325_e()));
        this.drawSkyScreen(partialTicks, mouseX, mouseY);
        GL11.glDisable((int)3089);
        textureSextant.bindTexture();
        this.field_73735_i += 20.0f;
        this.drawTexturedRect((double)this.guiLeft, (double)this.guiTop, (double)this.guiWidth, (double)this.guiHeight, partFrame);
        this.field_73735_i -= 20.0f;
        TextureHelper.refreshTextureBindState();
        this.drawSelectorBox(this.guiLeft + this.guiWidth + 10, (double)this.guiTop + ((double)this.guiHeight / 2.0 - 32.0 - 6.0), this.availableTargets, this.selectedTarget == null ? -1 : this.availableTargets.indexOf(this.selectedTarget));
        if (this.dragging != null) {
            Blending.DEFAULT.applyStateManager();
            this.field_73735_i += 30.0f;
            this.dragging.getRenderable().bindTexture();
            this.drawTexturedRect((double)(mouseX - 8), (double)(mouseY - 8), 16.0, 16.0, this.dragging.getRenderable());
            this.field_73735_i -= 30.0f;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
    }

    private void drawSkyScreen(float partialTicks, double mouseX, double mouseY) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        float pitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
        float transparency = 0.0f;
        if (pitch < -20.0f) {
            transparency = 1.0f;
        } else if (pitch < 10.0f) {
            transparency = 1.0f - Math.abs(pitch + 20.0f) / 30.0f;
            if (ConstellationSkyHandler.getInstance().isNight((World)w)) {
                transparency *= transparency;
            }
        }
        boolean canSeeSky = this.canSeeSky((World)w);
        this.drawGridBackground(partialTicks, canSeeSky, transparency);
        this.drawEffectBackground(partialTicks, canSeeSky, transparency, mouseX, mouseY);
    }

    private void drawEffectBackground(float partialTicks, boolean canSeeSky, float transparency, double mouseX, double mouseY) {
        if (this.usedStars.isEmpty()) {
            Optional<Long> currSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent((World)Minecraft.func_71410_x().field_71441_e);
            if (!currSeed.isPresent()) {
                return;
            }
            this.setupInitialStars(currSeed.get());
        }
        this.field_73735_i += 5.0f;
        this.dropMap.putAll(this.drawCellWithEffects(partialTicks, canSeeSky, transparency, mouseX, mouseY));
        this.field_73735_i -= 5.0f;
    }

    private Map<Rectangle2D.Double, SextantFinder.TargetObject> drawCellWithEffects(float partialTicks, boolean canSeeSky, float transparency, double mouseX, double mouseY) {
        if (canSeeSky) {
            int offsetX = this.guiLeft;
            int offsetZ = this.guiTop;
            this.field_73735_i += 1.0f;
            this.drawCellEffect(offsetX, offsetZ, this.getGuiWidth(), this.getGuiHeight(), partialTicks, transparency);
            this.field_73735_i -= 1.0f;
        }
        Vector3 iPosPlayer = RenderingUtils.interpolatePosition((Entity)Minecraft.func_71410_x().field_71439_g, partialTicks).setY(0);
        this.field_73735_i += 10.0f;
        HashMap<Rectangle2D.Double, SextantFinder.TargetObject> targets = new HashMap<Rectangle2D.Double, SextantFinder.TargetObject>();
        for (Map.Entry<SextantFinder.TargetObject, Tuple<BlockPos, Integer>> visibleTarget : this.showupTargets.entrySet()) {
            Color c;
            float alpha;
            float dayMultiplier = ConstellationSkyHandler.getInstance().getCurrentDaytimeDistribution((World)Minecraft.func_71410_x().field_71441_e);
            if (dayMultiplier <= 0.1f) continue;
            SextantFinder.TargetObject target = visibleTarget.getKey();
            BlockPos actualPos = (BlockPos)visibleTarget.getValue().key;
            float alphaShowup = MathHelper.func_76131_a((float)(((float)((Integer)visibleTarget.getValue().value).intValue() + partialTicks) / 20.0f), (float)0.0f, (float)1.0f);
            Vector3 dir = new Vector3(actualPos).setY(0).subtract(iPosPlayer);
            Vector3 polar = dir.clone().copyToPolar();
            if (polar.getX() <= 20.0) continue;
            double yaw = 180.0 - polar.getZ();
            double pitch = polar.getX() >= 350.0 ? -20.0 : Math.min(-20.0, -20.0 - (70.0 - 70.0 * (polar.getX() / 350.0)));
            float playerYaw = Minecraft.func_71410_x().field_71439_g.field_70177_z % 360.0f;
            if (playerYaw < 0.0f) {
                playerYaw += 360.0f;
            }
            if (playerYaw >= 180.0f) {
                playerYaw -= 360.0f;
            }
            float playerPitch = Minecraft.func_71410_x().field_71439_g.field_70125_A;
            double diffYaw = (double)playerYaw - yaw;
            double diffPitch = (double)playerPitch - pitch;
            if (diffYaw >= 180.0) {
                diffYaw -= 360.0;
            }
            float xsFactor = 100.0f;
            float ysFactor = 60.0f;
            int wPart = (int)((float)this.field_146294_l * 0.1f);
            int hPart = (int)((float)this.field_146295_m * 0.1f);
            RenderAstralSkybox.TEX_STAR_1.bind();
            double offsetX = this.guiLeft + wPart - MathHelper.func_76128_c((double)(diffYaw / (double)xsFactor * (double)this.field_146294_l));
            double offsetY = this.guiTop + hPart - MathHelper.func_76128_c((double)(diffPitch / (double)ysFactor * (double)this.field_146295_m));
            if (this.selectedTarget != null && target.equals(this.selectedTarget)) {
                alpha = RenderConstellation.conCFlicker(ClientScheduler.getClientTick() + (long)actualPos.func_177958_n(), partialTicks, 8);
                alpha = (0.6f + 0.4f * alpha) * dayMultiplier * alphaShowup * transparency;
                c = new Color(target.getColorTheme(), false);
                GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)alpha);
                this.drawInfoStar((float)offsetX + 8.0f, (float)offsetY + 8.0f, this.field_73735_i, 24.0f, partialTicks);
            } else {
                alpha = RenderConstellation.conCFlicker(ClientScheduler.getClientTick() + (long)actualPos.func_177958_n(), partialTicks, 8);
                alpha = (0.2f + 0.8f * alpha) * dayMultiplier * alphaShowup * transparency;
                c = new Color(target.getColorTheme(), false);
                GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)alpha);
                this.drawTexturedRect(offsetX, offsetY, 16.0, 16.0, 0.0f, 0.0f, 1.0f, 1.0f);
            }
            Rectangle2D.Double rct = new Rectangle2D.Double(offsetX, offsetY, 16.0, 16.0);
            if (this.selectedTarget != null && this.selectedTarget.equals(target) || this.grabCursor && rct.contains(mouseX, mouseY) && ResearchManager.clientProgress.getUsedTargets().contains(target)) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                target.getRenderable().bindTexture();
                this.drawTexturedRect(offsetX - 8.0, offsetY - 8.0, 32.0, 32.0, target.getRenderable());
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            TextureHelper.refreshTextureBindState();
            targets.put(rct, target);
        }
        this.field_73735_i -= 10.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return targets;
    }

    private void drawCellEffect(int offsetX, int offsetY, int guiWidth, int guiHeight, float partialTicks, float transparency) {
        WorldSkyHandler handle = ConstellationSkyHandler.getInstance().getWorldHandler((World)Minecraft.func_71410_x().field_71441_e);
        int lastTracked = handle == null ? 5 : handle.lastRecordedDay;
        Random r = new Random();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderAstralSkybox.TEX_STAR_1.bind();
        for (StarPosition stars : this.usedStars) {
            r.setSeed(stars.seed);
            GlStateManager.func_179094_E();
            float brightness = 0.3f + RenderConstellation.stdFlicker(ClientScheduler.getClientTick(), partialTicks, 5 + r.nextInt(15)) * 0.6f;
            brightness *= Minecraft.func_71410_x().field_71441_e.func_72880_h(partialTicks) * 2.0f * transparency;
            GlStateManager.func_179131_c((float)(brightness *= 1.0f - Minecraft.func_71410_x().field_71441_e.func_72867_j(partialTicks)), (float)brightness, (float)brightness, (float)brightness);
            int size = r.nextInt(4) + 3;
            this.drawRect(MathHelper.func_76141_d((float)((float)offsetX + stars.x)), MathHelper.func_76141_d((float)((float)offsetY + stars.y)), size, size);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
        }
        Random cstRand = new Random(lastTracked * 31);
        for (int i = 0; i < 5 + cstRand.nextInt(10); ++i) {
            cstRand.nextLong();
        }
    }

    private void drawGridBackground(float partialTicks, boolean canSeeSky, float transparency) {
        Blending.PREALPHA.applyStateManager();
        Tuple<Color, Color> fromTo = GuiSkyScreen.getRBGFromTo(canSeeSky, transparency, partialTicks);
        RenderingUtils.drawGradientRect(this.guiLeft, this.guiTop, this.field_73735_i, this.guiLeft + this.guiWidth, this.guiTop + this.guiHeight, (Color)fromTo.key, (Color)fromTo.value);
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        GlStateManager.func_179147_l();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
    }

    private void drawSelectorBox(double offsetX, double offsetY, List<SextantFinder.TargetObject> objects, int selectedOption) {
        textureSextant.bindTexture();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int totalInnerHeight = Math.min(4, objects.size()) * 16;
        GL11.glEnable((int)3042);
        int yShift = objects.size() >= 4 ? 0 : (4 - objects.size()) * 8;
        offsetY += (double)yShift;
        if (objects.size() <= 4) {
            this.selectionOffset = 0;
        } else if (this.selectionOffset + 4 > objects.size()) {
            this.selectionOffset = objects.size() - 4;
        }
        boolean drawPrevArrow = this.selectionOffset > 0;
        boolean drawNextArrow = this.selectionOffset + 4 < objects.size();
        this.drawTexturedRect(offsetX, offsetY, 6.0, 6.0, partFrameCornerUpLeft);
        this.drawTexturedRect(offsetX + 6.0 + 16.0, offsetY, 6.0, 6.0, partFrameCornerUpRight);
        this.drawTexturedRect(offsetX, offsetY + 6.0 + (double)totalInnerHeight, 6.0, 6.0, partFrameCornerDownLeft);
        this.drawTexturedRect(offsetX + 6.0 + 16.0, offsetY + 6.0 + (double)totalInnerHeight, 6.0, 6.0, partFrameCornerDownRight);
        this.drawTexturedRect(offsetX + 6.0, offsetY, 16.0, 6.0, partFrameEdgeUp);
        this.drawTexturedRect(offsetX + 6.0, offsetY + 6.0 + (double)totalInnerHeight, 16.0, 6.0, partFrameEdgeDown);
        this.drawTexturedRect(offsetX, offsetY + 6.0, 6.0, (double)totalInnerHeight, partFrameEdgeLeft);
        this.drawTexturedRect(offsetX + 6.0 + 16.0, offsetY + 6.0, 6.0, (double)totalInnerHeight, partFrameEdgeRight);
        GlStateManager.func_179090_x();
        GlStateManager.func_179142_g();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.3f);
        this.drawTexturedRect(offsetX + 6.0, offsetY + 6.0, 16.0, totalInnerHeight, 0.0f, 0.0f, 1.0f, 1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179119_h();
        GlStateManager.func_179098_w();
        if (drawPrevArrow) {
            this.drawTexturedRect(offsetX + 8.0, offsetY - 10.0, 12.0, 7.0, partArrowUp);
            this.rArrowUp = new Rectangle2D.Double(offsetX + 8.0, offsetY - 10.0, 12.0, 7.0);
        }
        if (drawNextArrow) {
            this.drawTexturedRect(offsetX + 8.0, offsetY + 3.0 + 12.0 + (double)totalInnerHeight, 12.0, 7.0, partArrowDown);
            this.rArrowDown = new Rectangle2D.Double(offsetX + 8.0, offsetY + 3.0 + 12.0 + (double)totalInnerHeight, 12.0, 7.0);
        }
        int internalOffset = 0;
        int selectedInternal = -1;
        for (int i = this.selectionOffset; i < this.selectionOffset + Math.min(4, objects.size()); ++i) {
            SextantFinder.TargetObject to = objects.get(i);
            AbstractRenderableTexture tex = to.getRenderable();
            tex.bindTexture();
            this.drawTexturedRect(offsetX + 6.0, offsetY + 6.0 + (double)(internalOffset * 16), 16.0, 16.0, tex);
            this.selectMap.put(new Rectangle2D.Double(offsetX + 6.0, offsetY + 6.0 + (double)(internalOffset * 16), 16.0, 16.0), to);
            if (i == selectedOption) {
                selectedInternal = internalOffset;
            }
            ++internalOffset;
        }
        if (selectedInternal >= 0) {
            textureSextant.bindTexture();
            this.drawTexturedRect(offsetX, offsetY + (double)(selectedInternal * 16), 28.0, 28.0, partSelectFrame);
        }
        TextureHelper.refreshTextureBindState();
    }

    private boolean canSeeSky(World renderWorld) {
        BlockPos playerPos = Minecraft.func_71410_x().field_71439_g.func_180425_c();
        for (int xx = -1; xx <= 1; ++xx) {
            for (int zz = -1; zz <= 1; ++zz) {
                BlockPos other = playerPos.func_177982_a(xx, 0, zz);
                if (renderWorld.func_175678_i(other)) continue;
                return false;
            }
        }
        return renderWorld.func_175678_i(playerPos.func_177984_a());
    }

    private void handleMouseMovement(float pticks) {
        boolean ctrl = GuiSextantSelector.func_146272_n();
        if (this.grabCursor && !ctrl) {
            if (!Minecraft.field_142025_a) {
                KeyBinding.func_186704_a();
            }
            Minecraft.func_71410_x().field_71417_B.func_74372_a();
            Minecraft.func_71410_x().field_71415_G = true;
            this.grabCursor = false;
        }
        if (!this.grabCursor && ctrl) {
            Minecraft.func_71410_x().field_71417_B.func_74373_b();
            Minecraft.func_71410_x().field_71415_G = false;
            this.grabCursor = true;
        }
        if (!ctrl) {
            float movementY;
            float movementX;
            float f = this.field_146297_k.field_71474_y.field_74341_c * 0.6f + 0.2f;
            float f1 = f * f * f * 8.0f;
            float f2 = (float)this.field_146297_k.field_71417_B.field_74377_a * f1;
            float f3 = (float)this.field_146297_k.field_71417_B.field_74375_b * f1;
            int i = 1;
            if (this.field_146297_k.field_71474_y.field_74338_d) {
                i = -1;
            }
            EntityRenderer er = Minecraft.func_71410_x().field_71460_t;
            if (this.field_146297_k.field_71474_y.field_74326_T) {
                er.field_78496_H += f2;
                er.field_78497_I += f3;
                float f4 = pticks - er.field_78492_L;
                er.field_78492_L = pticks;
                f2 = er.field_78498_J * f4;
                f3 = er.field_78499_K * f4;
                movementX = f2;
                movementY = f3 * (float)i;
            } else {
                er.field_78496_H = 0.0f;
                er.field_78497_I = 0.0f;
                movementX = f2;
                movementY = f3 * (float)i;
            }
            boolean nullify = this.field_146297_k.field_71439_g.field_70125_A <= -89.99f && Math.abs(movementY) == movementY;
            this.field_146297_k.field_71439_g.func_70082_c(movementX, movementY);
            if (nullify) {
                movementY = 0.0f;
            }
            this.handleHandMovement(MathHelper.func_76141_d((float)movementX), MathHelper.func_76141_d((float)movementY));
        }
    }

    private void handleHandMovement(int changeX, int changeY) {
        int offsetX = 6;
        int offsetY = 6;
        int width = this.guiWidth - 12;
        int height = this.guiHeight - 12;
        Iterator<StarPosition> iterator = this.usedStars.iterator();
        while (iterator.hasNext()) {
            StarPosition sl;
            StarPosition starPosition = sl = iterator.next();
            starPosition.x = starPosition.x - (float)changeX;
            starPosition = sl;
            starPosition.y = starPosition.y + (float)changeY;
            if (sl.x < (float)offsetX) {
                starPosition = sl;
                starPosition.x = starPosition.x + (float)width;
            } else if (sl.x > (float)(offsetX + width)) {
                starPosition = sl;
                starPosition.x = starPosition.x - (float)width;
            }
            if (sl.y < (float)offsetY) {
                starPosition = sl;
                starPosition.y = starPosition.y + (float)height;
                continue;
            }
            if (!(sl.y > (float)(offsetY + height))) continue;
            starPosition = sl;
            starPosition.y = starPosition.y - (float)height;
        }
    }

    private Rectangle drawInfoStar(float offsetX, float offsetY, float zLevel, float widthHeightBase, float pTicks) {
        float tick = (float)ClientScheduler.getClientTick() + pTicks;
        float deg = tick * 2.0f % 360.0f;
        float wh = widthHeightBase - widthHeightBase / 6.0f * (MathHelper.func_76126_a((float)((float)Math.toRadians(tick * 4.0f % 360.0f))) + 1.0f);
        this.drawInfoStarSingle(offsetX, offsetY, zLevel, wh, Math.toRadians(deg));
        deg = (tick + 22.5f) * 2.0f % 360.0f;
        wh = widthHeightBase - widthHeightBase / 6.0f * (MathHelper.func_76126_a((float)((float)Math.toRadians((tick + 45.0f) * 4.0f % 360.0f))) + 1.0f);
        this.drawInfoStarSingle(offsetX, offsetY, zLevel, wh, Math.toRadians(deg));
        return new Rectangle(MathHelper.func_76141_d((float)(offsetX - widthHeightBase / 2.0f)), MathHelper.func_76141_d((float)(offsetY - widthHeightBase / 2.0f)), MathHelper.func_76141_d((float)widthHeightBase), MathHelper.func_76141_d((float)widthHeightBase));
    }

    private void drawInfoStarSingle(float offsetX, float offsetY, float zLevel, float widthHeight, double deg) {
        GlStateManager.func_179094_E();
        RenderAstralSkybox.TEX_STAR_1.bind();
        Vector3 offset = new Vector3((double)(-widthHeight) / 2.0, (double)(-widthHeight) / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv01 = new Vector3((double)(-widthHeight) / 2.0, (double)widthHeight / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv11 = new Vector3((double)widthHeight / 2.0, (double)widthHeight / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Vector3 uv10 = new Vector3((double)widthHeight / 2.0, (double)(-widthHeight) / 2.0, 0.0).rotate(deg, Vector3.RotAxis.Z_AXIS);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)offsetX + uv01.getX(), (double)offsetY + uv01.getY(), (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)offsetX + uv11.getX(), (double)offsetY + uv11.getY(), (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)offsetX + uv10.getX(), (double)offsetY + uv10.getY(), (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)offsetX + offset.getX(), (double)offsetY + offset.getY(), (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        tes.func_78381_a();
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            if (this.rArrowUp != null && this.rArrowUp.contains(mouseX, mouseY)) {
                --this.selectionOffset;
            } else if (this.rArrowDown != null && this.rArrowDown.contains(mouseX, mouseY)) {
                ++this.selectionOffset;
            } else {
                SextantFinder.TargetObject to;
                Rectangle2D.Double sel = MiscUtils.iterativeSearch(this.selectMap.keySet(), rect -> rect.contains(mouseX, mouseY));
                if (sel != null && (to = this.selectMap.get(sel)) != null) {
                    this.dragging = to;
                }
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 0 && this.dragging != null) {
            SextantFinder.TargetObject to;
            Rectangle2D.Double sel = MiscUtils.iterativeSearch(this.dropMap.keySet(), rect -> rect.contains(mouseX, mouseY));
            if (sel != null && (to = this.dropMap.get(sel)) != null && to.equals(this.dragging)) {
                PacketChannel.CHANNEL.sendToServer((IMessage)new PktSetSextantTarget(to, this.usedHand));
                this.selectedTarget = to;
            }
            this.dragging = null;
        }
    }

    static /* synthetic */ Random access$400() {
        return rand;
    }

    private static class StarPosition {
        private float x;
        private float y;
        private long seed = GuiSextantSelector.access$400().nextLong();

        private StarPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }
}

