/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.AbstractServerCommandTyped;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class PacketRequestDataFromServer
extends AbstractServerCommandTyped {
    private String modid;

    public PacketRequestDataFromServer() {
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.modid = NetworkTools.readString(buf);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        NetworkTools.writeString(buf, this.modid);
    }

    public PacketRequestDataFromServer(String modid, BlockPos pos, String command, TypedMap params) {
        super(pos, command, params);
        this.modid = modid;
    }

    public static class Handler
    implements IMessageHandler<PacketRequestDataFromServer, IMessage> {
        public IMessage onMessage(PacketRequestDataFromServer message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketRequestDataFromServer message, MessageContext ctx) {
            TileEntity te = ctx.getServerHandler().field_147369_b.func_130014_f_().func_175625_s(message.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log("createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            TypedMap result = commandHandler.executeWithResult(message.command, message.params);
            if (result == null) {
                Logging.log("Command " + message.command + " was not handled!");
                return;
            }
            this.sendReplyToClient(message, result, ctx.getServerHandler().field_147369_b);
        }

        private void sendReplyToClient(PacketRequestDataFromServer message, TypedMap result, EntityPlayerMP player) {
            SimpleNetworkWrapper wrapper = PacketHandler.modNetworking.get(message.modid);
            PacketDataFromServer msg = new PacketDataFromServer(message.pos, message.command, result);
            wrapper.sendTo((IMessage)msg, player);
        }
    }
}

