/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.PacketDumpBlockInfo;
import mcjty.lib.network.PacketDumpItemInfo;
import mcjty.lib.network.PacketRequestDataFromServer;
import mcjty.lib.network.PacketSendClientCommand;
import mcjty.lib.network.PacketSendClientCommandHandler;
import mcjty.lib.network.PacketSendGuiData;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.typed.TypedMap;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public static final int INTERNAL_PACKETS = 12;
    private static int packetId = 12;
    public static Map<String, SimpleNetworkWrapper> modNetworking = new HashMap<String, SimpleNetworkWrapper>();

    public static int nextPacketID() {
        return packetId++;
    }

    public static SimpleNetworkWrapper registerMessages(String modid, String channelName) {
        SimpleNetworkWrapper network = NetworkRegistry.INSTANCE.newSimpleChannel(channelName);
        PacketHandler.registerMessages(network);
        modNetworking.put(modid, network);
        return network;
    }

    public static int registerMessages(SimpleNetworkWrapper networkWrapper) {
        return PacketHandler.registerMessages(networkWrapper, 0);
    }

    public static int registerMessages(SimpleNetworkWrapper networkWrapper, int startIndex) {
        networkWrapper.registerMessage(PacketServerCommandTyped.Handler.class, PacketServerCommandTyped.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketSendServerCommand.Handler.class, PacketSendServerCommand.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketRequestDataFromServer.Handler.class, PacketRequestDataFromServer.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketDumpItemInfo.Handler.class, PacketDumpItemInfo.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketDumpBlockInfo.Handler.class, PacketDumpBlockInfo.class, startIndex++, Side.SERVER);
        networkWrapper.registerMessage(PacketSendClientCommandHandler.class, PacketSendClientCommand.class, startIndex++, Side.CLIENT);
        networkWrapper.registerMessage(PacketDataFromServer.Handler.class, PacketDataFromServer.class, startIndex++, Side.CLIENT);
        networkWrapper.registerMessage(PacketSendGuiData.Handler.class, PacketSendGuiData.class, startIndex++, Side.CLIENT);
        return startIndex;
    }

    public static void sendCommand(SimpleNetworkWrapper network, String modid, String command, @Nonnull TypedMap arguments) {
        network.sendToServer((IMessage)new PacketSendServerCommand(modid, command, arguments));
    }
}

