/*
 * Decompiled with CFR 0.152.
 */
package vazkii.morphtool;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.morphtool.ConfigHandler;
import vazkii.morphtool.ModItems;
import vazkii.morphtool.MorphTool;

public final class MorphingHandler {
    public static final MorphingHandler INSTANCE = new MorphingHandler();
    public static final String MINECRAFT = "minecraft";
    public static final String TAG_MORPHING_TOOL = "morphtool:is_morphing";
    public static final String TAG_MORPH_TOOL_DATA = "morphtool:data";
    public static final String TAG_MORPH_TOOL_DISPLAY_NAME = "morphtool:displayName";
    private static final Map<String, String> modNames = new HashMap<String, String>();

    @SubscribeEvent
    public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
        IBlockState state;
        String mod;
        ItemStack newStack;
        RayTraceResult res;
        EntityPlayer player;
        ItemStack mainHandItem;
        if (event.getEntity() instanceof EntityPlayer && MorphingHandler.isMorphTool(mainHandItem = (player = (EntityPlayer)event.getEntity()).func_184586_b(ConfigHandler.invertHandShift ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND)) && (res = MorphingHandler.raycast((Entity)player, 4.5)) != null && (newStack = MorphingHandler.getShiftStackForMod(mainHandItem, mod = MorphingHandler.getModFromState(state = player.func_130014_f_().func_180495_p(res.func_178782_a())))) != mainHandItem && !ItemStack.func_179545_c((ItemStack)newStack, (ItemStack)mainHandItem)) {
            player.field_71071_by.func_70299_a(ConfigHandler.invertHandShift ? player.field_71071_by.func_70302_i_() - 1 : player.field_71071_by.field_70461_c, newStack);
            MorphTool.proxy.updateEquippedItem();
        }
    }

    @SubscribeEvent
    public void onItemDropped(ItemTossEvent event) {
        if (!event.getPlayer().func_70093_af()) {
            return;
        }
        EntityItem e = event.getEntityItem();
        ItemStack stack = e.func_92059_d();
        MorphingHandler.removeItemFromTool((Entity)e, stack, false, copy -> e.func_92058_a(copy));
    }

    @SubscribeEvent
    public void onItemBroken(PlayerDestroyItemEvent event) {
        MorphingHandler.removeItemFromTool((Entity)event.getEntityPlayer(), event.getOriginal(), true, morph -> event.getEntityPlayer().func_184611_a(event.getHand(), morph));
    }

    public static void removeItemFromTool(Entity e, ItemStack stack, boolean itemBroken, Consumer<ItemStack> consumer) {
        if (!stack.func_190926_b() && MorphingHandler.isMorphTool(stack) && stack.func_77973_b() != ModItems.tool) {
            NBTTagCompound morphData = stack.func_77978_p().func_74775_l(TAG_MORPH_TOOL_DATA).func_74737_b();
            ItemStack morph = MorphingHandler.makeMorphedStack(stack, MINECRAFT, morphData);
            NBTTagCompound newMorphData = morph.func_77978_p().func_74775_l(TAG_MORPH_TOOL_DATA);
            newMorphData.func_82580_o(MorphingHandler.getModFromStack(stack));
            if (!itemBroken) {
                ItemStack copy;
                NBTTagCompound copyCmp;
                if (!e.func_130014_f_().field_72995_K) {
                    EntityItem newItem = new EntityItem(e.func_130014_f_(), e.field_70165_t, e.field_70163_u, e.field_70161_v, morph);
                    e.func_130014_f_().func_72838_d((Entity)newItem);
                }
                if ((copyCmp = (copy = stack.func_77946_l()).func_77978_p()) == null) {
                    copyCmp = new NBTTagCompound();
                    copy.func_77982_d(copyCmp);
                }
                copyCmp.func_82580_o("display");
                String displayName = copyCmp.func_74779_i(TAG_MORPH_TOOL_DISPLAY_NAME);
                if (!displayName.isEmpty() && !displayName.equals(copy.func_82833_r())) {
                    copy.func_151001_c(displayName);
                }
                copyCmp.func_82580_o(TAG_MORPHING_TOOL);
                copyCmp.func_82580_o(TAG_MORPH_TOOL_DISPLAY_NAME);
                copyCmp.func_82580_o(TAG_MORPH_TOOL_DATA);
                consumer.accept(copy);
            } else {
                consumer.accept(morph);
            }
        }
    }

    public static String getModFromState(IBlockState state) {
        return MorphingHandler.getModOrAlias(state.func_177230_c().getRegistryName().func_110624_b());
    }

    public static String getModFromStack(ItemStack stack) {
        return MorphingHandler.getModOrAlias(stack.func_190926_b() ? MINECRAFT : stack.func_77973_b().getRegistryName().func_110624_b());
    }

    public static String getModOrAlias(String mod) {
        return ConfigHandler.aliases.containsKey(mod) ? ConfigHandler.aliases.get(mod) : mod;
    }

    public static ItemStack getShiftStackForMod(ItemStack stack, String mod) {
        if (!stack.func_77942_o()) {
            return stack;
        }
        String currentMod = MorphingHandler.getModFromStack(stack);
        if (mod.equals(currentMod)) {
            return stack;
        }
        NBTTagCompound morphData = stack.func_77978_p().func_74775_l(TAG_MORPH_TOOL_DATA);
        return MorphingHandler.makeMorphedStack(stack, mod, morphData);
    }

    public static ItemStack makeMorphedStack(ItemStack currentStack, String targetMod, NBTTagCompound morphData) {
        ItemStack stack;
        String currentMod = MorphingHandler.getModFromStack(currentStack);
        NBTTagCompound currentCmp = new NBTTagCompound();
        currentStack.func_77955_b(currentCmp);
        currentCmp = currentCmp.func_74737_b();
        if (currentCmp.func_74764_b("tag")) {
            currentCmp.func_74775_l("tag").func_82580_o(TAG_MORPH_TOOL_DATA);
        }
        if (!currentMod.equalsIgnoreCase(MINECRAFT) && !currentMod.equalsIgnoreCase("morphtool")) {
            morphData.func_74782_a(currentMod, (NBTBase)currentCmp);
        }
        if (targetMod.equals(MINECRAFT)) {
            stack = new ItemStack(ModItems.tool);
        } else {
            NBTTagCompound targetCmp = morphData.func_74775_l(targetMod);
            morphData.func_82580_o(targetMod);
            stack = new ItemStack(targetCmp);
            if (stack.func_190926_b()) {
                stack = new ItemStack(ModItems.tool);
            }
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound stackCmp = stack.func_77978_p();
        stackCmp.func_74782_a(TAG_MORPH_TOOL_DATA, (NBTBase)morphData);
        stackCmp.func_74757_a(TAG_MORPHING_TOOL, true);
        if (stack.func_77973_b() != ModItems.tool) {
            String displayName = stack.func_82833_r();
            if (stackCmp.func_74764_b(TAG_MORPH_TOOL_DISPLAY_NAME)) {
                displayName = stackCmp.func_74779_i(TAG_MORPH_TOOL_DISPLAY_NAME);
            } else {
                stackCmp.func_74778_a(TAG_MORPH_TOOL_DISPLAY_NAME, displayName);
            }
            stack.func_151001_c(TextFormatting.RESET + I18n.func_74837_a((String)"morphtool.sudo_name", (Object[])new Object[]{TextFormatting.GREEN + displayName + TextFormatting.RESET}));
        }
        stack.func_190920_e(1);
        return stack;
    }

    public static String getModNameForId(String modId) {
        return modNames.containsKey(modId = modId.toLowerCase(Locale.ENGLISH)) ? modNames.get(modId) : modId;
    }

    public static boolean isMorphTool(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == ModItems.tool) {
            return true;
        }
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(TAG_MORPHING_TOOL);
    }

    public static RayTraceResult raycast(Entity e, double len) {
        Vec3d look;
        Vec3d vec = new Vec3d(e.field_70165_t, e.field_70163_u, e.field_70161_v);
        if (e instanceof EntityPlayer) {
            vec = vec.func_178787_e(new Vec3d(0.0, (double)e.func_70047_e(), 0.0));
        }
        if ((look = e.func_70040_Z()) == null) {
            return null;
        }
        return MorphingHandler.raycast(e.func_130014_f_(), vec, look, len);
    }

    public static RayTraceResult raycast(World world, Vec3d origin, Vec3d ray, double len) {
        Vec3d end = origin.func_178787_e(ray.func_72432_b().func_186678_a(len));
        RayTraceResult pos = world.func_72933_a(origin, end);
        return pos;
    }

    static {
        for (Map.Entry modEntry : Loader.instance().getIndexedModList().entrySet()) {
            modNames.put(((String)modEntry.getKey()).toLowerCase(Locale.ENGLISH), ((ModContainer)modEntry.getValue()).getName());
        }
    }
}

