/*
 * Decompiled with CFR 0.152.
 */
package brad16840.plugins;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.gui.CraftingContainer;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class BackpacksJEIPlugin
extends BlankModPlugin {
    public void register(IModRegistry registry) {
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferInfo)new ContainerStackTransferInfo());
        IIngredientBlacklist ingredientBlacklist = registry.getJeiHelpers().getIngredientBlacklist();
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack((Block)Common.backpackBlock, 1, Short.MAX_VALUE));
        ingredientBlacklist.addIngredientToBlacklist((Object)new ItemStack((Item)Common.unknownItem, 1, Short.MAX_VALUE));
    }

    public static class ContainerStackTransferInfo
    implements IRecipeTransferInfo<ContainerStack> {
        public Class<ContainerStack> getContainerClass() {
            return ContainerStack.class;
        }

        public String getRecipeCategoryUid() {
            return "minecraft.crafting";
        }

        public boolean canHandle(ContainerStack container) {
            if (container == null || container.stacks.length < 2 || container.stacks[0].size() < 1) {
                return false;
            }
            for (int i = 0; i < container.stacks.length; ++i) {
                StackableContainer stack = container.getContainer(i);
                if (!(stack instanceof CraftingContainer)) continue;
                return true;
            }
            return false;
        }

        public List<Slot> getRecipeSlots(ContainerStack container) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            if (container.stacks.length < 2 || container.stacks[0].size() < 1) {
                return slots;
            }
            for (int i = 0; i < container.stacks.length; ++i) {
                StackableContainer stack = container.getContainer(i);
                if (!(stack instanceof CraftingContainer)) continue;
                for (int j = 1; j < stack.getSlotCount(); ++j) {
                    slots.add(container.getLocalSlot(stack, j));
                }
                break;
            }
            return slots;
        }

        public List<Slot> getInventorySlots(ContainerStack container) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            if (container.stacks.length < 2 || container.stacks[0].size() < 1) {
                return slots;
            }
            boolean foundCrafting = false;
            for (int i = 0; i < container.stacks.length; ++i) {
                int j;
                StackableContainer stack = container.getContainer(i);
                if (stack instanceof CraftingContainer) {
                    if (foundCrafting) {
                        for (j = 1; j < stack.getSlotCount(); ++j) {
                            slots.add(container.getLocalSlot(stack, j));
                        }
                    }
                    foundCrafting = true;
                    continue;
                }
                for (j = 0; j < stack.getSlotCount(); ++j) {
                    slots.add(container.getLocalSlot(stack, j));
                }
            }
            return slots;
        }
    }
}

