/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.MessageChannel;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UnknownItem;
import brad16840.common.gui.ImageButton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;

public class BlockSelector
extends StackableContainer.SimpleContainer {
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/selector.png");
    private HashMap<String, HashSet<Integer>> selectedItems;
    private int lastClickedItemPos;
    private String lastClickedItemId;
    private int lastClickedMeta;
    private int selectedItemPos = -1;
    private String selectedId = null;
    private String cachedId = null;
    private int scrollPos = 0;
    private int metaScrollPos = 0;
    private int selectedMeta = -1;
    private boolean groupById = false;
    private int tabPage = 0;
    private int activeTab;
    private int blockLines = 0;
    private String filterText = "";
    private String idText = "";
    private String metaText = "0";
    private boolean addingItem = false;
    private NonNullList<ItemStack> selectedMetadata = NonNullList.func_191196_a();
    private ArrayList<ItemStack> filteredBlocks = new ArrayList();
    private StackableContainer.ContainerSlot[] blockSlot;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollUpButton;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollDownButton;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollLeftButton;
    @SideOnly(value=Side.CLIENT)
    private ImageButton scrollRightButton;
    @SideOnly(value=Side.CLIENT)
    private ImageButton nextTabPageButton;
    @SideOnly(value=Side.CLIENT)
    private ImageButton prevTabPageButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton backToFilterButton;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerButton createBlockButton;
    private TabIconInventory tabIconInventory;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField textField;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField idField;
    @SideOnly(value=Side.CLIENT)
    private StackableContainer.ContainerTextField metaField;
    private boolean firstButton = true;
    private boolean multipleSelections = false;
    private boolean dragScrolling = false;
    private int scrollOffset = 0;
    private int thumbSize;
    private int thumbPos;
    private HashMap<String, HashSet<Integer>> additionalItems = new HashMap();
    private HashSet<String> oreDictItems = new HashSet();
    public ArrayList<CustomTab> customTabs = new ArrayList();
    private boolean blockInventoryWildcard = true;
    private ContainerStack.InvalidInventory blockInventory = new ContainerStack.InvalidInventory(){

        @Override
        public ItemStack func_70301_a(int i) {
            if (i + BlockSelector.this.scrollPos * 8 >= BlockSelector.this.filteredBlocks.size()) {
                return ItemStack.field_190927_a;
            }
            if (!BlockSelector.this.blockInventoryWildcard && !((ItemStack)BlockSelector.this.filteredBlocks.get(i + BlockSelector.this.scrollPos * 8)).func_190926_b() && ((ItemStack)BlockSelector.this.filteredBlocks.get(i + BlockSelector.this.scrollPos * 8)).func_77960_j() == Short.MAX_VALUE) {
                return new ItemStack(((ItemStack)BlockSelector.this.filteredBlocks.get(i + BlockSelector.this.scrollPos * 8)).func_77973_b());
            }
            return (ItemStack)BlockSelector.this.filteredBlocks.get(i + BlockSelector.this.scrollPos * 8);
        }

        @Override
        public int func_70302_i_() {
            return 32;
        }
    };
    private StackableContainer.ContainerSlot[] metaSlot;
    private MetaInventory metaInventory = new MetaInventory();
    private StackableContainer.ContainerSlot tabIcon;
    public boolean showOreDicts = false;
    public static ArrayList<AdditionalItemProvider> additionalItemProviders = new ArrayList();

    public BlockSelector() {
        super(307, 127);
        if (MessageChannel.getEffectiveSide() == Side.SERVER) {
            return;
        }
        this.activeTab = CreativeTabs.field_78027_g.func_78021_a();
        this.tabIconInventory = new TabIconInventory();
        this.additionalItems.clear();
        this.oreDictItems.clear();
        for (String name : OreDictionary.getOreNames()) {
            this.oreDictItems.add(name);
        }
        for (AdditionalItemProvider provider : additionalItemProviders) {
            provider.addItems(this.additionalItems, this.oreDictItems);
        }
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        int x;
        if (!this.isClient()) {
            return true;
        }
        this.customTabs.clear();
        this.showOreDicts = false;
        for (int i = 0; i < this.container.stacks.length; ++i) {
            if (!(this.container.getContainer(i) instanceof BlockSelectionListener)) continue;
            ((BlockSelectionListener)((Object)this.container.getContainer(i))).addCustomTabs(this.customTabs);
            this.multipleSelections = ((BlockSelectionListener)((Object)this.container.getContainer(i))).allowMultipleSelections();
        }
        this.selectedItems = new HashMap();
        this.blockSlot = new StackableContainer.ContainerSlot[32];
        for (x = 0; x < 8; ++x) {
            for (int y = 0; y < 4; ++y) {
                this.blockSlot[y * 8 + x] = new StackableContainer.ContainerSlot(this, player, this.blockInventory, y * 8 + x, 8 + x * 18, 16 + y * 18);
            }
        }
        this.metaSlot = new StackableContainer.ContainerSlot[32];
        for (x = 0; x < 7; ++x) {
            this.metaSlot[x] = new StackableContainer.ContainerSlot(this, player, this.metaInventory, x, 26 + x * 18, 101);
        }
        this.tabIcon = new StackableContainer.ContainerSlot(this, player, this.tabIconInventory, 0, 0, 0);
        this.filter();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void enableButtons() {
        if (this.scrollUpButton == null) {
            return;
        }
        this.scrollUpButton.field_146124_l = this.scrollPos > 0;
        this.scrollDownButton.field_146124_l = this.scrollPos + 4 < this.blockLines;
        this.scrollLeftButton.field_146124_l = this.metaScrollPos > 0;
        this.scrollRightButton.field_146124_l = this.metaScrollPos + 6 < this.selectedMetadata.size();
    }

    @SideOnly(value=Side.CLIENT)
    public void scroll(boolean scrollDown, boolean scrollPage) {
        this.scrollPos = scrollDown ? (this.scrollPos -= scrollPage ? 4 : 1) : (this.scrollPos += scrollPage ? 4 : 1);
        this.updateScrollPos(false);
        this.enableButtons();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateScrollPos(boolean updateThumbSize) {
        if (this.scrollPos + 4 > this.blockLines) {
            this.scrollPos = this.blockLines - 4;
        }
        if (this.scrollPos < 0) {
            this.scrollPos = 0;
        }
        int scrollbarSize = 38;
        float percent = 0.0f;
        if (updateThumbSize) {
            this.thumbSize = this.blockLines == 0 ? scrollbarSize : 4 * scrollbarSize / this.blockLines;
            if (this.thumbSize < 7) {
                this.thumbSize = 7;
            }
            if (this.thumbSize > scrollbarSize) {
                this.thumbSize = scrollbarSize;
            }
        }
        if (this.blockLines != 4) {
            percent = (float)this.scrollPos / (float)(this.blockLines - 4);
        }
        this.thumbPos = (int)((float)(scrollbarSize - this.thumbSize) * percent);
        if (this.thumbPos + this.thumbSize > scrollbarSize) {
            this.thumbPos = scrollbarSize - this.thumbSize;
        }
        if (this.thumbPos < 0) {
            this.thumbPos = 0;
        }
        this.thumbPos += 32;
    }

    @SideOnly(value=Side.CLIENT)
    public void setScrollPercent(float percent) {
        this.scrollPos = (int)((float)(this.blockLines - 4) * percent);
        this.updateScrollPos(false);
        this.enableButtons();
    }

    @SideOnly(value=Side.CLIENT)
    public void setAddingItem(boolean on) {
        this.addingItem = on;
        this.backToFilterButton.field_146125_m = on;
        this.createBlockButton.field_146125_m = on;
        this.textField.disabled = on;
        this.metaField.disabled = !on;
        this.idField.disabled = !on;
        this.nextTabPageButton.field_146125_m = !on;
        this.prevTabPageButton.field_146125_m = !on;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.scrollUpButton = new ImageButton((StackableContainer)this, 1, 152, 15, 17, 16, texture, 176, 0);
        this.scrollDownButton = new ImageButton((StackableContainer)this, 2, 152, 71, 17, 16, texture, 176, 16);
        this.scrollLeftButton = new ImageButton((StackableContainer)this, 3, 7, 100, 17, 18, texture, 176, 32);
        this.scrollRightButton = new ImageButton((StackableContainer)this, 4, 152, 100, 17, 18, texture, 176, 50);
        this.nextTabPageButton = new ImageButton((StackableContainer)this, 5, 285, 100, 17, 18, texture, 176, 50);
        this.prevTabPageButton = new ImageButton((StackableContainer)this, 6, 186, 100, 17, 18, texture, 176, 32);
        this.backToFilterButton = new StackableContainer.ContainerButton(this, 7, 245, 98, 57, 20, new Translatable("button.back", new Object[0]).translate());
        this.backToFilterButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.setAddingItem(false);
            }
        };
        this.createBlockButton = new StackableContainer.ContainerButton(this, 7, 186, 98, 57, 20, new Translatable("button.add", new Object[0]).translate());
        this.createBlockButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                String id = BlockSelector.this.idField.getText();
                int metadata = 0;
                try {
                    metadata = Integer.parseInt(BlockSelector.this.metaField.getText());
                }
                catch (NumberFormatException e) {
                    new Translatable("problem.invalidmeta", new Object[0]).log((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                    return;
                }
                if (id.toLowerCase().startsWith("oredict:")) {
                    if (!BlockSelector.this.oreDictItems.contains(id.substring(8))) {
                        BlockSelector.this.oreDictItems.add(id.substring(8));
                    }
                } else {
                    if (!BlockSelector.this.additionalItems.containsKey(id)) {
                        BlockSelector.this.additionalItems.put(id, new HashSet());
                    }
                    ((HashSet)BlockSelector.this.additionalItems.get(id)).add(metadata);
                }
                BlockSelector.this.filter();
                BlockSelector.this.idField.setText(id);
                BlockSelector.this.idField.resetScroll();
                BlockSelector.this.metaField.setText(Integer.toString(metadata));
                BlockSelector.this.setSelectedItem(id, metadata);
            }
        };
        this.scrollUpButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.scroll(true, false);
            }
        };
        this.scrollDownButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.scroll(false, false);
            }
        };
        this.scrollLeftButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.metaScrollPos = BlockSelector.this.metaScrollPos - 1;
                if (BlockSelector.this.metaScrollPos < 0) {
                    BlockSelector.this.metaScrollPos = 0;
                }
                BlockSelector.this.enableButtons();
            }
        };
        this.scrollRightButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.metaScrollPos = BlockSelector.this.metaScrollPos + 1;
                if (BlockSelector.this.metaScrollPos + 6 > BlockSelector.this.selectedMetadata.size()) {
                    BlockSelector.this.metaScrollPos = BlockSelector.this.metaScrollPos - 1;
                }
                BlockSelector.this.enableButtons();
            }
        };
        this.prevTabPageButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.tabPage = BlockSelector.this.tabPage - 1;
                if (BlockSelector.this.tabPage < 0) {
                    BlockSelector.this.tabPage = 0;
                }
                ((BlockSelector)BlockSelector.this).prevTabPageButton.field_146124_l = BlockSelector.this.tabPage > 0;
                ((BlockSelector)BlockSelector.this).nextTabPageButton.field_146124_l = BlockSelector.this.tabPage * 15 < CreativeTabs.field_78032_a.length + BlockSelector.this.customTabs.size() + (BlockSelector.this.showOreDicts ? 1 : 0) - 14;
            }
        };
        this.nextTabPageButton.callback = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.tabPage = BlockSelector.this.tabPage + 1;
                if (BlockSelector.this.tabPage * 15 >= CreativeTabs.field_78032_a.length + BlockSelector.this.customTabs.size() + (BlockSelector.this.showOreDicts ? 1 : 0) + 1) {
                    BlockSelector.this.tabPage = BlockSelector.this.tabPage - 1;
                }
                ((BlockSelector)BlockSelector.this).prevTabPageButton.field_146124_l = BlockSelector.this.tabPage > 0;
                ((BlockSelector)BlockSelector.this).nextTabPageButton.field_146124_l = BlockSelector.this.tabPage * 15 < CreativeTabs.field_78032_a.length + BlockSelector.this.customTabs.size() + (BlockSelector.this.showOreDicts ? 1 : 0) - 14;
            }
        };
        this.gui.addButton(this.backToFilterButton);
        this.gui.addButton(this.createBlockButton);
        this.gui.addButton(this.scrollUpButton);
        this.gui.addButton(this.scrollDownButton);
        this.gui.addButton(this.scrollLeftButton);
        this.gui.addButton(this.scrollRightButton);
        this.gui.addButton(this.prevTabPageButton);
        this.gui.addButton(this.nextTabPageButton);
        this.enableButtons();
        this.prevTabPageButton.field_146124_l = this.tabPage > 0;
        this.nextTabPageButton.field_146124_l = this.tabPage * 15 < CreativeTabs.field_78032_a.length + this.customTabs.size() + (this.showOreDicts ? 1 : 0) - 14;
        this.textField = this.gui.addTextField(8, this, 223, 11, 76, 9);
        this.textField.borderY = 3;
        this.textField.borderX = 3;
        this.textField.setMaxStringLength(60);
        this.textField.setText(this.filterText);
        this.textField.rightClickClear = true;
        this.textField.clearListener = new ContainerStack.Callback(){

            @Override
            public void call() {
                BlockSelector.this.filter();
            }
        };
        this.idField = this.gui.addTextField(9, this, 189, 44, 84, 9);
        this.idField.setMaxStringLength(512);
        this.idField.borderY = 3;
        this.idField.borderX = 3;
        this.idField.setText(this.idText);
        this.metaField = this.gui.addTextField(10, this, 189, 80, 110, 9);
        this.metaField.borderY = 3;
        this.metaField.borderX = 3;
        this.metaField.setMaxStringLength(60);
        this.metaField.setText(this.metaText);
        this.setAddingItem(this.addingItem);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (!this.textField.disabled && this.textField.keyPressed(key, keyCode)) {
            this.filter();
            this.enableButtons();
            return true;
        }
        if (!this.idField.disabled && this.idField.keyPressed(key, keyCode)) {
            return true;
        }
        if (!this.metaField.disabled && this.metaField.keyPressed(key, keyCode)) {
            return true;
        }
        if (keyCode == 200 && this.scrollUpButton.field_146124_l) {
            this.scrollUpButton.callback.call();
        } else if (keyCode == 208 && this.scrollDownButton.field_146124_l) {
            this.scrollDownButton.callback.call();
        } else if (keyCode == 203 && this.scrollLeftButton.field_146124_l) {
            this.scrollLeftButton.callback.call();
        } else if (keyCode == 205 && this.scrollRightButton.field_146124_l) {
            this.scrollRightButton.callback.call();
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
        if (this.isClient()) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setSelectedItem(String id, int metadata) {
        if (!(this.multipleSelections && (Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157) || Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)))) {
            this.selectedItems.clear();
        }
        if (id == null) {
            this.selectedItems.clear();
        } else if (this.selectedItems.containsKey(id)) {
            HashSet<Integer> selectedMetadata = this.selectedItems.get(id);
            if (selectedMetadata.contains(metadata)) {
                if (!this.multipleSelections || !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                    selectedMetadata.remove(metadata);
                }
                if (selectedMetadata.isEmpty()) {
                    this.selectedItems.remove(id);
                }
            } else if (metadata == Short.MAX_VALUE) {
                selectedMetadata.clear();
                selectedMetadata.add(metadata);
            } else if (selectedMetadata.contains(Short.MAX_VALUE)) {
                selectedMetadata.clear();
                try {
                    NonNullList items = NonNullList.func_191196_a();
                    ItemStack stack = UnknownItem.wrap(id, 0, null);
                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items);
                    Iterator iterator = items.iterator();
                    while (iterator.hasNext()) {
                        ItemStack item = (ItemStack)iterator.next();
                        selectedMetadata.add(item.func_77960_j());
                    }
                    selectedMetadata.remove(metadata);
                }
                catch (Throwable items) {}
            } else {
                selectedMetadata.add(metadata);
            }
        } else {
            this.selectedItems.put(id, new HashSet());
            this.selectedItems.get(id).add(metadata);
        }
        this.selectedMetadata.clear();
        this.metaScrollPos = 0;
        this.cachedId = this.selectedId = id;
        if (id != null && id.toLowerCase().startsWith("oredict:")) {
            if (!this.oreDictItems.contains(id.substring(8))) {
                this.oreDictItems.add(id.substring(8));
            }
        } else {
            if (!this.additionalItems.containsKey(id)) {
                this.additionalItems.put(id, new HashSet());
            }
            this.additionalItems.get(id).add(metadata);
        }
        if (id != null) {
            this.selectedMeta = 0;
            this.updateMetadata();
            boolean alreadyExists = metadata == Short.MAX_VALUE;
            for (ItemStack stack : this.selectedMetadata) {
                if (stack.func_77960_j() != metadata) continue;
                alreadyExists = true;
            }
            if (!alreadyExists) {
                this.selectedMetadata.add((Object)UnknownItem.wrap(this.selectedId, metadata, null));
            }
            for (int i = 0; i < this.selectedMetadata.size(); ++i) {
                if (((ItemStack)this.selectedMetadata.get(i)).func_77960_j() != metadata) continue;
                this.selectedMeta = i + 1;
            }
            this.metaScrollPos = this.selectedMeta - 3;
            if (this.metaScrollPos + 6 > this.selectedMetadata.size()) {
                this.metaScrollPos = this.selectedMetadata.size() - 6;
            }
            if (this.metaScrollPos < 0) {
                this.metaScrollPos = 0;
            }
        } else {
            this.selectedId = null;
            this.cachedId = null;
            this.selectedMeta = -1;
        }
        this.broadcastChange();
        this.filter();
        if (this.cachedId != null && !this.cachedId.equals(this.selectedId)) {
            this.activeTab = CreativeTabs.field_78027_g.func_78021_a();
            this.filter();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void static_addItemStackTooltip(List list, ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return;
        }
        try {
            if (itemStack.func_77960_j() == Short.MAX_VALUE) {
                if (itemStack.func_77973_b() instanceof UnknownItem) {
                    list.set(0, new Translatable("tooltip.blockselector.wildcarditem", itemStack.func_82833_r()).translate());
                } else {
                    list.set(0, new Translatable("tooltip.blockselector.wildcarditem", new ItemStack(itemStack.func_77973_b(), 1, 0).func_82833_r()).translate());
                }
            }
            new Translatable("tooltip.blockselector.modname", this.getModName(itemStack.func_77973_b())).addTo(list);
            new Translatable("tooltip.blockselector.idmeta", UnknownItem.getItemDescriptor(itemStack), itemStack.func_77960_j()).addTo(list);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List getItemStackTooltip(EntityPlayer player, ItemStack stack) {
        try {
            List list = stack.func_82840_a(player, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
            this.static_addItemStackTooltip(list, stack);
            return list;
        }
        catch (Throwable e) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("<Invalid Tooltip>");
            return list;
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderFilter(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        int hoverX = (mouseX - 186) / 23;
        int hoverY = (mouseY - 27) / 23;
        if (mouseX < 186 || mouseY < 27) {
            hoverY = -1;
            hoverX = -1;
        }
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 3; ++y) {
                int xPos = 187 + x * 23 - this.gui.getOffsetX(this) - this.gui.getScrollX();
                int yPos = 28 + y * 23 - this.gui.getOffsetY(this) - this.gui.getScrollY();
                this.tabIcon.field_75223_e = 190 + x * 23;
                this.tabIcon.field_75221_f = 31 + y * 23;
                this.tabIconInventory.tab = x + y * 5 + this.tabPage * 15 - this.customTabs.size();
                this.gui.drawSlotInventory(this, this.tabIcon);
                if (this.tabIconInventory.tab >= CreativeTabs.field_78032_a.length + (this.showOreDicts ? 1 : 0) + 1) {
                    GlStateManager.func_179140_f();
                    this.gui.drawRectangle(this, xPos - (x == 0 ? 1 : 0), yPos, xPos + 23, yPos + 23, -3750202);
                    GlStateManager.func_179145_e();
                    continue;
                }
                if (this.tabIconInventory.tab == this.activeTab) {
                    GlStateManager.func_179140_f();
                    this.gui.drawRectangle(this, xPos, yPos, xPos + 22, yPos + 22, -14751714);
                    GlStateManager.func_179145_e();
                }
                if (x != hoverX || y != hoverY) continue;
                if (this.tabIconInventory.tab != this.activeTab) {
                    GlStateManager.func_179140_f();
                    this.gui.drawRectangle(this, xPos, yPos, xPos + 22, yPos + 22, -8850318);
                    GlStateManager.func_179145_e();
                }
                if (this.tabIconInventory.tab < 0) {
                    this.gui.tooltips.add(this.customTabs.get(-(this.tabIconInventory.tab + 1)).getName());
                    continue;
                }
                if (this.tabIconInventory.tab == CreativeTabs.field_78032_a.length + (this.showOreDicts ? 1 : 0)) {
                    this.gui.tooltips.add(new Translatable("gui.blockselector.additem.title", new Object[0]).translate());
                    continue;
                }
                if (this.tabIconInventory.tab == CreativeTabs.field_78032_a.length) {
                    this.gui.tooltips.add(new Translatable("gui.blockselector.oredict.title", new Object[0]).translate());
                    continue;
                }
                this.gui.tooltips.add(I18n.func_135052_a((String)CreativeTabs.field_78032_a[this.tabIconInventory.tab].func_78024_c(), (Object[])new Object[0]));
            }
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179140_f();
        this.gui.text(this, "" + (this.tabPage + 1) + " / " + ((CreativeTabs.field_78032_a.length + this.customTabs.size() + (this.showOreDicts ? 1 : 0)) / 15 + 1)).truncateString(80).drawCenteredString(244, 106, -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheel(int x, int y, int wheel) {
        int oldScrollPos = this.scrollPos;
        if (wheel < 0) {
            this.scroll(false, false);
        } else if (wheel > 0) {
            this.scroll(true, false);
        }
        return oldScrollPos != this.scrollPos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        int x;
        this.gui.text(this, new Translatable("gui.blockselector.itemblock", new Object[0]).translate()).truncateString(160).drawCenteredString(88, 6, -12566464);
        this.gui.text(this, new Translatable("gui.blockselector.type", new Object[0]).translate()).truncateString(160).drawCenteredString(88, 91, -12566464);
        if (!this.addingItem) {
            this.renderFilter(mouseX, mouseY);
            this.gui.text(this, new Translatable("gui.blockselector.filter", new Object[0]).translate()).truncateString(32).drawString(187, 12, -12566464);
        } else {
            this.gui.text(this, new Translatable("gui.blockselector.additem.title", new Object[0]).translate()).drawString(188, 8, -12566464);
            this.gui.text(this, new Translatable("gui.blockselector.additem.id", new Object[0]).translate()).drawString(188, 30, -12566464);
            this.gui.text(this, new Translatable("gui.blockselector.additem.meta", new Object[0]).translate()).drawString(188, 66, -12566464);
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        this.gui.bindTexture(texture);
        if (mouseX > 153 && mouseX < 167 && mouseY > 4 && mouseY < 16) {
            if (this.groupById) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
                new Translatable("gui.groupbyid.tooltip.on", new Object[0]).addTo(this.gui.tooltips);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.9f);
                new Translatable("gui.groupbyid.tooltip.off", new Object[0]).addTo(this.gui.tooltips);
            }
        } else if (!this.groupById) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        }
        this.gui.drawTexture(this, 153 - this.gui.getOffsetX(this) - this.gui.getScrollX(), 1 - this.gui.getOffsetY(this) - this.gui.getScrollY(), 14, 14, 227, 0, 200.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        int hoverX = (mouseX - 7) / 18;
        int hoverY = (mouseY - 15) / 18;
        if (mouseX < 7 || mouseY < 15) {
            hoverY = -1;
            hoverX = -1;
        }
        for (x = 0; x < 8; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (!this.groupById && this.blockSlot[y * 8 + x].func_75216_d() && this.blockSlot[y * 8 + x].func_75211_c().func_77960_j() == Short.MAX_VALUE) {
                    this.blockInventoryWildcard = false;
                    this.gui.drawSlotInventory(this, this.blockSlot[y * 8 + x]);
                    this.blockInventoryWildcard = true;
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.gui.bindTexture(texture);
                    this.gui.drawTexture(this, this.blockSlot[y * 8 + x].field_75223_e + 3 - this.gui.getOffsetX(this) - this.gui.getScrollX(), this.blockSlot[y * 8 + x].field_75221_f + 3 - this.gui.getOffsetY(this) - this.gui.getScrollY(), 14, 14, 227, 0, 600.0f);
                    GlStateManager.func_179145_e();
                } else {
                    this.gui.drawSlotInventory(this, this.blockSlot[y * 8 + x]);
                }
                if (x != hoverX || y != hoverY) continue;
                this.gui.customTooltipItem = this.blockSlot[y * 8 + x].func_75211_c();
            }
        }
        hoverX = (mouseX - 25) / 18;
        hoverY = (mouseY - 100) / 18;
        if (mouseX < 25 || mouseY < 100) {
            hoverY = -1;
            hoverX = -1;
        }
        for (x = 0; x < 7; ++x) {
            if (x + this.metaScrollPos == 0 && this.selectedId != null) {
                this.metaInventory.setWildcard(false);
                this.gui.drawSlotInventory(this, this.metaSlot[x]);
                this.metaInventory.setWildcard(true);
                GlStateManager.func_179140_f();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.gui.bindTexture(texture);
                this.gui.drawTexture(this, 29 - this.gui.getOffsetX(this) - this.gui.getScrollX(), 104 - this.gui.getOffsetY(this) - this.gui.getScrollY(), 14, 14, 227, 0, 600.0f);
                GlStateManager.func_179145_e();
            } else {
                this.gui.drawSlotInventory(this, this.metaSlot[x]);
            }
            if (x != hoverX || 0 != hoverY) continue;
            this.gui.customTooltipItem = this.metaSlot[x].func_75211_c();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int mouseX, int mouseY) {
        int x;
        if (this.firstButton) {
            this.firstButton = false;
            this.container.updateContainers((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, 176, 125, 0, 0);
        this.gui.drawTexture(this, 180, 0, 128, 125, 0, 125);
        int hoverX = (mouseX - 7) / 18;
        int hoverY = (mouseY - 15) / 18;
        if (mouseX < 7 || mouseY < 15) {
            hoverY = -1;
            hoverX = -1;
        }
        for (x = 0; x < 8; ++x) {
            for (int y = 0; y < 4; ++y) {
                ItemStack stack = this.blockSlot[y * 8 + x].func_75211_c();
                if (stack.func_190926_b()) continue;
                String id = UnknownItem.getItemDescriptor(stack);
                if (this.selectedItems.containsKey(id) && (this.groupById || this.selectedItems.get(id).contains(Short.MAX_VALUE) || this.selectedItems.get(id).contains(stack.func_77960_j()))) {
                    this.gui.drawRectangle(this, 8 + x * 18, 16 + y * 18, 24 + x * 18, 32 + y * 18, -14751714);
                    continue;
                }
                if (x != hoverX || y != hoverY) continue;
                this.gui.drawRectangle(this, 8 + x * 18, 16 + y * 18, 24 + x * 18, 32 + y * 18, -8850318);
            }
        }
        hoverX = (mouseX - 25) / 18;
        hoverY = (mouseY - 100) / 18;
        if (mouseX < 25 || mouseY < 100) {
            hoverY = -1;
            hoverX = -1;
        }
        for (x = 0; x < 7; ++x) {
            ItemStack stack = this.metaSlot[x].func_75211_c();
            if (stack.func_190926_b()) continue;
            String id = UnknownItem.getItemDescriptor(stack);
            if (this.selectedItems.containsKey(id) && (this.selectedItems.get(id).contains(Short.MAX_VALUE) || this.selectedItems.get(id).contains(stack.func_77960_j()))) {
                this.gui.drawRectangle(this, 26 + x * 18, 101, 42 + x * 18, 117, -14751714);
                continue;
            }
            if (x != hoverX || 0 != hoverY) continue;
            this.gui.drawRectangle(this, 26 + x * 18, 101, 42 + x * 18, 117, -8850318);
        }
        GlStateManager.func_179140_f();
        int state = 1;
        if (this.dragScrolling || mouseX > 151 && mouseX < 169 && mouseY >= this.thumbPos && mouseY < this.thumbPos + this.thumbSize) {
            state = 2;
        }
        if (!this.scrollDownButton.field_146124_l && !this.scrollUpButton.field_146124_l) {
            state = 0;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.drawTexture(this, 152, this.thumbPos, 17, this.thumbSize - 3, 176 + state * 17, 68);
        this.gui.drawTexture(this, 152, this.thumbPos + this.thumbSize - 3, 17, 3, 176 + state * 17, 103);
        if (!this.addingItem) {
            this.textField.drawBackground();
        } else {
            this.gui.drawTexture(this, 180, 0, 128, 125, 128, 125);
            this.idField.drawBackground();
            this.metaField.drawBackground();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void broadcastChange() {
        ItemStack stack = this.metaInventory.func_70301_a(this.selectedMeta - this.metaScrollPos);
        if (stack.func_190926_b()) {
            this.idText = "";
            this.metaText = "0";
        } else {
            this.idText = this.selectedId;
            this.metaText = Integer.toString(stack.func_77960_j());
        }
        if (this.idField != null) {
            this.idField.setText(this.idText);
        }
        if (this.metaField != null) {
            this.metaField.setText(this.metaText);
        }
        for (int i = 0; i < this.container.stacks.length; ++i) {
            if (!(this.container.getContainer(i) instanceof BlockSelectionListener)) continue;
            if (stack.func_190926_b()) {
                ((BlockSelectionListener)((Object)this.container.getContainer(i))).selectionChanged(null, -1);
            } else {
                ((BlockSelectionListener)((Object)this.container.getContainer(i))).selectionChanged(this.selectedId, stack.func_77960_j());
            }
            if (!this.multipleSelections) continue;
            ((BlockSelectionListener)((Object)this.container.getContainer(i))).selectionsChanged(this.selectedItems);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDown(int x, int y, int button) {
        block123: {
            NonNullList items;
            int lastMetaPos;
            block132: {
                block133: {
                    block136: {
                        block135: {
                            String id;
                            ItemStack stack;
                            int slot;
                            block122: {
                                NonNullList items22;
                                Integer sMetadata;
                                String sId;
                                ItemStack s;
                                int i;
                                boolean removingSelection;
                                String lastID;
                                block126: {
                                    block130: {
                                        Integer metadata;
                                        block134: {
                                            ItemStack test;
                                            block131: {
                                                block124: {
                                                    NonNullList items3;
                                                    block121: {
                                                        Integer metadata2;
                                                        block128: {
                                                            HashSet<Integer> selectedMetadata;
                                                            block129: {
                                                                block127: {
                                                                    block125: {
                                                                        if (x > 153 && x < 167 && y > 4 && y < 16) {
                                                                            this.groupById = !this.groupById;
                                                                            this.filter();
                                                                            this.enableButtons();
                                                                            return true;
                                                                        }
                                                                        if (x < this.blockSlot[0].field_75223_e - 1 || y < this.blockSlot[0].field_75221_f - 1 || x >= this.blockSlot[31].field_75223_e + 17 || y >= this.blockSlot[31].field_75221_f + 17) break block124;
                                                                        slot = (y - this.blockSlot[0].field_75221_f) / 18 * 8 + (x - this.blockSlot[0].field_75223_e) / 18;
                                                                        stack = this.blockInventory.func_70301_a(slot);
                                                                        id = null;
                                                                        metadata2 = Short.MAX_VALUE;
                                                                        if (!stack.func_190926_b()) {
                                                                            id = UnknownItem.getItemDescriptor(stack);
                                                                            try {
                                                                                if (!this.groupById) {
                                                                                    metadata2 = stack.func_77960_j();
                                                                                }
                                                                                if (!stack.func_77981_g()) {
                                                                                    metadata2 = Short.MAX_VALUE;
                                                                                }
                                                                            }
                                                                            catch (Throwable throwable) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                        if (!this.multipleSelections || !Keyboard.isKeyDown((int)29) && !Keyboard.isKeyDown((int)157)) {
                                                                            this.selectedItems.clear();
                                                                        }
                                                                        if (!this.multipleSelections || this.lastClickedItemPos < 0 || !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) break block125;
                                                                        lastID = null;
                                                                        removingSelection = true;
                                                                        break block126;
                                                                    }
                                                                    this.lastClickedItemPos = slot + this.scrollPos * 8;
                                                                    this.lastClickedItemId = id;
                                                                    this.lastClickedMeta = metadata2;
                                                                    if (id != null) break block127;
                                                                    this.selectedItems.clear();
                                                                    break block121;
                                                                }
                                                                if (!this.selectedItems.containsKey(id)) break block128;
                                                                selectedMetadata = this.selectedItems.get(id);
                                                                if (!selectedMetadata.contains(metadata2)) break block129;
                                                                selectedMetadata.remove(metadata2);
                                                                if (selectedMetadata.isEmpty()) {
                                                                    this.selectedItems.remove(id);
                                                                }
                                                                break block121;
                                                            }
                                                            if (metadata2 == Short.MAX_VALUE) {
                                                                selectedMetadata.clear();
                                                                selectedMetadata.add(metadata2);
                                                                break block121;
                                                            } else if (selectedMetadata.contains(Short.MAX_VALUE)) {
                                                                selectedMetadata.clear();
                                                                try {
                                                                    items3 = NonNullList.func_191196_a();
                                                                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items3);
                                                                    for (ItemStack item : items3) {
                                                                        selectedMetadata.add(item.func_77960_j());
                                                                    }
                                                                    selectedMetadata.remove(metadata2);
                                                                }
                                                                catch (Throwable items4) {}
                                                                break block121;
                                                            } else {
                                                                selectedMetadata.add(metadata2);
                                                            }
                                                            break block121;
                                                        }
                                                        this.selectedItems.put(id, new HashSet());
                                                        this.selectedItems.get(id).add(metadata2);
                                                    }
                                                    if (!this.groupById) {
                                                        try {
                                                            boolean allSelected = true;
                                                            items3 = NonNullList.func_191196_a();
                                                            if (!stack.func_190926_b()) {
                                                                try {
                                                                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items3);
                                                                }
                                                                catch (Throwable e) {
                                                                    items3.add((Object)stack);
                                                                }
                                                            }
                                                            for (ItemStack item : items3) {
                                                                if (this.selectedItems.get(id).contains(item.func_77960_j())) continue;
                                                                allSelected = false;
                                                                break;
                                                            }
                                                            if (allSelected) {
                                                                this.selectedItems.get(id).clear();
                                                                this.selectedItems.get(id).add((Integer)Short.MAX_VALUE);
                                                            }
                                                            break block122;
                                                        }
                                                        catch (Throwable allSelected) {
                                                            // empty catch block
                                                        }
                                                    }
                                                    break block122;
                                                }
                                                if (x > 151 && x < 169 && y > 31 && y < 70) {
                                                    if (y > this.thumbPos && y < this.thumbPos + this.thumbSize) {
                                                        if (this.blockLines <= 4) {
                                                            return false;
                                                        }
                                                        this.dragScrolling = true;
                                                        this.scrollOffset = y - this.thumbPos;
                                                        if (this.gui == null) return true;
                                                        this.gui.func_73876_c();
                                                        return true;
                                                    }
                                                    if (y < this.thumbPos) {
                                                        this.scroll(true, true);
                                                    } else {
                                                        this.scroll(false, true);
                                                    }
                                                }
                                                if (x <= this.metaSlot[0].field_75223_e || y <= this.metaSlot[0].field_75221_f || x >= this.metaSlot[6].field_75223_e + 17 || y >= this.metaSlot[6].field_75221_f + 17) break block130;
                                                lastMetaPos = this.selectedMeta;
                                                this.selectedMeta = this.metaScrollPos + (x - this.metaSlot[0].field_75223_e) / 18;
                                                if (this.selectedId == null) break block123;
                                                if (!this.multipleSelections || !Keyboard.isKeyDown((int)29) && !Keyboard.isKeyDown((int)157)) {
                                                    this.selectedItems.clear();
                                                }
                                                test = UnknownItem.wrap(this.selectedId, 0, null);
                                                metadata = Short.MAX_VALUE;
                                                try {
                                                    if (this.selectedMeta > 0) {
                                                        metadata = ((ItemStack)this.selectedMetadata.get(this.selectedMeta - 1)).func_77960_j();
                                                    }
                                                    if (!test.func_77981_g()) {
                                                        metadata = Short.MAX_VALUE;
                                                    }
                                                }
                                                catch (Throwable metadata2) {
                                                    // empty catch block
                                                }
                                                if (!this.multipleSelections || !Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) break block131;
                                                if (this.lastClickedItemId == null || !this.lastClickedItemId.equals(this.selectedId)) {
                                                    this.lastClickedItemId = this.selectedId;
                                                    this.lastClickedItemPos = this.selectedItemPos;
                                                    this.lastClickedMeta = Short.MAX_VALUE;
                                                    try {
                                                        if (lastMetaPos > 0) {
                                                            this.lastClickedMeta = ((ItemStack)this.selectedMetadata.get(lastMetaPos - 1)).func_77960_j();
                                                        }
                                                        if (!test.func_77981_g()) {
                                                            this.lastClickedMeta = Short.MAX_VALUE;
                                                        }
                                                    }
                                                    catch (Throwable metadata2) {
                                                        // empty catch block
                                                    }
                                                }
                                                items = NonNullList.func_191196_a();
                                                if (!test.func_190926_b()) {
                                                    try {
                                                        test.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items);
                                                    }
                                                    catch (Throwable e) {
                                                        items.add((Object)test);
                                                    }
                                                }
                                                lastMetaPos = 0;
                                                if (this.lastClickedMeta == Short.MAX_VALUE) break block132;
                                                break block133;
                                            }
                                            if (this.lastClickedItemId == null || !this.lastClickedItemId.equals(this.selectedId)) {
                                                this.lastClickedItemId = this.selectedId;
                                                this.lastClickedItemPos = this.selectedItemPos;
                                            }
                                            this.lastClickedMeta = metadata;
                                            if (!this.selectedItems.containsKey(this.selectedId)) break block134;
                                            HashSet<Integer> selectedMetadata = this.selectedItems.get(this.selectedId);
                                            if (selectedMetadata.contains(metadata)) {
                                                selectedMetadata.remove(metadata);
                                                if (selectedMetadata.isEmpty()) {
                                                    this.selectedItems.remove(this.selectedId);
                                                }
                                                break block123;
                                            } else {
                                                NonNullList items5 = NonNullList.func_191196_a();
                                                if (!test.func_190926_b()) {
                                                    try {
                                                        test.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items5);
                                                    }
                                                    catch (Throwable e) {
                                                        items5.add((Object)test);
                                                    }
                                                }
                                                if (metadata == Short.MAX_VALUE) {
                                                    selectedMetadata.clear();
                                                    selectedMetadata.add(metadata);
                                                } else if (selectedMetadata.contains(Short.MAX_VALUE)) {
                                                    selectedMetadata.clear();
                                                    try {
                                                        for (ItemStack item : items5) {
                                                            selectedMetadata.add(item.func_77960_j());
                                                        }
                                                        selectedMetadata.remove(metadata);
                                                    }
                                                    catch (Throwable e) {}
                                                } else {
                                                    selectedMetadata.add(metadata);
                                                }
                                                try {
                                                    boolean allSelected = true;
                                                    for (ItemStack item : items5) {
                                                        if (selectedMetadata.contains(item.func_77960_j())) continue;
                                                        allSelected = false;
                                                        break;
                                                    }
                                                    if (allSelected) {
                                                        selectedMetadata.clear();
                                                        selectedMetadata.add((Integer)Short.MAX_VALUE);
                                                    }
                                                    break block123;
                                                }
                                                catch (Throwable throwable) {}
                                            }
                                            break block123;
                                        }
                                        this.selectedItems.put(this.selectedId, new HashSet());
                                        this.selectedItems.get(this.selectedId).add(metadata);
                                        break block123;
                                    }
                                    int hoverX = (x - 186) / 23;
                                    int hoverY = (y - 27) / 23;
                                    if (this.addingItem) {
                                        hoverY = 10;
                                        hoverX = 10;
                                    }
                                    if (x < 186) return false;
                                    if (y < 27) return false;
                                    if (hoverX >= 5) return false;
                                    if (hoverY >= 3) return false;
                                    if (this.tabPage * 15 + hoverY * 5 + hoverX >= CreativeTabs.field_78032_a.length + this.customTabs.size() + (this.showOreDicts ? 1 : 0) + 1) return true;
                                    if (button != 1 && this.tabPage * 15 + hoverY * 5 + hoverX - this.customTabs.size() == CreativeTabs.field_78032_a.length + (this.showOreDicts ? 1 : 0)) {
                                        this.setAddingItem(true);
                                        return true;
                                    }
                                    this.activeTab = this.tabPage * 15 + hoverY * 5 + hoverX - this.customTabs.size();
                                    this.filter();
                                    this.enableButtons();
                                    return true;
                                }
                                for (i = Math.min(this.lastClickedItemPos, slot + this.scrollPos * 8); i <= Math.max(this.lastClickedItemPos, slot + this.scrollPos * 8); ++i) {
                                    if (i == this.lastClickedItemPos || (s = this.filteredBlocks.get(i)).func_190926_b()) continue;
                                    sId = UnknownItem.getItemDescriptor(s);
                                    if (!this.selectedItems.containsKey(sId)) {
                                        removingSelection = false;
                                        break;
                                    }
                                    sMetadata = Short.MAX_VALUE;
                                    try {
                                        if (!this.groupById) {
                                            sMetadata = s.func_77960_j();
                                        }
                                        if (!s.func_77981_g()) {
                                            sMetadata = Short.MAX_VALUE;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    if (this.selectedItems.get(sId).contains(Short.MAX_VALUE) || this.selectedItems.get(sId).contains(sMetadata)) continue;
                                    removingSelection = false;
                                    break;
                                }
                                if (removingSelection) {
                                    for (i = Math.min(this.lastClickedItemPos, slot + this.scrollPos * 8); i <= Math.max(this.lastClickedItemPos, slot + this.scrollPos * 8); ++i) {
                                        s = this.filteredBlocks.get(i);
                                        if (s.func_190926_b() || !this.selectedItems.containsKey(sId = UnknownItem.getItemDescriptor(s))) continue;
                                        sMetadata = Short.MAX_VALUE;
                                        try {
                                            if (!this.groupById) {
                                                sMetadata = s.func_77960_j();
                                            }
                                            if (!s.func_77981_g()) {
                                                sMetadata = Short.MAX_VALUE;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        if (sMetadata == Short.MAX_VALUE) {
                                            this.selectedItems.get(sId).clear();
                                        } else if (this.selectedItems.get(sId).contains(Short.MAX_VALUE)) {
                                            this.selectedItems.get(sId).clear();
                                            try {
                                                items22 = NonNullList.func_191196_a();
                                                s.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items22);
                                                for (ItemStack item : items22) {
                                                    this.selectedItems.get(sId).add(item.func_77960_j());
                                                }
                                                this.selectedItems.get(sId).remove(sMetadata);
                                            }
                                            catch (Throwable items6) {}
                                        } else {
                                            this.selectedItems.get(sId).remove(sMetadata);
                                        }
                                        if (!this.selectedItems.get(sId).isEmpty()) continue;
                                        this.selectedItems.remove(sId);
                                    }
                                } else {
                                    for (i = Math.min(this.lastClickedItemPos, slot + this.scrollPos * 8); i <= Math.max(this.lastClickedItemPos, slot + this.scrollPos * 8); ++i) {
                                        s = this.filteredBlocks.get(i);
                                        if (s.func_190926_b()) continue;
                                        sId = UnknownItem.getItemDescriptor(s);
                                        if (!this.selectedItems.containsKey(sId)) {
                                            this.selectedItems.put(sId, new HashSet());
                                        }
                                        if (lastID != null && !lastID.equals(sId) && !this.groupById) {
                                            try {
                                                boolean allSelected = true;
                                                items22 = NonNullList.func_191196_a();
                                                ItemStack test = UnknownItem.wrap(lastID, 0, null);
                                                if (!test.func_190926_b()) {
                                                    try {
                                                        test.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items22);
                                                    }
                                                    catch (Throwable e) {
                                                        items22.add((Object)test);
                                                    }
                                                }
                                                for (ItemStack item : items22) {
                                                    if (this.selectedItems.get(lastID).contains(item.func_77960_j())) continue;
                                                    allSelected = false;
                                                    break;
                                                }
                                                if (allSelected) {
                                                    this.selectedItems.get(lastID).clear();
                                                    this.selectedItems.get(lastID).add((Integer)Short.MAX_VALUE);
                                                }
                                            }
                                            catch (Throwable allSelected) {
                                                // empty catch block
                                            }
                                        }
                                        HashSet<Integer> selectedMetadata = this.selectedItems.get(sId);
                                        sMetadata = Short.MAX_VALUE;
                                        try {
                                            if (!this.groupById) {
                                                sMetadata = s.func_77960_j();
                                            }
                                            if (!s.func_77981_g()) {
                                                sMetadata = Short.MAX_VALUE;
                                            }
                                        }
                                        catch (Throwable items22) {
                                            // empty catch block
                                        }
                                        if (sMetadata == Short.MAX_VALUE) {
                                            selectedMetadata.clear();
                                        } else if (selectedMetadata.contains(Short.MAX_VALUE)) {
                                            selectedMetadata.clear();
                                        }
                                        selectedMetadata.add(sMetadata);
                                        lastID = sId;
                                    }
                                    if (lastID != null && !this.groupById) {
                                        try {
                                            boolean allSelected = true;
                                            NonNullList items7 = NonNullList.func_191196_a();
                                            ItemStack test = UnknownItem.wrap(lastID, 0, null);
                                            if (!test.func_190926_b()) {
                                                try {
                                                    test.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, items7);
                                                }
                                                catch (Throwable e) {
                                                    items7.add((Object)test);
                                                }
                                            }
                                            for (ItemStack item : items7) {
                                                if (this.selectedItems.get(lastID).contains(item.func_77960_j())) continue;
                                                allSelected = false;
                                                break;
                                            }
                                            if (allSelected) {
                                                this.selectedItems.get(lastID).clear();
                                                this.selectedItems.get(lastID).add((Integer)Short.MAX_VALUE);
                                            }
                                        }
                                        catch (Throwable allSelected) {}
                                    }
                                }
                            }
                            if (this.gui != null) {
                                this.gui.func_73876_c();
                            }
                            this.selectedMetadata.clear();
                            this.metaScrollPos = 0;
                            if (stack.func_190926_b()) break block135;
                            this.selectedItemPos = slot + this.scrollPos * 8;
                            this.cachedId = this.selectedId = id;
                            this.selectedMeta = 0;
                            this.updateMetadata();
                            if (!this.groupById && stack.func_77973_b().func_77614_k()) {
                                for (int i = 0; i < this.selectedMetadata.size(); ++i) {
                                    if (((ItemStack)this.selectedMetadata.get(i)).func_77960_j() != stack.func_77960_j()) continue;
                                    this.selectedMeta = i + 1;
                                }
                                this.metaScrollPos = this.selectedMeta - 3;
                                if (this.metaScrollPos + 6 > this.selectedMetadata.size()) {
                                    this.metaScrollPos = this.selectedMetadata.size() - 6;
                                }
                                if (this.metaScrollPos < 0) {
                                    this.metaScrollPos = 0;
                                }
                            }
                            break block136;
                        }
                        this.selectedItemPos = -1;
                        this.selectedId = null;
                        this.cachedId = null;
                        this.selectedMeta = -1;
                    }
                    this.broadcastChange();
                    this.enableButtons();
                    return true;
                }
                for (int i = 0; i < items.size(); ++i) {
                    if (((ItemStack)items.get(i)).func_77960_j() != this.lastClickedMeta) continue;
                    lastMetaPos = i + 1;
                    break;
                }
            }
            if (!this.selectedItems.containsKey(this.lastClickedItemId)) {
                this.selectedItems.put(this.lastClickedItemId, new HashSet());
            }
            HashSet<Integer> selectedMetadata = this.selectedItems.get(this.lastClickedItemId);
            if (lastMetaPos < 1 || this.selectedMeta < 1) {
                this.selectedMeta = 0;
                lastMetaPos = 0;
                selectedMetadata.clear();
                selectedMetadata.add((Integer)Short.MAX_VALUE);
            }
            if (lastMetaPos >= items.size()) {
                lastMetaPos = items.size() - 1;
            }
            if (!selectedMetadata.contains(Short.MAX_VALUE)) {
                try {
                    for (int i = Math.min(lastMetaPos, this.selectedMeta); i <= Math.max(lastMetaPos, this.selectedMeta); ++i) {
                        selectedMetadata.add(((ItemStack)items.get(i - 1)).func_77960_j());
                    }
                    boolean allSelected = true;
                    for (ItemStack item : items) {
                        if (selectedMetadata.contains(item.func_77960_j())) continue;
                        allSelected = false;
                        break;
                    }
                    if (allSelected) {
                        selectedMetadata.clear();
                        selectedMetadata.add((Integer)Short.MAX_VALUE);
                    }
                }
                catch (Throwable allSelected) {}
            }
        }
        this.broadcastChange();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseDragged(int x, int y, int button) {
        if (this.dragScrolling) {
            int scrollbarSize = 38;
            if (this.thumbSize != scrollbarSize) {
                this.setScrollPercent((float)(y - this.scrollOffset - 32) / (float)(scrollbarSize - this.thumbSize));
            } else {
                this.setScrollPercent(0.0f);
            }
            return true;
        }
        return false;
    }

    public String getModName(Item item) {
        try {
            ModContainer container;
            ResourceLocation identifier = item.getRegistryName();
            if (identifier == null && item instanceof ItemBlock) {
                identifier = ((ItemBlock)item).func_179223_d().getRegistryName();
            }
            if (identifier != null && (container = (ModContainer)Loader.instance().getIndexedModList().get(identifier.func_110624_b())) != null) {
                return container.getName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "Minecraft";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseUp(int x, int y, int button) {
        if (this.dragScrolling) {
            this.dragScrolling = false;
            if (this.gui != null) {
                this.gui.func_73876_c();
            }
            return true;
        }
        return false;
    }

    public boolean filterItem(EntityPlayer player, String id, ItemStack test, Object tab) {
        boolean matches;
        block28: {
            block30: {
                block29: {
                    String s;
                    Item item;
                    matches = false;
                    if (id == null) {
                        id = "null";
                    }
                    if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id))) == null) break block29;
                    if (tab instanceof CustomTab) {
                        matches = ((CustomTab)tab).hasItem(id, test.func_190926_b() ? Short.MAX_VALUE : test.func_77960_j());
                    } else if (tab != null) {
                        if (tab == CreativeTabs.field_78036_m) {
                            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                                if (player.field_71071_by.func_70301_a(i).func_190926_b() || !UnknownItem.getItemDescriptor(player.field_71071_by.func_70301_a(i)).equals(id) || !test.func_190926_b() && test.func_77960_j() != player.field_71071_by.func_70301_a(i).func_77960_j()) continue;
                                matches = true;
                                break;
                            }
                        } else if (tab == CreativeTabs.field_78027_g) {
                            matches = true;
                        } else {
                            for (CreativeTabs t : item.getCreativeTabs()) {
                                if (t != tab) continue;
                                matches = true;
                                break;
                            }
                        }
                    }
                    if (!matches || this.textField == null || this.textField.getText().length() <= 0) break block28;
                    matches = false;
                    String filter = this.textField.getText().trim().toLowerCase();
                    NonNullList items = NonNullList.func_191196_a();
                    if (test.func_190926_b()) {
                        try {
                            item.func_150895_a(CreativeTabs.field_78027_g, items);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        items.add((Object)test);
                    }
                    if (items.size() > 0 && ((ItemStack)items.get(0)).func_77973_b() != null && (s = this.getModName(((ItemStack)items.get(0)).func_77973_b())) != null && s.toLowerCase().contains(filter)) {
                        matches = true;
                    }
                    block4: for (ItemStack stack : items) {
                        if (!matches) {
                            for (Object s2 : this.getItemStackTooltip(player, stack)) {
                                if (!(s2 instanceof String) || !((String)s2).toLowerCase().contains(filter)) continue;
                                matches = true;
                                continue block4;
                            }
                            continue;
                        }
                        break block28;
                    }
                    break block28;
                }
                if (!id.toLowerCase().startsWith("oredict:") || !this.oreDictItems.contains(id.substring(8))) break block30;
                if (tab == CreativeTabs.field_78027_g || tab == this.oreDictItems) {
                    matches = this.showOreDicts;
                }
                if (!matches || this.textField == null || this.textField.getText().length() <= 0) break block28;
                String filter = this.textField.getText().trim().toLowerCase();
                matches = id.toLowerCase().contains(filter);
                break block28;
            }
            if (this.additionalItems.containsKey(id)) {
                if (tab == null || tab == CreativeTabs.field_78027_g) {
                    matches = true;
                } else if (tab == CreativeTabs.field_78036_m) {
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        if (!UnknownItem.getItemDescriptor(player.field_71071_by.func_70301_a(i)).equals(id) || !test.func_190926_b() && test.func_77960_j() != player.field_71071_by.func_70301_a(i).func_77960_j()) continue;
                        matches = true;
                        break;
                    }
                }
                if (matches && this.textField != null && this.textField.getText().length() > 0) {
                    matches = false;
                    String filter = this.textField.getText().trim().toLowerCase();
                    for (Integer m : this.additionalItems.get(id)) {
                        if (!test.func_190926_b() && m.intValue() != test.func_77960_j()) continue;
                        for (Object s : this.getItemStackTooltip(player, UnknownItem.wrap(id, m, null))) {
                            if (!(s instanceof String) || !((String)s).toLowerCase().contains(filter)) continue;
                            matches = true;
                            break;
                        }
                        if (!matches) continue;
                        break;
                    }
                }
            }
        }
        return matches;
    }

    @SideOnly(value=Side.CLIENT)
    public void filter() {
        ItemStack stack;
        CustomTab tab;
        this.filteredBlocks.clear();
        if (this.activeTab < -this.customTabs.size() || this.activeTab >= CreativeTabs.field_78032_a.length + (this.showOreDicts ? 1 : 0) + 1) {
            this.activeTab = CreativeTabs.field_78027_g.func_78021_a();
        }
        this.lastClickedItemPos = -1;
        this.selectedId = this.cachedId;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Object stillExists = ItemStack.field_190927_a;
        Object object = this.activeTab < 0 ? this.customTabs.get(-(this.activeTab + 1)) : (this.activeTab == CreativeTabs.field_78032_a.length + (this.showOreDicts ? 1 : 0) ? null : (tab = this.activeTab == CreativeTabs.field_78032_a.length ? this.oreDictItems : CreativeTabs.field_78032_a[this.activeTab]));
        if (this.textField != null && this.textField.getText() != null) {
            this.filterText = this.textField.getText();
        }
        HashSet<String> others = new HashSet<String>(this.additionalItems.keySet());
        Iterator iterator = ForgeRegistries.ITEMS.iterator();
        while (iterator.hasNext()) {
            String id = "null";
            try {
                id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)((Item)iterator.next())).toString();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            others.remove(id);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            if (this.groupById || !item.func_77614_k()) {
                if (!this.filterItem((EntityPlayer)player, id, ItemStack.field_190927_a, tab)) continue;
                stack = UnknownItem.wrap(id, 0, null);
                if (id.equals(this.selectedId)) {
                    this.selectedItemPos = this.filteredBlocks.size();
                    stillExists = stack;
                    this.scrollPos = (this.filteredBlocks.size() - 1) / 8 - 2;
                }
                if (id.equals(this.lastClickedItemId)) {
                    this.lastClickedItemPos = this.filteredBlocks.size();
                    this.lastClickedMeta = Short.MAX_VALUE;
                }
                this.filteredBlocks.add(stack);
                continue;
            }
            HashSet<Integer> otherMetadata = new HashSet<Integer>();
            if (item != null) {
                NonNullList items = NonNullList.func_191196_a();
                try {
                    item.func_150895_a(CreativeTabs.field_78027_g, items);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Iterator<Integer> iterator2 = items.iterator();
                while (iterator2.hasNext()) {
                    ItemStack s = (ItemStack)iterator2.next();
                    if (!this.filterItem((EntityPlayer)player, id, s, tab)) continue;
                    s = s.func_77946_l();
                    otherMetadata.add(s.func_77960_j());
                    if (id.equals(this.selectedId) && (this.selectedMeta == 0 || s.func_77960_j() == ((ItemStack)this.selectedMetadata.get(this.selectedMeta - 1)).func_77960_j())) {
                        this.selectedItemPos = this.filteredBlocks.size();
                        stillExists = s;
                        this.scrollPos = (this.filteredBlocks.size() - 1) / 8 - 2;
                    }
                    if (id.equals(this.lastClickedItemId) && (this.lastClickedMeta == Short.MAX_VALUE || s.func_77960_j() == this.lastClickedMeta)) {
                        this.lastClickedItemPos = this.filteredBlocks.size();
                    }
                    this.filteredBlocks.add(s);
                }
            }
            if (!this.additionalItems.containsKey(id)) continue;
            for (Integer m : this.additionalItems.get(id)) {
                Iterator stack2;
                if (otherMetadata.contains(m) || m == Short.MAX_VALUE || !this.filterItem((EntityPlayer)player, id, (ItemStack)(stack2 = UnknownItem.wrap(id, m, null)), tab)) continue;
                if (id.equals(this.selectedId) && (this.selectedMeta == 0 || stack2.func_77960_j() == ((ItemStack)this.selectedMetadata.get(this.selectedMeta - 1)).func_77960_j())) {
                    this.selectedItemPos = this.filteredBlocks.size();
                    stillExists = stack2;
                    this.scrollPos = (this.filteredBlocks.size() - 1) / 8 - 2;
                }
                if (id.equals(this.lastClickedItemId) && (this.lastClickedMeta == Short.MAX_VALUE || stack2.func_77960_j() == this.lastClickedMeta)) {
                    this.lastClickedItemPos = this.filteredBlocks.size();
                }
                this.filteredBlocks.add((ItemStack)stack2);
            }
        }
        if (this.showOreDicts) {
            ArrayList<String> sortedNames = new ArrayList<String>(this.oreDictItems);
            Collections.sort(sortedNames);
            for (String name : sortedNames) {
                String id = "oredict:" + name;
                if (!this.filterItem((EntityPlayer)player, id, null, tab)) continue;
                ItemStack stack3 = UnknownItem.wrap(id, 0, null);
                if (id.equals(this.selectedId)) {
                    this.selectedItemPos = this.filteredBlocks.size();
                    stillExists = stack3;
                    this.scrollPos = (this.filteredBlocks.size() - 1) / 8 - 2;
                }
                if (id.equals(this.lastClickedItemId)) {
                    this.lastClickedItemPos = this.filteredBlocks.size();
                    this.lastClickedMeta = Short.MAX_VALUE;
                }
                this.filteredBlocks.add(stack3);
            }
        }
        for (String id : others) {
            if (id == null) continue;
            if (this.groupById) {
                if (!this.filterItem((EntityPlayer)player, id, ItemStack.field_190927_a, tab)) continue;
                stack = UnknownItem.wrap(id, 0, null);
                if (id.equals(this.selectedId)) {
                    this.selectedItemPos = this.filteredBlocks.size();
                    stillExists = stack;
                    this.scrollPos = (this.filteredBlocks.size() - 1) / 8 - 2;
                }
                if (id.equals(this.lastClickedItemId)) {
                    this.lastClickedItemPos = this.filteredBlocks.size();
                }
                this.filteredBlocks.add(stack);
                continue;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id));
            HashSet<Integer> otherMetadata = new HashSet<Integer>();
            if (item != null) {
                NonNullList items = NonNullList.func_191196_a();
                try {
                    item.func_150895_a(CreativeTabs.field_78027_g, items);
                }
                catch (Throwable stack2) {
                    // empty catch block
                }
                for (ItemStack s : items) {
                    if (!this.filterItem((EntityPlayer)player, id, s, tab)) continue;
                    s = s.func_77946_l();
                    otherMetadata.add(s.func_77960_j());
                    if (id.equals(this.selectedId) && (this.selectedMeta == 0 || s.func_77960_j() == ((ItemStack)this.selectedMetadata.get(this.selectedMeta - 1)).func_77960_j())) {
                        this.selectedItemPos = this.filteredBlocks.size();
                        stillExists = s;
                        this.scrollPos = (this.filteredBlocks.size() - 1) / 8 - 2;
                    }
                    if (id.equals(this.lastClickedItemId) && (this.lastClickedMeta == Short.MAX_VALUE || s.func_77960_j() == this.lastClickedMeta)) {
                        this.lastClickedItemPos = this.filteredBlocks.size();
                    }
                    this.filteredBlocks.add(s);
                }
            }
            if (!this.additionalItems.containsKey(id)) continue;
            for (Integer m : this.additionalItems.get(id)) {
                ItemStack stack4;
                if (otherMetadata.contains(m) || m == Short.MAX_VALUE || !this.filterItem((EntityPlayer)player, id, stack4 = UnknownItem.wrap(id, m, null), tab)) continue;
                if (id.equals(this.selectedId) && (this.selectedMeta == 0 || stack4.func_77960_j() == ((ItemStack)this.selectedMetadata.get(this.selectedMeta - 1)).func_77960_j())) {
                    this.selectedItemPos = this.filteredBlocks.size();
                    stillExists = stack4;
                    this.scrollPos = (this.filteredBlocks.size() - 1) / 8 - 2;
                }
                if (id.equals(this.lastClickedItemId) && (this.lastClickedMeta == Short.MAX_VALUE || stack4.func_77960_j() == this.lastClickedMeta)) {
                    this.lastClickedItemPos = this.filteredBlocks.size();
                }
                this.filteredBlocks.add(stack4);
            }
        }
        if (stillExists.func_190926_b()) {
            this.selectedItemPos = -1;
            this.selectedId = null;
            this.selectedMeta = 0;
            this.selectedMetadata.clear();
            this.metaScrollPos = 0;
            this.broadcastChange();
        } else {
            this.scrollPos = (this.filteredBlocks.indexOf(stillExists) - 1) / 8 - 2;
            this.updateMetadata();
            this.broadcastChange();
        }
        this.blockLines = (this.filteredBlocks.size() + 7) / 8;
        this.updateScrollPos(true);
        this.enableButtons();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateMetadata() {
        this.selectedMetadata.clear();
        if (this.selectedId == null) {
            return;
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.selectedId));
        if (item != null) {
            try {
                item.func_150895_a(CreativeTabs.field_78027_g, this.selectedMetadata);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.additionalItems.containsKey(this.selectedId)) {
            for (Integer metadata : this.additionalItems.get(this.selectedId)) {
                boolean alreadyExists = metadata == Short.MAX_VALUE;
                for (ItemStack stack : this.selectedMetadata) {
                    if (stack.func_77960_j() != metadata.intValue()) continue;
                    alreadyExists = true;
                }
                if (alreadyExists) continue;
                this.selectedMetadata.add((Object)UnknownItem.wrap(this.selectedId, metadata, null));
            }
        }
    }

    public static interface BlockSelectionListener {
        @SideOnly(value=Side.CLIENT)
        public void selectionChanged(String var1, int var2);

        public boolean allowMultipleSelections();

        public void addCustomTabs(ArrayList<CustomTab> var1);

        public void selectionsChanged(HashMap<String, HashSet<Integer>> var1);
    }

    public static interface AdditionalItemProvider {
        public void addItems(HashMap<String, HashSet<Integer>> var1, HashSet<String> var2);
    }

    private class MetaInventory
    extends ContainerStack.InvalidInventory {
        private boolean wildcard = true;

        private MetaInventory() {
        }

        @Override
        public ItemStack func_70301_a(int i) {
            if (BlockSelector.this.selectedId == null || i + BlockSelector.this.metaScrollPos > BlockSelector.this.selectedMetadata.size()) {
                return ItemStack.field_190927_a;
            }
            if (i + BlockSelector.this.metaScrollPos == 0) {
                return UnknownItem.wrap(BlockSelector.this.selectedId, this.wildcard ? Short.MAX_VALUE : 0, null);
            }
            return (ItemStack)BlockSelector.this.selectedMetadata.get(i + BlockSelector.this.metaScrollPos - 1);
        }

        public void setWildcard(boolean on) {
            this.wildcard = on;
        }

        @Override
        public int func_70302_i_() {
            return 7;
        }
    }

    public static interface CustomTab {
        public String getName();

        public ItemStack getIcon();

        public boolean hasItem(String var1, int var2);
    }

    private class TabIconInventory
    extends ContainerStack.InvalidInventory {
        public int tab = 0;

        private TabIconInventory() {
        }

        @Override
        public ItemStack func_70301_a(int i) {
            if (this.tab < 0) {
                return BlockSelector.this.customTabs.get(-(this.tab + 1)).getIcon();
            }
            if (this.tab == CreativeTabs.field_78032_a.length + (BlockSelector.this.showOreDicts ? 1 : 0)) {
                return new ItemStack((Item)Common.unknownItem);
            }
            if (this.tab == CreativeTabs.field_78032_a.length) {
                return new ItemStack(Blocks.field_150366_p);
            }
            if (this.tab >= CreativeTabs.field_78032_a.length || CreativeTabs.field_78032_a[this.tab] == null) {
                return ItemStack.field_190927_a;
            }
            return CreativeTabs.field_78032_a[this.tab].func_151244_d();
        }

        @Override
        public int func_70302_i_() {
            return 1;
        }
    }
}

