/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.entity;

import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.ModConfig;
import net.blay09.mods.farmingforblockheads.ModSounds;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.entity.EntityAIMerchant;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityMerchant
extends EntityCreature
implements INpc {
    private static final Random rand = new Random();
    private BlockPos marketPos;
    private EnumFacing facing;
    private boolean spawnAnimationStarted;
    private boolean spawnDone;
    private SpawnAnimationType spawnAnimation = SpawnAnimationType.MAGIC;
    private BlockPos marketEntityPos;
    private int diggingAnimation;
    private IBlockState diggingBlockState;

    public EntityMerchant(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityZombie.class, 8.0f, 0.6, 0.6));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMerchant(this, 0.6));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.isMarketValid()) {
            player.openGui((Object)"farmingforblockheads", 1, this.field_70170_p, this.marketPos.func_177958_n(), this.marketPos.func_177956_o(), this.marketPos.func_177952_p());
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.marketPos != null) {
            compound.func_74772_a("MarketPos", this.marketPos.func_177986_g());
        }
        if (this.facing != null) {
            compound.func_74774_a("Facing", (byte)this.facing.func_176745_a());
        }
        compound.func_74757_a("SpawnDone", this.spawnDone);
        compound.func_74774_a("SpawnAnimation", (byte)this.spawnAnimation.ordinal());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (!this.func_145818_k_()) {
            this.func_96094_a(ModConfig.general.merchantNames[rand.nextInt(ModConfig.general.merchantNames.length)]);
        }
        if (compound.func_74764_b("MarketPos")) {
            this.setMarket(BlockPos.func_177969_a((long)compound.func_74763_f("MarketPos")), EnumFacing.func_82600_a((int)compound.func_74771_c("Facing")));
        }
        this.spawnDone = compound.func_74767_n("SpawnDone");
        this.spawnAnimation = SpawnAnimationType.values()[compound.func_74771_c("SpawnAnimation")];
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187910_gj;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187912_gl;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187911_gk;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && !this.isMarketValid()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            this.func_70106_y();
        }
        if (!this.spawnDone && !this.spawnAnimationStarted) {
            this.spawnAnimationStarted = true;
            switch (this.spawnAnimation) {
                case DIGGING: {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)13);
                    break;
                }
                case FALLING: {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)14);
                    break;
                }
                case MAGIC: {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)15);
                }
            }
        }
        if (this.diggingAnimation > 0) {
            --this.diggingAnimation;
            for (int i = 0; i < 4; ++i) {
                int stateId = Block.func_176210_f((IBlockState)(this.diggingBlockState != null ? this.diggingBlockState : Blocks.field_150346_d.func_176223_P()));
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t, this.field_70163_u, this.field_70161_v, Math.random() * 2.0 - 1.0, Math.random() * 4.0, Math.random() * 2.0 - 1.0, new int[]{stateId});
                this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, this.field_70165_t, this.field_70163_u, this.field_70161_v, (Math.random() - 0.5) * 0.5, Math.random() * 0.5, (Math.random() - 0.5) * 0.5, new int[]{stateId});
            }
            if (this.diggingAnimation % 2 == 0) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, Blocks.field_150346_d.func_185467_w().func_185846_f(), SoundCategory.BLOCKS, 1.0f, (float)(Math.random() + 0.5), false);
            }
        }
    }

    public void func_70103_a(byte id) {
        if (id == 12) {
            this.disappear();
        } else if (id == 13) {
            this.diggingBlockState = this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b());
            this.diggingAnimation = 60;
        } else if (id == 14) {
            BlockPos pos = this.field_70170_p.func_175672_r(this.func_180425_c());
            this.field_70170_p.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), ModSounds.falling, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        } else if (id == 15) {
            this.field_70170_p.func_184134_a(this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, SoundEvents.field_187616_bj, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
            for (int i = 0; i < 50; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, new int[0]);
            }
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5, 0.0, 0.0, 0.0, new int[0]);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_70665_d(DamageSource damageSource, float damageAmount) {
        if (!this.spawnDone && damageSource == DamageSource.field_76379_h) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_184601_bQ(damageSource), SoundCategory.NEUTRAL, 1.0f, 2.0f, false);
            this.spawnDone = true;
            return;
        }
        super.func_70665_d(damageSource, damageAmount);
    }

    public float func_70047_e() {
        return 1.62f;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingData) {
        if (Math.random() < 0.001) {
            this.func_96094_a(Math.random() <= 0.5 ? "Pam" : "Blay");
        } else {
            this.func_96094_a(ModConfig.general.merchantNames[rand.nextInt(ModConfig.general.merchantNames.length)]);
        }
        return super.func_180482_a(difficulty, livingData);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public void setMarket(BlockPos marketPos, EnumFacing facing) {
        this.marketPos = marketPos;
        this.marketEntityPos = marketPos.func_177972_a(facing.func_176734_d());
        this.facing = facing;
    }

    @Nullable
    public BlockPos getMarketEntityPosition() {
        return this.marketEntityPos;
    }

    public boolean isAtMarket() {
        return this.marketEntityPos != null && this.func_174818_b(this.marketEntityPos.func_177972_a(this.facing.func_176734_d())) <= 1.0;
    }

    private boolean isMarketValid() {
        return this.marketPos != null && this.field_70170_p.func_180495_p(this.marketPos).func_177230_c() == ModBlocks.market;
    }

    public void setToFacingAngle() {
        float facingAngle = this.facing.func_185119_l();
        this.func_70101_b(facingAngle, 0.0f);
        this.func_70034_d(facingAngle);
        this.func_181013_g(facingAngle);
    }

    public void disappear() {
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187616_bj, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        for (int i = 0; i < 50; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.FIREWORKS_SPARK, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, (Math.random() - 0.5) * 0.5, new int[0]);
        }
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        this.func_70106_y();
    }

    public void setSpawnAnimation(SpawnAnimationType spawnAnimation) {
        this.spawnAnimation = spawnAnimation;
    }

    public int getDiggingAnimation() {
        return this.diggingAnimation;
    }

    public static enum SpawnAnimationType {
        MAGIC,
        FALLING,
        DIGGING;

    }
}

