/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.terraingen;

import java.util.Random;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.lost.BiomeInfo;
import mcjty.lostcities.varia.ChunkCoord;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class NormalTerrainGenerator {
    private World world;
    protected LostCityChunkGenerator provider;
    public final double[] heightMap;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves depthNoise;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];

    public NormalTerrainGenerator(LostCityChunkGenerator provider) {
        this.provider = provider;
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = (float)(10.0 / Math.sqrt((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public void setup(World world) {
        this.world = world;
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(this.provider.rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(this.provider.rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(this.provider.rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(this.provider.rand, 4);
        NoiseGeneratorOctaves noiseGen5 = new NoiseGeneratorOctaves(this.provider.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.provider.rand, 16);
        NoiseGeneratorOctaves mobSpawnerNoise = new NoiseGeneratorOctaves(this.provider.rand, 8);
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, noiseGen5, this.depthNoise, mobSpawnerNoise);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((World)world, (Random)this.provider.rand, (InitNoiseGensEvent.Context)ctx);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.surfaceNoise = ctx.getHeight();
        this.depthNoise = ctx.getDepth();
    }

    public void generateHeightmap(int chunkX, int chunkZ) {
        int chunkX4 = chunkX * 4;
        int chunkZ4 = chunkZ * 4;
        ChunkGeneratorSettings settings = this.provider.getSettings();
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, chunkX4, chunkZ4, 5, 5, (double)settings.field_177808_e, (double)settings.field_177803_f, (double)settings.field_177804_g);
        float f = settings.field_177811_a;
        float f1 = settings.field_177809_b;
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, chunkX4, 0, chunkZ4, 5, 33, 5, (double)(f / settings.field_177825_h), (double)(f1 / settings.field_177827_i), (double)(f / settings.field_177821_j));
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, chunkX4, 0, chunkZ4, 5, 33, 5, (double)f, (double)f1, (double)f);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, chunkX4, 0, chunkZ4, 5, 33, 5, (double)f, (double)f1, (double)f);
        int i = 0;
        int j = 0;
        Biome[] biomes = BiomeInfo.getBiomeInfo(this.provider, new ChunkCoord(this.provider.dimensionId, chunkX, chunkZ)).getBiomes();
        float biomeDepthOffSet = settings.field_177813_n;
        float biomeDepthWeight = settings.field_177819_m;
        float biomeScaleOffset = settings.field_177843_p;
        float biomeScaleWeight = settings.field_177815_o;
        for (int k = 0; k < 5; ++k) {
            for (int l = 0; l < 5; ++l) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                Biome biome = biomes[k + 2 + (l + 2) * 10];
                float biomeBaseHeight = biome.func_185355_j();
                for (int j1 = -2; j1 <= 2; ++j1) {
                    for (int k1 = -2; k1 <= 2; ++k1) {
                        Biome biome1 = biomes[k + j1 + 2 + (l + k1 + 2) * 10];
                        float biome1BaseHeight = biome1.func_185355_j();
                        float baseHeight = biomeDepthOffSet + biome1BaseHeight * biomeDepthWeight;
                        float heightVariation = Math.abs(biomeScaleOffset + biome1.func_185360_m() * biomeScaleWeight);
                        float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (baseHeight + 2.0f);
                        if (biome1BaseHeight > biomeBaseHeight) {
                            f7 /= 2.0f;
                        }
                        f2 += heightVariation * f7;
                        f3 += baseHeight * f7;
                        f4 += f7;
                    }
                }
                f2 /= f4;
                f3 /= f4;
                f2 = f2 * 0.9f + 0.1f;
                f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.depthRegion[j] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++j;
                double d13 = f3;
                double d14 = f2;
                d13 += d12 * 0.2;
                d13 = d13 * (double)settings.field_177823_k / 8.0;
                double d5 = (double)settings.field_177823_k + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * (double)settings.field_177817_l * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[i] / (double)settings.field_177806_d;
                    double d8 = this.maxLimitRegion[i] / (double)settings.field_177810_c;
                    double d9 = (this.mainNoiseRegion[i] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151237_a((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[i] = d10;
                    ++i;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, ChunkPrimer primer, Biome[] Biomes2) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks((IChunkGenerator)this.provider, chunkX, chunkZ, primer, this.world);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(chunkX * 16), (double)(chunkZ * 16), 16, 16, d0 * 2.0, d0 * 2.0, 1.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                Biome Biome2 = Biomes2[l + k * 16];
                Biome2.func_180622_a(this.world, this.provider.rand, primer, chunkX * 16 + k, chunkZ * 16 + l, this.depthBuffer[l + k * 16]);
            }
        }
    }
}

