/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.latmod.yabba.api.YabbaConfigEvent;
import com.latmod.yabba.tile.IItemBarrel;
import com.latmod.yabba.tile.TileBarrelBase;
import com.latmod.yabba.tile.TileItemBarrelConnector;
import com.latmod.yabba.util.UpgradeInst;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCompoundItemBarrel
extends TileBarrelBase
implements IItemBarrel {
    private ItemStack storedItem = ItemStack.field_190927_a;
    private int itemCount = 0;

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    @Override
    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (type != EnumSaveType.SAVE) {
            return;
        }
        if (this.itemCount > 0) {
            nbt.func_74768_a("Count", this.itemCount);
        }
        super.writeData(nbt, type);
        if (!this.storedItem.func_190926_b()) {
            this.storedItem.func_190920_e(1);
            nbt.func_74782_a("Item", (NBTBase)this.storedItem.serializeNBT());
        }
    }

    @Override
    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        if (type != EnumSaveType.SAVE) {
            return;
        }
        this.setRawItemCount(nbt.func_74762_e("Count"));
        super.readData(nbt, type);
        ItemStack itemStack = this.storedItem = nbt.func_74764_b("Item") ? new ItemStack(nbt.func_74775_l("Item")) : ItemStack.field_190927_a;
        if (this.storedItem.func_190926_b()) {
            this.storedItem = ItemStack.field_190927_a;
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TileItemBarrelConnector.markAllDirty(this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            TileItemBarrelConnector.markAllDirty(this.field_174879_c, this.field_145850_b.field_73011_w.getDimension());
        }
    }

    @Override
    public void func_70296_d() {
        this.sendDirtyUpdate();
    }

    @Override
    public int getItemCount() {
        return this.itemCount;
    }

    @Override
    public void setRawItemCount(int v) {
        this.itemCount = v;
    }

    @Override
    public ItemStack getStoredItemType() {
        return this.storedItem;
    }

    @Override
    public void setRawItemType(ItemStack type) {
        this.storedItem = type;
    }

    @Override
    public void createConfig(YabbaConfigEvent event) {
        super.createConfig(event);
        String group = "yabba";
        event.getConfig().setGroupName(group, (ITextComponent)new TextComponentString("YABBA"));
        if (!this.tier.creative()) {
            event.getConfig().add(group, "locked", (ConfigValue)this.isLocked);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18n.func_135052_a((String)"lang.yabba.tier", (Object[])new Object[]{I18n.func_135052_a((String)this.tier.getLangKey(), (Object[])new Object[0])}));
        if (this.isLocked()) {
            tooltip.add(I18n.func_135052_a((String)"barrel_config.yabba.locked", (Object[])new Object[0]));
        }
        if (!this.storedItem.func_190926_b()) {
            tooltip.add(I18n.func_135052_a((String)"lang.yabba.item", (Object[])new Object[]{this.storedItem.func_82833_r()}));
        }
        if (!this.tier.creative()) {
            if (this.tier.infiniteCapacity()) {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count_inf", (Object[])new Object[]{this.itemCount}));
            } else if (!this.storedItem.func_190926_b()) {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count", (Object[])new Object[]{this.itemCount, this.getMaxItems(this.storedItem)}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count_max", (Object[])new Object[]{this.tier.maxItemStacks}));
            }
        }
        if (!this.upgrades.isEmpty()) {
            tooltip.add(I18n.func_135052_a((String)"lang.yabba.upgrades", (Object[])new Object[0]));
            for (UpgradeInst upgrade : this.upgrades.values()) {
                tooltip.add("> " + upgrade.getStack().func_82833_r());
            }
        }
    }

    @Override
    public boolean shouldDrop() {
        return this.itemCount > 0 || super.shouldDrop();
    }
}

