/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.item.ItemEntry;
import com.feed_the_beast.ftblib.lib.item.ItemEntryWithCount;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.tile.TileBase;
import com.latmod.yabba.YabbaConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileAntibarrel
extends TileBase
implements IItemHandler {
    public final Map<ItemEntry, ItemEntryWithCount> items = new LinkedHashMap<ItemEntry, ItemEntryWithCount>();
    private ItemEntryWithCount[] itemsArray = null;
    public int totalChanges = 0;

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : super.getCapability(capability, side));
    }

    public void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (type != EnumSaveType.SAVE) {
            return;
        }
        if (!this.items.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (ItemEntryWithCount entry : this.items.values()) {
                if (entry.isEmpty()) continue;
                list.func_74742_a((NBTBase)entry.serializeNBT());
            }
            nbt.func_74782_a("Inv", (NBTBase)list);
        }
    }

    public void readData(NBTTagCompound nbt, EnumSaveType type) {
        if (type != EnumSaveType.SAVE) {
            return;
        }
        this.items.clear();
        this.itemsArray = null;
        NBTTagList list = nbt.func_150295_c("Inv", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemEntryWithCount entryc = new ItemEntryWithCount(list.func_150305_b(i));
            if (entryc.isEmpty()) continue;
            this.items.put(entryc.entry, entryc);
        }
    }

    public int getSlots() {
        return this.items.size() + 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot <= 0 || slot > this.items.size() ? ItemStack.field_190927_a : this.getItemArray()[slot - 1].getStack(false);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemEntryWithCount entryc;
        if (slot < 0 || slot > this.items.size() || stack.func_190926_b() || stack.func_77985_e()) {
            return stack;
        }
        ItemEntry entry = ItemEntry.get((ItemStack)stack);
        int added = 0;
        if (slot == 0) {
            entryc = this.items.get(entry);
            if (entryc != null) {
                added = Math.min(YabbaConfig.general.antibarrel_items_per_type - entryc.count, stack.func_190916_E());
            } else if (this.items.size() < YabbaConfig.general.antibarrel_capacity) {
                entryc = new ItemEntryWithCount(entry, 0);
                this.items.put(entry, entryc);
                this.itemsArray = null;
                added = Math.min(YabbaConfig.general.antibarrel_items_per_type, stack.func_190916_E());
            }
        } else {
            entryc = this.getItemArray()[slot - 1];
            if (entryc.entry.equalsEntry(entry)) {
                added = Math.min(YabbaConfig.general.antibarrel_items_per_type - entryc.count, stack.func_190916_E());
            }
        }
        if (entryc != null && added > 0) {
            if (!simulate) {
                entryc.count += added;
                if (!this.field_145850_b.field_72995_K) {
                    ++this.totalChanges;
                    this.func_70296_d();
                }
            }
            return added == stack.func_190916_E() ? ItemStack.field_190927_a : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - added));
        }
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot <= 0 || slot > this.items.size() || amount < 1) {
            return ItemStack.field_190927_a;
        }
        ItemEntryWithCount entryc = this.getItemArray()[slot - 1];
        if (entryc.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        int extracted = Math.min(amount, entryc.count);
        ItemStack is = entryc.entry.getStack(extracted, true);
        if (!simulate) {
            entryc.count -= extracted;
            if (!this.field_145850_b.field_72995_K) {
                ++this.totalChanges;
                this.func_70296_d();
            }
        }
        return is;
    }

    public ItemEntryWithCount[] getItemArray() {
        if (this.itemsArray == null) {
            this.itemsArray = this.items.values().toArray(new ItemEntryWithCount[0]);
        }
        return this.itemsArray;
    }

    public int getSlotLimit(int slot) {
        return YabbaConfig.general.antibarrel_items_per_type;
    }

    public boolean notifyBlock() {
        return false;
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }

    public boolean shouldDrop() {
        return !this.items.isEmpty();
    }
}

