/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.feed_the_beast.ftblib.lib.client.SpriteSet;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.CommonUtils;
import com.feed_the_beast.ftblib.lib.util.misc.TextureSet;
import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.block.BlockAdvancedBarrelBase;
import com.latmod.yabba.client.BakedBarrelBlockModel;
import com.latmod.yabba.client.BarrelModel;
import com.latmod.yabba.client.YabbaClient;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;

public enum BarrelModelLoader implements IModel,
ICustomModelLoader,
IBlockColor,
IItemColor,
IStateMapper
{
    INSTANCE;

    public static final ModelResourceLocation MODEL_LOCATION;

    public boolean accepts(ResourceLocation modelLocation) {
        return modelLocation.func_110624_b().equals("yabba") && modelLocation.func_110623_a().equals("barrel");
    }

    public IModel loadModel(ResourceLocation modelLocation) {
        return this;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        YabbaClient.loadModelsAndSkins();
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return YabbaClient.TEXTURES;
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        TextureAtlasSprite particle = bakedTextureGetter.apply(new ResourceLocation("blocks/planks_oak"));
        for (BarrelSkin skin : YabbaClient.ALL_SKINS) {
            skin.spriteSet = skin.textures.getSpriteSet(bakedTextureGetter);
        }
        for (EnumBarrelModel id : EnumBarrelModel.NAME_MAP) {
            BarrelModel model = id.getModel();
            model.textureMap = new HashMap<String, SpriteSet>();
            for (Map.Entry<String, TextureSet> entry : model.textures.entrySet()) {
                model.textureMap.put(entry.getKey(), entry.getValue().getSpriteSet(bakedTextureGetter));
            }
        }
        return new BakedBarrelBlockModel(particle, format);
    }

    public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            Color4I color;
            String skin = null;
            if (state instanceof IExtendedBlockState) {
                skin = (String)((IExtendedBlockState)state).getValue(BlockAdvancedBarrelBase.SKIN);
            }
            if (!(color = YabbaClient.getSkin(skin).color).isEmpty()) {
                return color.rgba();
            }
        }
        return -1;
    }

    public int func_186726_a(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            Color4I color;
            String id = "";
            if (CommonUtils.hasBlockData((ItemStack)stack)) {
                id = CommonUtils.getBlockData((ItemStack)stack).func_74779_i("Skin");
            }
            if (!(color = YabbaClient.getSkin((String)id).color).isEmpty()) {
                return color.rgba();
            }
        }
        return -1;
    }

    public Map<IBlockState, ModelResourceLocation> func_178130_a(Block blockIn) {
        HashMap<IBlockState, ModelResourceLocation> map = new HashMap<IBlockState, ModelResourceLocation>();
        for (IBlockState state : blockIn.func_176194_O().func_177619_a()) {
            map.put(state, MODEL_LOCATION);
        }
        return map;
    }

    static {
        MODEL_LOCATION = new ModelResourceLocation("yabba:barrel#normal");
    }
}

