/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.util;

import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.item.tool.ItemGemDagger;
import net.silentchaos512.gems.item.tool.ItemGemKatana;
import net.silentchaos512.gems.item.tool.ItemGemMachete;
import net.silentchaos512.gems.item.tool.ItemGemScepter;
import net.silentchaos512.gems.item.tool.ItemGemSword;
import net.silentchaos512.gems.util.ToolHelper;

public enum EnumMagicType {
    NONE(0, 1.0f, 0),
    SWORD(2, 1.0f, 1000),
    KATANA(5, 1.0f, 2000),
    SCEPTER(5, 1.0f, 5000),
    MACHETE(8, 0.25f, 2500),
    DAGGER(1, 1.0f, 1000);

    final int shotCount;
    final float damagePerShot;
    final int cost;

    private EnumMagicType(int shotCount, float damagePerShot, int cost) {
        this.shotCount = shotCount;
        this.damagePerShot = damagePerShot;
        this.cost = cost;
    }

    public int getShotCount(ItemStack tool) {
        return this.shotCount;
    }

    public float getDamagePerShotMultiplier() {
        return this.damagePerShot;
    }

    public float getDamagePerShot(ItemStack tool) {
        float magic = 1.0f + ToolHelper.getMagicDamageModifier(tool);
        return magic * this.damagePerShot;
    }

    public int getCost(ItemStack tool) {
        return this.cost;
    }

    public static EnumMagicType getMagicType(ItemStack tool) {
        if (tool.func_77973_b() instanceof ItemGemDagger) {
            return DAGGER;
        }
        if (tool.func_77973_b() instanceof ItemGemMachete) {
            return MACHETE;
        }
        if (tool.func_77973_b() instanceof ItemGemScepter) {
            return SCEPTER;
        }
        if (tool.func_77973_b() instanceof ItemGemKatana) {
            return KATANA;
        }
        if (tool.func_77973_b() instanceof ItemGemSword) {
            return SWORD;
        }
        return NONE;
    }
}

