/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.tile;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.energy.IChaosAccepter;
import net.silentchaos512.gems.api.energy.IChaosProvider;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.lib.EnumModParticles;
import net.silentchaos512.gems.lib.NodeEffect;
import net.silentchaos512.gems.util.ChaosUtil;
import net.silentchaos512.gems.util.NodePacketHelper;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileEntitySL;
import net.silentchaos512.lib.util.Color;

public class TileChaosNode
extends TileEntitySL
implements ITickable,
IChaosProvider {
    public static final double SEARCH_RADIUS_SQUARED = 256.0;
    public static final int SEARCH_RADIUS_BLOCK = 6;
    public static final int SEND_CHAOS_DELAY = 200;
    public static final int SEND_CHAOS_AMOUNT = 2000;
    public static final int MAX_CHAOS_STORED = 10000;
    public static final int CHAOS_GENERATION_RATE = 20;
    @SyncVariable(name="Energy")
    int chaosStored = 0;
    List<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
    List<EntityLivingBase> passives = new ArrayList<EntityLivingBase>();
    List<EntityLivingBase> hostiles = new ArrayList<EntityLivingBase>();
    int timeSalt = -1;

    public void func_73660_a() {
        if (this.timeSalt < 0) {
            this.timeSalt = GemsConfig.CHAOS_NODE_SALT_DELAY ? this.field_174879_c.func_177958_n() * this.field_174879_c.func_177956_o() * this.field_174879_c.func_177952_p() % 400 : 0;
        }
        this.chaosStored = Math.min(this.getCharge() + 20, this.getMaxCharge());
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
            return;
        }
        this.players.clear();
        this.passives.clear();
        this.hostiles.clear();
        long time = this.field_145850_b.func_82737_E() + (long)this.timeSalt;
        Random random = SilentGems.random;
        boolean playSound = false;
        if (time % 200L == 0L) {
            List<IChaosAccepter> accepters = ChaosUtil.getNearbyAccepters(this.field_145850_b, this.field_174879_c, 6, 6);
            this.getPlayersInRange();
            if (!this.players.isEmpty() || !accepters.isEmpty()) {
                int amountForEach = Math.min(2000, this.getCharge() / (accepters.size() + this.players.size()));
                playSound |= this.sendChaosToPlayers(amountForEach);
                playSound |= this.sendChaosToAccepters(accepters, amountForEach);
            }
        }
        for (NodeEffect effect : NodeEffect.ALL_EFFECTS) {
            if (!effect.isTimeToTry(time)) continue;
            if (effect.targetPlayers) {
                this.getPlayersInRange();
                for (EntityPlayer entityPlayer : this.players) {
                    playSound |= this.tryApplyEffectToEntity((EntityLivingBase)entityPlayer, effect, random);
                }
            }
            if (effect.targetPassives) {
                this.getPassivesInRange();
                for (EntityLivingBase entityLivingBase : this.passives) {
                    playSound |= this.tryApplyEffectToEntity(entityLivingBase, effect, random);
                }
            }
            if (!effect.targetHostiles) continue;
            this.getHostilesInRange();
            for (EntityLivingBase entityLivingBase : this.hostiles) {
                playSound |= this.tryApplyEffectToEntity(entityLivingBase, effect, random);
            }
        }
        if (playSound) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187693_cj, SoundCategory.AMBIENT, 1.0f, (float)((double)0.4f + (double)0.05f * SilentGems.random.nextGaussian()));
        }
    }

    public boolean tryApplyEffectToEntity(EntityLivingBase entity, NodeEffect effect, Random random) {
        if (effect.applyToEntity(entity, random)) {
            NodePacketHelper.spawnParticles(this.field_145850_b, this.field_174879_c, entity.func_174791_d().func_72441_c(0.0, (double)(entity.field_70131_O / 2.0f), 0.0), effect.color);
            return true;
        }
        return false;
    }

    private void getPlayersInRange() {
        if (!this.players.isEmpty()) {
            return;
        }
        this.players = this.field_145850_b.func_175661_b(EntityPlayerMP.class, player -> player.func_174818_b(this.func_174877_v()) < 256.0 && this.canSee((Entity)player));
    }

    private void getPassivesInRange() {
        if (!this.passives.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.field_145850_b.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_145850_b.field_72996_f.get(i);
            if (!(entity instanceof EntityLivingBase) || entity instanceof IMob || !(entity.func_174818_b(this.field_174879_c) < 256.0) || !this.canSee(entity)) continue;
            this.passives.add((EntityLivingBase)entity);
        }
    }

    private void getHostilesInRange() {
        if (!this.hostiles.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.field_145850_b.field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.field_145850_b.field_72996_f.get(i);
            if (!(entity instanceof EntityLivingBase) || !(entity instanceof IMob) || !(entity.func_174818_b(this.field_174879_c) < 256.0) || !this.canSee(entity)) continue;
            this.hostiles.add((EntityLivingBase)entity);
        }
    }

    private boolean canSee(BlockPos target) {
        return ChaosUtil.canSee(this.field_145850_b, this.field_174879_c, target);
    }

    private boolean canSee(Entity target) {
        return ChaosUtil.canSee(this.field_145850_b, this.field_174879_c, target);
    }

    private boolean sendChaosToPlayers(int amountForEach) {
        this.getPlayersInRange();
        boolean flag = false;
        for (EntityPlayerMP player : this.players) {
            if (this.getCharge() <= 0) {
                return flag;
            }
            int amount = this.extractEnergy(amountForEach, true);
            int amountPlayerCanAccept = ChaosUtil.getAmountPlayerCanAccept((EntityPlayer)player, amount);
            if (amountPlayerCanAccept <= 0) continue;
            amount = Math.min(amount, amountPlayerCanAccept);
            this.extractEnergy(amount, false);
            ChaosUtil.sendEnergyTo(this.field_145850_b, this.field_174879_c, (EntityLivingBase)player, amount);
            flag = true;
        }
        return flag;
    }

    private boolean sendChaosToAccepters(List<IChaosAccepter> list, int amountForEach) {
        this.getPlayersInRange();
        boolean flag = false;
        for (IChaosAccepter accepter : list) {
            if (this.getCharge() <= 0) {
                return flag;
            }
            int amount = this.extractEnergy(amountForEach, true);
            if ((amount = accepter.receiveCharge(amount, true)) <= 0) continue;
            this.extractEnergy(amount, false);
            ChaosUtil.sendEnergyTo(this.field_145850_b, this.field_174879_c, ((TileEntity)accepter).func_174877_v(), amount);
            flag = true;
        }
        return flag;
    }

    private void spawnParticles() {
        Random rand = SilentGems.random;
        int particleSetting = GemsConfig.CHAOS_NODE_PARTICLE_OVERRIDE;
        if (particleSetting < 0) {
            particleSetting = SilentGems.proxy.getParticleSettings();
        }
        for (int i = 0; i < 3 / (1 + particleSetting); ++i) {
            if (!this.field_145850_b.field_72995_K) continue;
            double motionX = rand.nextGaussian() * (double)0.03f;
            double motionY = rand.nextGaussian() * (double)0.006f;
            double motionZ = rand.nextGaussian() * (double)0.03f;
            SilentGems.proxy.spawnParticles(EnumModParticles.CHAOS, TileChaosNode.selectParticleColor(rand), this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, motionX, motionY, motionZ);
        }
    }

    public static Color selectParticleColor(Random rand) {
        float shade = 0.7f + 0.3f * rand.nextFloat();
        float variation = 0.1875f;
        return new Color(MathHelper.func_76131_a((float)((float)((double)shade + (double)variation * rand.nextGaussian())), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((float)((double)shade + (double)variation * rand.nextGaussian())), (float)0.0f, (float)1.0f), MathHelper.func_76131_a((float)((float)((double)shade + (double)variation * rand.nextGaussian())), (float)0.0f, (float)1.0f));
    }

    @Override
    public int getCharge() {
        return this.chaosStored;
    }

    @Override
    public int getMaxCharge() {
        return 10000;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        int amount = Math.min(this.getCharge(), maxExtract);
        if (!simulate) {
            this.chaosStored -= amount;
        }
        return amount;
    }
}

