/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.silentchaos512.gems.api.energy.IChaosAccepter;
import net.silentchaos512.gems.api.energy.IChaosStorage;
import net.silentchaos512.gems.api.recipe.altar.RecipeChaosAltar;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.tile.TileSidedInventorySL;
import net.silentchaos512.lib.util.StackHelper;

public class TileChaosAltar
extends TileSidedInventorySL
implements ITickable,
IChaosAccepter {
    public static final int MAX_CHAOS_STORED = 10000000;
    public static final int MAX_RECEIVE = 100000;
    public static final int MAX_ITEM_SEND = 10000;
    public static final int TRANSMUTE_CHAOS_PER_TICK = 400;
    public static final int[] SLOTS_BOTTOM = new int[]{1};
    public static final int[] SLOTS_TOP = new int[]{0};
    public static final int[] SLOTS_SIDE = new int[]{0};
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int SLOT_CATALYST = 2;
    public static final int INVENTORY_SIZE = 3;
    @SyncVariable(name="Energy")
    protected int chaosStored;
    @SyncVariable(name="Progress")
    protected int transmuteProgress = 0;
    private int updateTimer = 100;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack inputStack = this.func_70301_a(0);
        if (StackHelper.isEmpty((ItemStack)inputStack)) {
            return;
        }
        ItemStack outputStack = this.func_70301_a(1);
        ItemStack catalystStack = this.func_70301_a(2);
        if (inputStack.func_77973_b() instanceof IChaosStorage) {
            IChaosStorage chaosStorage = (IChaosStorage)inputStack.func_77973_b();
            int amount = chaosStorage.receiveCharge(inputStack, Math.min(this.chaosStored, 10000), false);
            this.chaosStored -= amount;
            if (amount != 0) {
                this.sendUpdate();
                this.updateTimer = -199;
            }
            if (chaosStorage.getCharge(inputStack) >= chaosStorage.getMaxCharge(inputStack) && StackHelper.isEmpty((ItemStack)outputStack)) {
                this.func_70299_a(1, inputStack);
                this.func_70304_b(0);
            }
        } else {
            RecipeChaosAltar recipe = RecipeChaosAltar.getMatchingRecipe(inputStack, catalystStack);
            if (recipe != null) {
                boolean willFitInOutputSlot;
                int chaosDrained = Math.min(this.chaosStored, Math.min(400, recipe.getChaosCost() - this.transmuteProgress));
                this.chaosStored -= chaosDrained;
                this.transmuteProgress += chaosDrained;
                boolean bl = willFitInOutputSlot = StackHelper.isEmpty((ItemStack)outputStack) || outputStack.func_77969_a(recipe.getOutput()) && StackHelper.getCount((ItemStack)outputStack) + StackHelper.getCount((ItemStack)recipe.getOutput()) <= outputStack.func_77976_d();
                if (this.transmuteProgress >= recipe.getChaosCost() && willFitInOutputSlot) {
                    this.transmuteProgress = 0;
                    if (StackHelper.isEmpty((ItemStack)outputStack)) {
                        this.func_70299_a(1, recipe.getOutput());
                    } else {
                        StackHelper.grow((ItemStack)this.func_70301_a(1), (int)StackHelper.getCount((ItemStack)recipe.getOutput()));
                    }
                    this.func_70298_a(0, StackHelper.getCount((ItemStack)recipe.getInput()));
                }
                if (chaosDrained != 0) {
                    this.sendUpdate();
                }
            } else {
                this.transmuteProgress = 0;
            }
        }
        if (this.updateTimer % 200 == 0) {
            this.sendUpdate();
        }
        ++this.updateTimer;
    }

    public ItemStack getStackToRender() {
        ItemStack stack = this.func_70301_a(0);
        if (StackHelper.isValid((ItemStack)stack)) {
            return stack;
        }
        stack = this.func_70301_a(1);
        if (StackHelper.isValid((ItemStack)stack)) {
            return stack;
        }
        return StackHelper.empty();
    }

    public RecipeChaosAltar getActiveRecipe() {
        return RecipeChaosAltar.getMatchingRecipe(this.func_70301_a(0), this.func_70301_a(2));
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.chaosStored;
            }
            case 1: {
                return this.transmuteProgress;
            }
            case 2: {
                RecipeChaosAltar recipe = RecipeChaosAltar.getMatchingRecipe(this.func_70301_a(0), this.func_70301_a(2));
                return recipe == null ? -1 : RecipeChaosAltar.ALL_RECIPES.indexOf(recipe);
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 3;
    }

    public String func_70005_c_() {
        return "ChaosAltar";
    }

    @Override
    public int getCharge() {
        return this.chaosStored;
    }

    @Override
    public int getMaxCharge() {
        return 10000000;
    }

    @Override
    public int receiveCharge(int maxReceive, boolean simulate) {
        int received = Math.min(this.getMaxCharge() - this.getCharge(), maxReceive);
        if (!simulate) {
            this.chaosStored += received;
            if (received != 0) {
                this.sendUpdate();
            }
        }
        return received;
    }

    public int[] func_180463_a(EnumFacing side) {
        switch (side) {
            case DOWN: {
                return SLOTS_BOTTOM;
            }
            case UP: {
                return SLOTS_TOP;
            }
        }
        return SLOTS_SIDE;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return direction == EnumFacing.DOWN;
    }

    public int func_70302_i_() {
        return 3;
    }
}

