/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.lib.EnumToolType;
import net.silentchaos512.gems.lib.soul.EnumSoulElement;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.util.ItemHelper;

public class SoulSkill {
    public static final int SKILL_ACTIVATE_DELAY = 200;
    static Map<String, SoulSkill> SKILL_LIST = new LinkedHashMap<String, SoulSkill>();
    static final float STAT_BOOST_MULTI = 0.05f;
    public static SoulSkill DURABILITY_BOOST;
    public static SoulSkill HARVEST_SPEED_BOOST;
    public static SoulSkill MELEE_DAMAGE_BOOST;
    public static SoulSkill MAGIC_DAMAGE_BOOST;
    public static SoulSkill PROTECTION_BOOST;
    public static SoulSkill WARM;
    public static SoulSkill CHILL;
    public static SoulSkill TAG;
    public static SoulSkill HEAD_BONUS;
    public static SoulSkill CROP_GROWTH;
    public static SoulSkill MENDING;
    public static SoulSkill AQUATIC;
    public static SoulSkill AERIAL;
    public final String id;
    public final int maxLevel;
    public final int apCost;
    public final int medianXpLevel;
    public final double weightDiff;
    public final EnumSoulElement[] favoredElements;
    protected int activateDelay = 200;
    protected double favorWeightMulti = 1.0;
    protected EnumToolType favoredType = EnumToolType.NONE;
    protected boolean lockedToFavoredElements = false;
    static final int WARM_CHILL_ACT_COST = 10;

    public static void init() {
        DURABILITY_BOOST = new SoulSkill("durability_boost", 10, 0, 0, 0.0, EnumSoulElement.EARTH, EnumSoulElement.METAL);
        HARVEST_SPEED_BOOST = new SoulSkill("harvest_speed_boost", 10, 0, 0, 0.0, EnumSoulElement.WIND, EnumSoulElement.LIGHTNING).setFavorsType(EnumToolType.HARVEST);
        MELEE_DAMAGE_BOOST = new SoulSkill("melee_damage_boost", 10, 0, 0, 0.0, EnumSoulElement.FIRE, EnumSoulElement.VENOM).setFavorsType(EnumToolType.SWORD);
        MAGIC_DAMAGE_BOOST = new SoulSkill("magic_damage_boost", 10, 0, 0, 0.0, EnumSoulElement.WATER, EnumSoulElement.ICE).setFavorsType(EnumToolType.SWORD);
        PROTECTION_BOOST = new SoulSkill("protection_boost", 10, 0, 0, 0.0, EnumSoulElement.METAL).setFavorsType(EnumToolType.ARMOR);
        WARM = new SoulSkill("warm", 3, 40, 3, -6.0, EnumSoulElement.FIRE, EnumSoulElement.METAL).setFavorWeightMulti(0.5);
        CHILL = new SoulSkill("chill", 3, 40, 3, -6.0, EnumSoulElement.WATER, EnumSoulElement.ICE).setFavorWeightMulti(0.5);
        TAG = new SoulSkill("tag", 4, 1, 5, -4.0, EnumSoulElement.VENOM, EnumSoulElement.ALIEN).setFavorWeightMulti(0.75).setFavorsType(EnumToolType.BOW);
        HEAD_BONUS = new SoulSkill("head_bonus", 5, 0, 0, -5.0, EnumSoulElement.MONSTER, EnumSoulElement.ALIEN, EnumSoulElement.METAL).setFavorWeightMulti(0.75);
        CROP_GROWTH = new SoulSkill("crop_growth", 4, 5, 4, -6.0, EnumSoulElement.FLORA).setActivateDelay(300).setFavorWeightMulti(0.75).lockToFavoredElements();
        MENDING = new SoulSkill("mending", 5, 5, 11, -2.0, EnumSoulElement.FLORA, EnumSoulElement.ALIEN).setFavorWeightMulti(0.75);
        AQUATIC = new SoulSkill("aquatic", 5, 5, 9, -3.0, EnumSoulElement.WATER);
        AERIAL = new SoulSkill("aerial", 5, 5, 9, -3.0, EnumSoulElement.WIND);
    }

    public SoulSkill(String id, int maxLevel, int apCost, int medianXpLevel, double weightDiff, EnumSoulElement ... favoredElements) {
        this.id = id;
        this.maxLevel = maxLevel;
        this.apCost = apCost;
        this.medianXpLevel = medianXpLevel;
        this.weightDiff = weightDiff;
        this.favoredElements = favoredElements;
        this.activateDelay = 160 + SilentGems.random.nextInt(81);
        SKILL_LIST.put(id, this);
    }

    public boolean activate(ToolSoul soul, ItemStack tool, EntityPlayer player, int level) {
        if (!this.shouldActivateOnClient() && player.field_70170_p.field_72995_K) {
            return false;
        }
        if (soul.getActionPoints() < this.apCost) {
            return false;
        }
        Random random = SilentGems.random;
        if (this != WARM && this != CHILL) {
            if (this == CROP_GROWTH) {
                int startX = (int)player.field_70165_t - 6;
                int startY = (int)player.field_70163_u - 1;
                int startZ = (int)player.field_70161_v - 6;
                int endX = startX + 13;
                int endY = startY + 2;
                int endZ = startZ + 13;
                float chance = 0.1125f * (float)level;
                boolean ret = false;
                for (int y = startY; y <= endY; ++y) {
                    for (int x = startX; x <= endX; ++x) {
                        for (int z = startZ; z <= endZ; ++z) {
                            IGrowable growable;
                            BlockPos pos = new BlockPos(x, y, z);
                            IBlockState state = player.field_70170_p.func_180495_p(pos);
                            if (!(state.func_177230_c() instanceof BlockCrops) || !(random.nextFloat() < chance) || !(growable = (IGrowable)state.func_177230_c()).func_176473_a(player.field_70170_p, pos, state, player.field_70170_p.field_72995_K)) continue;
                            growable.func_176474_b(player.field_70170_p, random, pos, state);
                            player.field_70170_p.func_175718_b(2005, pos, 0);
                            ret = true;
                        }
                    }
                }
                return ret;
            }
            if (this == MENDING && soul.actionPoints > soul.getMaxActionPoints() / 2) {
                if (tool.func_77952_i() == 0) {
                    return false;
                }
                if (random.nextFloat() < 0.2f) {
                    int amount = 2 * (level + 1) + random.nextInt(4);
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187698_i, SoundCategory.BLOCKS, 0.5f, 2.0f + (float)(0.2 * random.nextGaussian()));
                    ItemHelper.attemptDamageItem((ItemStack)tool, (int)(-amount), (Random)random, (EntityPlayer)player);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean activateOnBlock(ToolSoul soul, ItemStack tool, EntityPlayer player, int level, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this == WARM && soul.actionPoints >= 10) {
            BlockPos blockpos = pos.func_177972_a(facing);
            if (world.func_175623_d(blockpos) && Blocks.field_150480_ab.func_176196_c(world, blockpos)) {
                if (world.field_72995_K) {
                    return true;
                }
                float chance = 0.25f + 0.125f * (float)(level - 1);
                if (SilentGems.random.nextFloat() < chance) {
                    ItemHelper.useItemAsPlayer((ItemStack)new ItemStack(Items.field_151033_d), (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ);
                    soul.addActionPoints(-10);
                }
                ToolHelper.attemptDamageTool(tool, 1, (EntityLivingBase)player);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, SilentGems.random.nextFloat() * 0.4f + 0.8f);
                return true;
            }
        } else if (this == CHILL && soul.actionPoints >= this.apCost / 2) {
            BlockPos blockpos = pos.func_177972_a(facing);
            if (world.func_180495_p(blockpos) == Blocks.field_150355_j.func_176223_P()) {
                if (world.field_72995_K) {
                    return true;
                }
                float chance = 0.25f + 0.125f * (float)(level - 1);
                if (SilentGems.random.nextFloat() < chance) {
                    world.func_175656_a(blockpos, Blocks.field_150432_aD.func_176223_P());
                    soul.addActionPoints(-10);
                }
                ToolHelper.attemptDamageTool(tool, 1, (EntityLivingBase)player);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 1.0f, SilentGems.random.nextFloat() * 0.4f + 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean onDamageEntity(ToolSoul soul, ItemStack tool, EntityPlayer player, int level, EntityLivingBase target) {
        if (soul.actionPoints < this.apCost) {
            return false;
        }
        boolean flag = false;
        if (this == TAG) {
            flag = true;
            int duration = 50 * (level + 1);
            target.func_70690_d(new PotionEffect(MobEffects.field_188423_x, duration, 0, true, false));
        }
        if (flag) {
            soul.addActionPoints(-this.apCost);
        }
        return flag;
    }

    public void applyToStats(ToolStats stats, int level) {
        if (this == DURABILITY_BOOST) {
            stats.durability *= 1.0f + this.getStatBoostMulti() * (float)level;
        } else if (this == HARVEST_SPEED_BOOST) {
            stats.harvestSpeed *= 1.0f + this.getStatBoostMulti() * (float)level;
        } else if (this == MELEE_DAMAGE_BOOST) {
            stats.meleeDamage *= 1.0f + this.getStatBoostMulti() * (float)level;
        } else if (this == MAGIC_DAMAGE_BOOST) {
            stats.magicDamage *= 1.0f + this.getStatBoostMulti() * (float)level;
        } else if (this == PROTECTION_BOOST) {
            stats.protection *= 1.0f + this.getStatBoostMulti() * (float)level;
        }
    }

    public float getStatBoostMulti() {
        if (this == PROTECTION_BOOST) {
            return 0.025f;
        }
        return 0.05f;
    }

    public String getLocalizedName(ItemStack tool, int level) {
        String strName = SilentGems.localizationHelper.getLocalizedString("skill", this.id + ".name", new Object[0]);
        if (this.maxLevel == 1 || level == 0) {
            return strName;
        }
        String strNum = level > 10 ? Integer.toString(level) : SilentGems.localizationHelper.getLocalizedString("enchantment.level." + level, new Object[0]);
        return strName + " " + strNum;
    }

    public boolean canLearn(ToolSoul soul, ItemStack tool) {
        if (this.lockedToFavoredElements) {
            boolean foundMatch = false;
            for (EnumSoulElement elem : this.favoredElements) {
                if (elem != soul.element1 && elem != soul.element2) continue;
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                return false;
            }
        }
        if (soul.skills.containsKey(this)) {
            int currentLevel = soul.skills.get(this);
            return currentLevel < this.maxLevel;
        }
        return true;
    }

    public int getActivateDelay() {
        return this.activateDelay;
    }

    public SoulSkill setActivateDelay(int value) {
        this.activateDelay = value;
        return this;
    }

    public SoulSkill lockToFavoredElements() {
        this.lockedToFavoredElements = true;
        return this;
    }

    public boolean isLockedToFavoredElements() {
        return this.lockedToFavoredElements;
    }

    public double getFavorWeightMulti() {
        return this.favorWeightMulti;
    }

    public SoulSkill setFavorWeightMulti(double value) {
        this.favorWeightMulti = value;
        return this;
    }

    public SoulSkill setFavorsType(EnumToolType type) {
        this.favoredType = type;
        return this;
    }

    public boolean sendChatMessageOnActivation() {
        return this != CROP_GROWTH && this != MENDING;
    }

    public boolean canActivateWhenUnequipped() {
        return this == MENDING;
    }

    public boolean shouldActivateOnClient() {
        return false;
    }

    @Nullable
    public static SoulSkill getById(String id) {
        return SKILL_LIST.get(id);
    }

    public static SoulSkill selectSkillToLearn(ToolSoul soul, ItemStack tool) {
        LinkedHashMap<SoulSkill, Double> candidates = new LinkedHashMap<SoulSkill, Double>();
        for (SoulSkill skill : SKILL_LIST.values()) {
            if (!skill.canLearn(soul, tool)) continue;
            boolean favorsElement = false;
            double weight = skill.favoredElements.length < 1 ? 20.0 : 7.0;
            for (EnumSoulElement elem : skill.favoredElements) {
                if (elem == soul.getPrimaryElement()) {
                    weight = 20.0;
                    favorsElement = true;
                    break;
                }
                if (elem != soul.getSecondaryElement()) continue;
                weight = 15.0;
                favorsElement = true;
                break;
            }
            if (skill.favoredType != EnumToolType.NONE) {
                EnumToolType toolType;
                EnumToolType enumToolType = tool.func_77973_b() instanceof ITool ? ((ITool)tool.func_77973_b()).getToolType() : (toolType = tool.func_77973_b() instanceof IArmor ? ((IArmor)tool.func_77973_b()).getToolType() : EnumToolType.NONE);
                if (toolType == skill.favoredType) {
                    weight += 5.0;
                }
            }
            if (skill.medianXpLevel > 0) {
                int diff = Math.abs(soul.level - skill.medianXpLevel);
                if (diff > 6) {
                    diff = 6;
                }
                weight -= 0.75 * (double)diff;
            }
            if (soul.skills.containsKey(skill)) {
                weight -= 2.5 * (double)soul.skills.get(skill).intValue();
            }
            weight += skill.weightDiff;
            if (favorsElement) {
                weight *= skill.favorWeightMulti;
            }
            if (weight < 1.0) {
                weight = 1.0;
            }
            candidates.put(skill, weight);
        }
        Random rand = new Random((long)(soul.getPrimaryElement().ordinal() + (soul.getSecondaryElement().ordinal() << 4) + (soul.getLevel() << 8)) + (ToolHelper.getUUID(tool).getLeastSignificantBits() << 16));
        SoulSkill selected = null;
        double bestValue = Double.MIN_VALUE;
        for (SoulSkill skill : candidates.keySet()) {
            double value = -Math.log((double)rand.nextFloat() / (Double)candidates.get(skill));
            SilentGems.logHelper.debug(new Object[]{skill.id, candidates.get(skill), value, bestValue});
            if (!(value > bestValue)) continue;
            bestValue = value;
            selected = skill;
        }
        return selected;
    }

    public static SoulSkill[] getSkillList() {
        ArrayList<SoulSkill> list = new ArrayList<SoulSkill>();
        for (SoulSkill skill : SKILL_LIST.values()) {
            list.add(skill);
        }
        return list.toArray(new SoulSkill[list.size()]);
    }
}

