/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.part;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.part.ToolPartMain;
import net.silentchaos512.gems.item.tool.ItemGemBow;
import net.silentchaos512.gems.item.tool.ItemGemShield;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IRegistryObject;

public class ToolPartFlint
extends ToolPartMain {
    public static final int COLOR = 0x424242;

    public ToolPartFlint() {
        super("silentgems:flint", new ItemStack(Items.field_151145_ak));
    }

    @Override
    public ModelResourceLocation getModel(ItemStack tool, ToolPartPosition pos, int frame) {
        String name = ((IRegistryObject)tool.func_77973_b()).getName();
        name = "silentgems:" + name + "/" + name;
        String mat = tool.func_77973_b() instanceof ItemGemBow ? "" : "flint";
        String frameNum = frame == 3 ? "_3" : "";
        switch (pos) {
            case HEAD: {
                name = name + mat + frameNum;
                break;
            }
            case ROD_DECO: {
                name = name + "_deco";
                break;
            }
            default: {
                return null;
            }
        }
        name = name.toLowerCase();
        return new ModelResourceLocation(name, "inventory");
    }

    @Override
    public int getColor(ItemStack toolOrArmor, IPartPosition position, int animationFrame) {
        Item item = toolOrArmor.func_77973_b();
        boolean isTextureUncolored = position == ToolPartPosition.ROD_DECO || item instanceof IArmor || item instanceof ItemGemBow || item instanceof ItemGemShield;
        return isTextureUncolored || ToolHelper.isBroken(toolOrArmor) ? 0x424242 : 0xFFFFFF;
    }

    @Override
    public int getDurability() {
        return 128;
    }

    @Override
    public float getHarvestSpeed() {
        return 5.0f;
    }

    @Override
    public int getHarvestLevel() {
        return 1;
    }

    @Override
    public float getMeleeDamage() {
        return 1.5f;
    }

    @Override
    public float getMagicDamage() {
        return 0.0f;
    }

    @Override
    public int getEnchantability() {
        return 8;
    }

    @Override
    public float getMeleeSpeed() {
        return 1.1f;
    }

    @Override
    public float getChargeSpeed() {
        return 0.5f;
    }

    @Override
    public float getProtection() {
        return 3.0f;
    }

    @Override
    public EnumMaterialTier getTier() {
        return EnumMaterialTier.MUNDANE;
    }
}

