/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.module;

import java.util.Calendar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ModuleHolidayCheer {
    public static final int CANDY_TRY_DELAY = 12000;
    public static final float CANDY_RATE = 0.125f;
    public static final int CANDY_MAX_QUANTITY = 3;
    public static final int MONTH = 11;
    public static final int DAY_MIN = 20;
    public static final int DAY_MAX = 27;
    public static ModuleHolidayCheer instance = new ModuleHolidayCheer();
    public Calendar today;
    private boolean rightDay = this.checkDateAgain();
    boolean moduleEnabled = true;
    boolean forcedOn = false;

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (this.isEnabled()) {
            this.greetPlayer(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (this.isEnabled() && event.player.field_70170_p.func_82737_E() % 12000L == 0L) {
            this.checkDateAgain();
            if (this.isRightDay() && !event.player.field_70170_p.field_72995_K) {
                this.tryGiveCandy(event.player);
            }
        }
    }

    public boolean isEnabled() {
        return this.moduleEnabled || this.forcedOn;
    }

    public boolean isRightDay() {
        return this.rightDay || this.forcedOn;
    }

    public boolean checkDateAgain() {
        this.today = Calendar.getInstance();
        int month = this.today.get(2);
        int day = this.today.get(5);
        this.rightDay = month == 11 && day >= 20 && day <= 27;
        return this.rightDay;
    }

    public void greetPlayer(EntityPlayer player) {
        this.checkDateAgain();
        if (this.isRightDay() && !player.field_70170_p.field_72995_K) {
            String str = "[%s] Happy Holidays! Have some candy.";
            str = String.format(str, "Silent's Gems");
            ChatHelper.sendMessage((EntityPlayer)player, (String)(TextFormatting.GREEN + str));
            ItemStack stack = StackHelper.safeCopy((ItemStack)ModItems.food.candyCane);
            PlayerHelper.giveItem((EntityPlayer)player, (ItemStack)stack);
        }
    }

    public void tryGiveCandy(EntityPlayer player) {
        if (SilentGems.random.nextFloat() <= 0.125f) {
            int count = SilentGems.random.nextInt(3);
            ItemStack stack = StackHelper.safeCopy((ItemStack)ModItems.food.candyCane);
            StackHelper.setCount((ItemStack)stack, (int)count);
            PlayerHelper.giveItem((EntityPlayer)player, (ItemStack)stack);
        }
    }

    public void loadConfig(Configuration c) {
        String cat = "main.misc" + "." + "holiday_cheer";
        c.setCategoryComment(cat, "Winter holiday event options.");
        this.moduleEnabled = c.getBoolean("Enabled", cat, true, "Players will occasionally receive candy during part of December");
        this.forcedOn = c.getBoolean("Forced On", cat, false, "'Tis the season, every day all day!");
    }
}

