/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.util.ToolHelper;

public class ToolData {
    public static final String NBT_ROOT_CONSTRUCTION = "SGConstruction";
    public static final String NBT_ROOT_PROPERTIES = "SGProperties";
    public static final String NBT_ROOT_TOOL_SOUL = "SGToolSoul";
    public static final String NBT_ROOT_STATISTICS = "SGStatistics";
    public static final String NBT_SETTINGS_SUPER_SKILL = "SuperSkillEnabled";
    public static final String NBT_PART_ROOT = "Part";
    public static final String NBT_PART_HEAD = "Head";
    public static final String NBT_PART_ROD = "Rod";
    public static final String NBT_PART_ROD_DECO = "RodDeco";
    public static final String NBT_PART_HEAD_TIP = "HeadTip";
    public static final String NBT_PROP_DURABILITY = "Durability";
    public static final String NBT_PROP_HARVEST_LEVEL = "HarvestLevel";
    public static final String NBT_PROP_HARVEST_SPEED = "HarvestSpeed";
    public static final String NBT_PROP_MELEE_DAMAGE = "MeleeDamage";
    public static final String NBT_PROP_MAGIC_DAMAGE = "MagicDamage";
    public static final String NBT_PROP_ENCHANTABILITY = "Enchantability";
    public static final String NBT_PROP_MELEE_SPEED = "MeleeSpeed";
    public static final String NBT_PROP_BLOCKING_POWER = "BlockingPower";
    public static final String NBT_STATS_ORIGINAL_OWNER = "OriginalOwner";
    public static final String NBT_STATS_BLOCKS_MINED = "BlocksMined";
    public static final String NBT_STATS_BLOCKS_PLACED = "BlocksPlaced";
    public static final String NBT_STATS_BLOCKS_TILLED = "BlocksTilled";
    public static final String NBT_STATS_HITS = "HitsLanded";
    public static final String NBT_STATS_KILL_COUNT = "KillCount";
    public static final String NBT_STATS_PATHS_MADE = "PathsMade";
    public static final String NBT_STATS_SHOTS_FIRED = "ShotsFired";
    public static final String NBT_STATS_SHOTS_LANDED = "ShotsLanded";
    public static final String NBT_STATS_THROWN = "ThrownCount";
    public static final String NBT_COMPAT_SG2 = "SG2_Tool";
    static Map<UUID, ToolData> MAP = new HashMap<UUID, ToolData>();
    public ToolPart partHead;
    public ToolPart partRod;
    public ToolPart partTip;
    public boolean isSG2Tool = false;
    public int maxDurability;
    public int harvestLevel;
    public float harvestSpeed;
    public float meleeDamage;
    public float magicDamage;
    public int enchantability;
    public float meleeSpeed;
    public float protection;
    public boolean superSkillEnabled = false;
    String originalOwner;
    public int blocksMined;
    public int blocksPlaced;
    public int blocksTilled;
    public int hitsLanded;
    public int killCount;
    public int pathsMade;
    public int shotsFired;
    public int shotsLanded;
    public int thrownCount;

    @Nullable
    public static ToolData get(ItemStack tool, boolean putIfNotInMap) {
        UUID uuid = ToolHelper.getUUID(tool);
        if (uuid == null) {
            return null;
        }
        ToolData data = MAP.get(uuid);
        if (data == null) {
            data = ToolData.readFromNBT(tool.func_77978_p());
            if (putIfNotInMap) {
                MAP.put(uuid, data);
            }
        }
        return data;
    }

    static ToolData readFromNBT(NBTTagCompound tags) {
        ToolData data = new ToolData();
        if (tags == null) {
            return data;
        }
        NBTTagCompound construction = ToolData.getRootTag(tags, NBT_ROOT_CONSTRUCTION);
        data.partHead = ToolData.getPart(construction, NBT_PART_HEAD);
        data.partRod = ToolData.getPart(construction, NBT_PART_ROD);
        data.partTip = ToolData.getPart(construction, NBT_PART_HEAD_TIP);
        NBTTagCompound props = ToolData.getRootTag(tags, NBT_ROOT_PROPERTIES);
        data.maxDurability = props.func_74762_e(NBT_PROP_DURABILITY);
        data.harvestLevel = props.func_74762_e(NBT_PROP_HARVEST_LEVEL);
        data.harvestSpeed = props.func_74760_g(NBT_PROP_HARVEST_SPEED);
        data.meleeDamage = props.func_74760_g(NBT_PROP_MELEE_DAMAGE);
        data.magicDamage = props.func_74760_g(NBT_PROP_MAGIC_DAMAGE);
        data.enchantability = props.func_74762_e(NBT_PROP_ENCHANTABILITY);
        data.meleeSpeed = props.func_74760_g(NBT_PROP_MELEE_SPEED);
        data.protection = props.func_74760_g(NBT_PROP_BLOCKING_POWER);
        data.superSkillEnabled = props.func_74767_n(NBT_SETTINGS_SUPER_SKILL);
        NBTTagCompound stats = ToolData.getRootTag(tags, NBT_ROOT_STATISTICS);
        data.originalOwner = stats.func_74779_i(NBT_STATS_ORIGINAL_OWNER);
        data.blocksMined = stats.func_74762_e(NBT_STATS_BLOCKS_MINED);
        data.blocksPlaced = stats.func_74762_e(NBT_STATS_BLOCKS_PLACED);
        data.blocksTilled = stats.func_74762_e(NBT_STATS_BLOCKS_TILLED);
        data.hitsLanded = stats.func_74762_e(NBT_STATS_HITS);
        data.killCount = stats.func_74762_e(NBT_STATS_KILL_COUNT);
        data.pathsMade = stats.func_74762_e(NBT_STATS_PATHS_MADE);
        data.shotsFired = stats.func_74762_e(NBT_STATS_SHOTS_FIRED);
        data.shotsLanded = stats.func_74762_e(NBT_STATS_SHOTS_LANDED);
        data.thrownCount = stats.func_74762_e(NBT_STATS_THROWN);
        return data;
    }

    static void writeToNBT(NBTTagCompound tags) {
    }

    static NBTTagCompound getRootTag(NBTTagCompound tags, String key) {
        if (key != null && !key.isEmpty()) {
            if (!tags.func_74764_b(key)) {
                tags.func_74782_a(key, (NBTBase)new NBTTagCompound());
            }
            return tags.func_74775_l(key);
        }
        return null;
    }

    public void setToolStats(ToolStats stats) {
        this.maxDurability = (int)stats.durability;
        this.harvestLevel = stats.harvestLevel;
        this.harvestSpeed = stats.harvestSpeed;
        this.meleeDamage = stats.meleeDamage;
        this.magicDamage = stats.magicDamage;
        this.meleeSpeed = stats.meleeSpeed;
        this.protection = stats.protection;
        this.enchantability = (int)stats.enchantability;
    }

    static ToolPart getPart(NBTTagCompound tags, String key) {
        return ToolPartRegistry.getPart(tags.func_74779_i(key).split("#")[0]);
    }

    @Nullable
    public ToolPart getPart(ToolPartPosition pos) {
        switch (pos) {
            case HEAD: {
                return this.partHead;
            }
            case ROD: {
                return this.partRod;
            }
            case TIP: {
                return this.partTip;
            }
        }
        SilentGems.logHelper.warning((Object)("ToolData#getPart: Unknown part position " + pos));
        return null;
    }

    public void setPart(ToolPart part, ToolPartPosition pos) {
        switch (pos) {
            case HEAD: {
                this.partHead = part;
                break;
            }
            case ROD: {
                this.partRod = part;
            }
            case TIP: {
                this.partTip = part;
            }
            default: {
                SilentGems.logHelper.warning((Object)("ToolData#setPart: Unknown part position " + pos));
            }
        }
    }

    public String getOriginalOwner() {
        return this.originalOwner;
    }

    public void setOriginalOwner(EntityPlayer player) {
        this.setOriginalOwner(player.func_70005_c_());
    }

    public void setOriginalOwner(String name) {
        if (this.originalOwner.isEmpty()) {
            if (name.equals("SilentChaos512")) {
                name = TextFormatting.RED + name;
            } else if (name.equals("M4thG33k")) {
                name = TextFormatting.GREEN + name;
            } else if (name.equals("ChaoticPlayz")) {
                name = TextFormatting.BLUE + name;
            } else if (name.equals("Guide Book")) {
                name = TextFormatting.AQUA + name;
            }
            this.originalOwner = name;
        }
    }
}

