/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib;

import net.minecraft.block.Block;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.block.BlockGem;
import net.silentchaos512.gems.block.BlockGemOre;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.lib.util.StackHelper;

public enum EnumGem implements IStringSerializable
{
    RUBY("Ruby", 768, 8.0f, 6.0f, 2.0f, 0.8f, 14, 10, 1.0f, 15080733),
    GARNET("Garnet", 512, 7.0f, 4.0f, 3.0f, 0.9f, 16, 12, 1.0f, 15093533),
    TOPAZ("Topaz", 512, 9.0f, 4.0f, 2.0f, 0.8f, 20, 12, 2.0f, 15102237),
    AMBER("Amber", 192, 5.0f, 2.0f, 4.0f, 1.1f, 12, 17, 4.0f, 15115037),
    HELIODOR("Heliodor", 384, 12.0f, 4.0f, 3.0f, 1.0f, 12, 10, 2.0f, 15123741),
    PERIDOT("Peridot", 384, 6.0f, 4.0f, 3.0f, 0.7f, 14, 14, 3.0f, 10741277),
    BERYL("Beryl", 512, 9.0f, 4.0f, 2.0f, 1.1f, 14, 16, 2.0f, 1959453),
    INDICOLITE("Indicolite", 512, 10.0f, 2.0f, 5.0f, 1.0f, 12, 12, 1.0f, 1959554),
    AQUAMARINE("Aquamarine", 384, 9.0f, 3.0f, 4.0f, 1.1f, 14, 12, 2.0f, 1959654),
    SAPPHIRE("Sapphire", 768, 8.0f, 4.0f, 4.0f, 0.8f, 16, 10, 1.0f, 1908198),
    IOLITE("Iolite", 512, 6.0f, 2.0f, 4.0f, 1.0f, 20, 11, 2.0f, 6299110),
    AMETHYST("Amethyst", 384, 7.0f, 3.0f, 4.0f, 0.9f, 18, 12, 3.0f, 10690022),
    AGATE("Agate", 256, 8.0f, 3.0f, 3.0f, 1.1f, 16, 14, 4.0f, 15080934),
    MORGANITE("Morganite", 384, 10.0f, 4.0f, 2.0f, 0.9f, 14, 12, 3.0f, 0xFF88FE),
    ONYX("Onyx", 192, 8.0f, 7.0f, 2.0f, 0.7f, 12, 8, 1.0f, 0x2F2F2F),
    OPAL("Opal", 256, 8.0f, 3.0f, 6.0f, 0.7f, 16, 13, 2.0f, 0xE4E4E4),
    CARNELIAN("Carnelian", 384, 9.0f, 2.0f, 3.0f, 0.9f, 14, 12, 2.0f, 10685952),
    SPINEL("Spinel", 768, 8.0f, 5.0f, 2.0f, 0.7f, 16, 11, 1.0f, 10699776),
    CITRINE("Citrine", 512, 10.0f, 4.0f, 2.0f, 1.0f, 14, 13, 2.0f, 10706688),
    JASPER("Jasper", 384, 7.0f, 3.0f, 3.0f, 0.9f, 18, 14, 2.0f, 10717184),
    GOLDEN_BERYL("GoldenBeryl", 512, 10.0f, 2.0f, 5.0f, 0.7f, 12, 10, 1.0f, 0xA3A300),
    MOLDAVITE("Moldavite", 256, 6.0f, 5.0f, 2.0f, 0.8f, 16, 11, 3.0f, 8954624),
    MALACHITE("Malachite", 256, 8.0f, 4.0f, 2.0f, 1.3f, 14, 14, 2.0f, 41782),
    TURQUOISE("Turquoise", 384, 9.0f, 3.0f, 3.0f, 0.8f, 14, 12, 1.0f, 41864),
    MOONSTONE("Moonstone", 384, 9.0f, 3.0f, 5.0f, 1.0f, 14, 15, 3.0f, 28067),
    BLUE_TOPAZ("BlueTopaz", 768, 9.0f, 3.0f, 3.0f, 0.7f, 16, 11, 1.0f, 7075),
    TANZANITE("Tanzanite", 512, 6.0f, 3.0f, 4.0f, 0.7f, 16, 13, 2.0f, 6226083),
    VIOLET_SAPPHIRE("VioletSapphire", 768, 8.0f, 4.0f, 3.0f, 0.9f, 16, 11, 1.0f, 9765027),
    LEPIDOLITE("Lepidolite", 192, 4.0f, 3.0f, 7.0f, 1.0f, 12, 13, 1.0f, 10682490),
    AMETRINE("Ametrine", 512, 8.0f, 4.0f, 2.0f, 0.7f, 12, 10, 4.0f, 10682450),
    BLACK_DIAMOND("BlackDiamond", 1024, 10.0f, 3.0f, 4.0f, 0.8f, 18, 9, 1.0f, 0x1E1E1E),
    ALEXANDRITE("Alexandrite", 768, 8.0f, 3.0f, 3.0f, 0.8f, 14, 10, 2.0f, 0x898989),
    PYROPE("Pyrope", 512, 8.0f, 6.0f, 2.0f, 1.0f, 16, 12, 1.0f, 16729460),
    CORAL("Coral", 256, 9.0f, 3.0f, 5.0f, 1.2f, 20, 18, 3.0f, 0xFF5545),
    SUNSTONE("Sunstone", 384, 7.0f, 5.0f, 5.0f, 0.9f, 16, 16, 2.0f, 16741445),
    CATS_EYE("CatsEye", 768, 9.0f, 3.0f, 4.0f, 1.1f, 18, 16, 1.0f, 16761157),
    ZIRCON("Zircon", 512, 8.0f, 4.0f, 3.0f, 1.3f, 14, 12, 2.0f, 0xFFFF45),
    JADE("Jade", 384, 6.0f, 4.0f, 4.0f, 1.0f, 16, 16, 4.0f, 10682181),
    CHRYSOPRASE("Chrysoprase", 512, 7.0f, 3.0f, 2.0f, 1.1f, 18, 14, 1.0f, 6618949),
    APATITE("Apatite", 256, 7.0f, 2.0f, 4.0f, 1.0f, 16, 15, 3.0f, 4587473),
    FLUORITE("Fluorite", 256, 6.0f, 2.0f, 5.0f, 0.9f, 14, 17, 4.0f, 4575743),
    KYANITE("Kyanite", 768, 12.0f, 4.0f, 6.0f, 1.2f, 16, 16, 2.0f, 4555775),
    SODALITE("Sodalite", 512, 8.0f, 3.0f, 3.0f, 1.1f, 18, 12, 2.0f, 0x5445FF),
    AMMOLITE("Ammolite", 256, 7.0f, 3.0f, 6.0f, 1.2f, 14, 18, 3.0f, 14697983),
    KUNZITE("Kunzite", 384, 6.0f, 5.0f, 4.0f, 0.8f, 20, 14, 1.0f, 16729568),
    ROSE_QUARTZ("RoseQuartz", 512, 8.0f, 4.0f, 3.0f, 1.0f, 16, 15, 2.0f, 16742582),
    TEKTITE("Tektite", 384, 8.0f, 4.0f, 3.0f, 1.0f, 18, 17, 1.0f, 9403499),
    PEARL("Pearl", 256, 7.0f, 3.0f, 4.0f, 1.2f, 14, 20, 3.0f, 14870769);

    public static final PropertyEnum VARIANT_GEM;
    public static final int REGULAR_HARVEST_LEVEL = 2;
    public static final int SUPER_HARVEST_LEVEL = 4;
    public static final int SUPER_DURABILITY_MULTI = 4;
    public static final float SUPER_MINING_SPEED_BOOST = 4.0f;
    public static final float SUPER_MELEE_DAMAGE_BOOST = 3.0f;
    public static final float SUPER_MAGIC_DAMAGE_BOOST = 3.0f;
    public static final int SUPER_ENCHANTABILITY_BOOST = 8;
    public static final float SUPER_MELEE_SPEED_BOOST = 0.2f;
    public static final float SUPER_CHARGE_SPEED_BOOST = 1.0f;
    public static final int SUPER_PROTECTION_BOOST = 4;
    protected static final String STR_SUPER = "Super";
    protected final String name;
    protected final int durability;
    protected final float miningSpeed;
    protected final float meleeDamage;
    protected final float magicDamage;
    protected final float meleeSpeed;
    protected final int enchantability;
    protected final int protection;
    protected final float chargeSpeed;
    protected final int color;

    private EnumGem(String name, int durability, float miningSpeed, float meleeDamage, float magicDamage, float meleeSpeed, int protection, int enchantability, float chargeSpeed, int color) {
        this.name = name;
        this.durability = durability;
        this.miningSpeed = miningSpeed;
        this.meleeDamage = meleeDamage;
        this.magicDamage = magicDamage;
        this.meleeSpeed = meleeSpeed;
        this.enchantability = enchantability;
        this.protection = protection;
        this.chargeSpeed = chargeSpeed;
        this.color = color;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public String getGemName() {
        return this.name;
    }

    public int getDurability(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.durability * 4 : this.durability;
    }

    public float getMiningSpeed(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.miningSpeed + 4.0f : this.miningSpeed;
    }

    public float getMeleeDamage(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.meleeDamage + 3.0f : this.meleeDamage;
    }

    public float getMagicDamage(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.magicDamage + 3.0f : this.magicDamage;
    }

    public int getEnchantability(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.enchantability + 8 : this.enchantability;
    }

    public float getMeleeSpeed(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.meleeSpeed + 0.2f : this.meleeSpeed;
    }

    public float getChargeSpeed(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.chargeSpeed + 1.0f : this.chargeSpeed;
    }

    public int getProtection(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? this.protection + 4 : this.protection;
    }

    public int getHarvestLevel(EnumMaterialTier tier) {
        return tier == EnumMaterialTier.SUPER ? 4 : 2;
    }

    public int getColor() {
        return this.color;
    }

    public static EnumGem getFromStack(ItemStack stack) {
        if (StackHelper.isEmpty((ItemStack)stack) || stack.func_77973_b() != ModItems.gem) {
            return null;
        }
        return EnumGem.values()[MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(EnumGem.values().length - 1))];
    }

    public static EnumGem getRandom() {
        return EnumGem.values()[SilentGems.random.nextInt(EnumGem.values().length)];
    }

    public ItemStack getBlock() {
        BlockGem block = this.getSet() == Set.LIGHT ? ModBlocks.gemBlockLight : (this.getSet() == Set.DARK ? ModBlocks.gemBlockDark : ModBlocks.gemBlock);
        return new ItemStack((Block)block, 1, this.ordinal() & 0xF);
    }

    public String getBlockOreName() {
        return "block" + this.name;
    }

    public ItemStack getBlockSuper() {
        BlockGem block = this.getSet() == Set.LIGHT ? ModBlocks.gemBlockSuperLight : (this.getSet() == Set.DARK ? ModBlocks.gemBlockSuperDark : ModBlocks.gemBlockSuper);
        return new ItemStack((Block)block, 1, this.ordinal() & 0xF);
    }

    public String getBlockSuperOreName() {
        return this.getBlockOreName() + STR_SUPER;
    }

    public ItemStack getOre() {
        BlockGemOre block = this.getSet() == Set.LIGHT ? ModBlocks.gemOreLight : (this.getSet() == Set.DARK ? ModBlocks.gemOreDark : ModBlocks.gemOre);
        return new ItemStack((Block)block, 1, this.ordinal() & 0xF);
    }

    public String getOreOreName() {
        return "ore" + this.name;
    }

    public ItemStack getItem() {
        return new ItemStack((Item)ModItems.gem, 1, this.ordinal());
    }

    public String getItemOreName() {
        return "gem" + this.name;
    }

    public ItemStack getItemSuper() {
        return new ItemStack((Item)ModItems.gemSuper, 1, this.ordinal());
    }

    public String getItemSuperOreName() {
        return this.getItemOreName() + STR_SUPER;
    }

    public ItemStack getShard() {
        return new ItemStack((Item)ModItems.gemShard, 1, this.ordinal());
    }

    public String getShardOreName() {
        return "nugget" + this.name;
    }

    public Set getSet() {
        if (this.ordinal() < 16) {
            return Set.CLASSIC;
        }
        if (this.ordinal() < 32) {
            return Set.DARK;
        }
        return Set.LIGHT;
    }

    static {
        VARIANT_GEM = PropertyEnum.func_177706_a((String)"gem", EnumGem.class, (Enum[])new EnumGem[]{RUBY, GARNET, TOPAZ, AMBER, HELIODOR, PERIDOT, BERYL, INDICOLITE, AQUAMARINE, SAPPHIRE, IOLITE, AMETHYST, AGATE, MORGANITE, ONYX, OPAL});
    }

    public static enum Set {
        CLASSIC(0),
        DARK(16),
        LIGHT(32);

        public final int startMeta;

        private Set(int startMeta) {
            this.startMeta = startMeta;
        }
    }
}

