/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.silentchaos512.gems.api.IAmmoTool;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.entity.EntityThrownTomahawk;
import net.silentchaos512.gems.item.tool.ItemGemAxe;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemTomahawk
extends ItemGemAxe
implements IAmmoTool {
    public static final String NBT_AMMO = "SG.Ammo";

    public ItemGemTomahawk() {
        this.func_77655_b("silentgems:Tomahawk");
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.tomahawk;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return StackHelper.empty();
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    public float getThrownDamage(ItemStack tomahawk) {
        int sharpness = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)tomahawk);
        float modifier = sharpness > 0 ? 1.0f + (float)Math.max(0, sharpness - 1) / 2.0f : 0.0f;
        return 6.0f + modifier + ToolHelper.getMeleeDamage(tomahawk);
    }

    @Override
    public float getMeleeDamage(ItemStack tool) {
        return (this.getMeleeDamageModifier() + ToolHelper.getMeleeDamage(tool)) / 2.0f;
    }

    @Override
    public float getMeleeDamageModifier() {
        return 1.0f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 1.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return -1.8f;
    }

    @Override
    public int getAmmo(ItemStack tool) {
        if (StackHelper.isValid((ItemStack)tool) && tool.func_77942_o()) {
            if (!tool.func_77978_p().func_74764_b(NBT_AMMO)) {
                tool.func_77978_p().func_74774_a(NBT_AMMO, (byte)this.getMaxAmmo(tool));
            }
            return tool.func_77978_p().func_74771_c(NBT_AMMO);
        }
        return 0;
    }

    @Override
    public int getMaxAmmo(ItemStack tool) {
        return GemsConfig.TOMAHAWK_MAX_AMMO;
    }

    @Override
    public void addAmmo(ItemStack tool, int amount) {
        if (StackHelper.isValid((ItemStack)tool) && tool.func_77942_o()) {
            int current = this.getAmmo(tool);
            int newAmount = Math.min(current + amount, this.getMaxAmmo(tool));
            tool.func_77978_p().func_74774_a(NBT_AMMO, (byte)newAmount);
        }
    }

    @Override
    public boolean isDiggingTool() {
        return false;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState state) {
        float digSpeed = ToolHelper.getDigSpeed(stack, state, EXTRA_EFFECTIVE_MATERIALS);
        if (state.func_185904_a() == Material.field_151575_d || state.func_185904_a() == Material.field_151572_C || state.func_185904_a() == Material.field_151594_q) {
            return digSpeed / 2.5f;
        }
        return digSpeed;
    }

    @Override
    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems(item, 4));
    }

    @Override
    public void addRecipes(RecipeMaker recipes) {
        if (!this.getConfig().isDisabled) {
            ToolHelper.addExampleRecipe((Item)this, "hhh", "hr ", " r ");
        }
    }

    @Override
    public String getName() {
        return "Tomahawk";
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!ToolHelper.isBroken(stack) && (this.getAmmo(stack) > 0 || player.field_71075_bZ.field_75098_d)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            boolean hasAmmo = player.field_71075_bZ.field_75098_d || this.getAmmo(stack) > 0;
            int useDuration = this.func_77626_a(stack) - timeLeft;
            if (useDuration < 4 || !hasAmmo) {
                return;
            }
            float speed = MathHelper.func_76131_a((float)(1.5f * (float)useDuration / 12.0f), (float)0.1f, (float)1.7f);
            EntityThrownTomahawk projectile = new EntityThrownTomahawk((EntityLivingBase)player, stack, speed);
            projectile.func_70107_b(player.field_70165_t, player.field_70163_u + 1.6, player.field_70161_v);
            worldIn.func_72838_d((Entity)projectile);
            if (!player.field_71075_bZ.field_75098_d) {
                ToolHelper.attemptDamageTool(stack, 3, (EntityLivingBase)player);
                this.addAmmo(stack, -1);
            }
            ToolHelper.incrementStatThrownCount(stack, 1);
        }
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return EnumActionResult.PASS;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @Override
    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        return this.func_77659_a(world, player, hand);
    }
}

