/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemShield
extends ItemShield
implements IRegistryObject,
ITool {
    public ItemGemShield() {
        this.setNoRepair();
    }

    public boolean shouldBlockDamage(EntityLivingBase entityLiving) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        if (!player.func_184585_cz() || player.func_184607_cu().func_77973_b() != this) {
            return false;
        }
        return !ToolHelper.isBroken(player.func_184607_cu());
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return ToolHelper.getAttributeModifiers(slot, stack);
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.shield;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return StackHelper.empty();
        }
        if (materials.length == 1) {
            return this.constructTool(rod, materials[0], materials[0], materials[0]);
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeDamage(ItemStack tool) {
        return Math.max(0.0f, (this.getMeleeDamageModifier() + ToolHelper.getMeleeDamage(tool)) / 2.0f);
    }

    @Override
    public float getMagicDamage(ItemStack tool) {
        return 0.0f;
    }

    @Override
    public float getMeleeDamageModifier() {
        return -4.0f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 0.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return -3.2f;
    }

    public void addRecipes(RecipeMaker recipes) {
        if (this.getConfig().isDisabled) {
            return;
        }
        String[] lines = new String[]{"hwh", "wrw", " h "};
        ToolHelper.addExampleRecipe((Item)this, EnumMaterialTier.values(), lines, Character.valueOf('w'), "plankWood");
    }

    public void addOreDict() {
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return ToolHelper.isBroken(stack) ? EnumAction.NONE : EnumAction.BLOCK;
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getMaxDamage(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ToolRenderHelper.instance.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ToolRenderHelper.instance.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ToolRenderHelper.instance.func_77613_e(stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return ToolHelper.getItemEnchantability(stack);
    }

    public void func_77663_a(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(tool, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return ToolHelper.onEntityItemUpdate(entityItem);
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }

    public String getName() {
        return "Shield";
    }

    public String getFullName() {
        return this.getModId() + ":" + this.getName();
    }

    public String getModId() {
        return "silentgems";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        models.put(0, new ModelResourceLocation(this.getFullName().toLowerCase(), "inventory"));
    }

    public boolean registerModels() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        ToolRenderHelper.getInstance().clAddInformation(stack, player.field_70170_p, list, advanced);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        ToolRenderHelper.getInstance().clAddInformation(stack, world, list, flag == ITooltipFlag.TooltipFlags.ADVANCED);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        this.clGetSubItems(item, tab, list);
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems(item, tab, (List<ItemStack>)list);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems((Item)this, tab, (List<ItemStack>)list);
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems(item, 3));
    }
}

