/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.config.ConfigOptionToolClass;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.handler.PlayerDataHandler;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ToolRenderHelper;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.skills.SkillAreaTill;
import net.silentchaos512.gems.skills.ToolSkill;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.registry.IRegistryObject;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemGemHoe
extends ItemHoe
implements IRegistryObject,
ITool {
    public ItemGemHoe() {
        super(ToolHelper.FAKE_MATERIAL);
        this.func_77655_b("silentgems:Hoe");
        this.setNoRepair();
    }

    public ItemStack constructTool(boolean supercharged, ItemStack material) {
        return this.constructTool(supercharged, material, material, material);
    }

    public ItemStack constructTool(boolean supercharged, ItemStack ... materials) {
        ItemStack rod = supercharged ? ModItems.craftingMaterial.toolRodGold : new ItemStack(Items.field_151055_y);
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (ToolHelper.isBroken(stack)) {
            return EnumActionResult.PASS;
        }
        int tilledCount = 0;
        EnumActionResult result = super.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
        if (result == EnumActionResult.SUCCESS) {
            ++tilledCount;
        } else {
            return EnumActionResult.FAIL;
        }
        ToolSkill skill = ToolHelper.getSuperSkill(stack);
        boolean skillEnabled = skill instanceof SkillAreaTill && ToolHelper.isSpecialAbilityEnabled(stack);
        int skillCost = skill != null ? skill.getCost(stack, player, pos) : 0;
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(player);
        if (tilledCount > 0 && skillEnabled && data.getCurrentChaos() >= skillCost) {
            EnumFacing playerFacing = player.func_174811_aO();
            int yOffset = 0;
            for (int i = 0; i < 8; ++i) {
                BlockPos blockpos = pos.func_177967_a(playerFacing, i + 1).func_177981_b(yOffset);
                if (super.func_180614_a(player, world, blockpos, hand, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
                    ++tilledCount;
                    continue;
                }
                if (super.func_180614_a(player, world, blockpos.func_177981_b(1), hand, side, hitX, hitY, hitZ) == EnumActionResult.SUCCESS) {
                    ++tilledCount;
                    ++yOffset;
                    continue;
                }
                if (super.func_180614_a(player, world, blockpos.func_177979_c(1), hand, side, hitX, hitY, hitZ) != EnumActionResult.SUCCESS) break;
                ++tilledCount;
                --yOffset;
            }
            if (tilledCount > 1 && data != null) {
                data.drainChaos(skillCost);
            }
        }
        if (tilledCount > 0) {
            world.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                ToolSoul soul = SoulManager.getSoul(stack);
                if (soul != null) {
                    soul.addXp((int)(4.0f * (float)tilledCount), stack, player);
                }
                ToolHelper.incrementStatBlocksTilled(stack, tilledCount);
                ToolHelper.attemptDamageTool(stack, tilledCount, (EntityLivingBase)player);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected void func_185071_a(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
        }
    }

    @Override
    public ConfigOptionToolClass getConfig() {
        return GemsConfig.hoe;
    }

    @Override
    public ItemStack constructTool(ItemStack rod, ItemStack ... materials) {
        if (this.getConfig().isDisabled) {
            return StackHelper.empty();
        }
        return ToolHelper.constructTool((Item)this, rod, materials);
    }

    @Override
    public float getMeleeDamageModifier() {
        return -4.0f;
    }

    @Override
    public float getMagicDamageModifier() {
        return 0.0f;
    }

    @Override
    public float getMeleeSpeedModifier() {
        return 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        boolean canceled = super.onBlockStartBreak(stack, pos, player);
        if (!canceled) {
            ToolHelper.onBlockStartBreak(stack, pos, player);
        }
        return canceled;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        return ToolHelper.getAttributeModifiers(slot, stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return ToolHelper.getMaxDamage(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return ToolRenderHelper.instance.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ToolRenderHelper.instance.func_77636_d(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ToolRenderHelper.instance.func_77613_e(stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return ToolHelper.getItemEnchantability(stack);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase entity1, EntityLivingBase entity2) {
        return ToolHelper.hitEntity(stack, entity1, entity2);
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return ToolHelper.getIsRepairable(stack1, stack2);
    }

    public void func_77663_a(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        ToolHelper.onUpdate(tool, world, entity, itemSlot, isSelected);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return ToolHelper.onEntityItemUpdate(entityItem);
    }

    public void addRecipes(RecipeMaker recipes) {
        if (!this.getConfig().isDisabled) {
            ToolHelper.addExampleRecipe((Item)this, "hh", " r", " r");
        }
    }

    public void addOreDict() {
    }

    public String getName() {
        return "Hoe";
    }

    public String getFullName() {
        return this.getModId() + ":" + this.getName();
    }

    public String getModId() {
        return "silentgems";
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        models.put(0, ToolRenderHelper.SMART_MODEL);
    }

    public boolean registerModels() {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        ToolRenderHelper.getInstance().clAddInformation(stack, player.field_70170_p, list, advanced);
    }

    public void func_77624_a(ItemStack stack, World world, List list, ITooltipFlag flag) {
        ToolRenderHelper.getInstance().clAddInformation(stack, world, list, flag == ITooltipFlag.TooltipFlags.ADVANCED);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        this.clGetSubItems(item, tab, list);
    }

    public void func_150895_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems(item, tab, (List<ItemStack>)list);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        this.clGetSubItems((Item)this, tab, (List<ItemStack>)list);
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        list.addAll(ToolHelper.getSubItems(item, 2));
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.func_180614_a(player, world, pos, hand, side, hitX, hitY, hitZ);
    }
}

