/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.lib.soul.SoulSkill;
import net.silentchaos512.gems.lib.soul.ToolSoul;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.gems.util.ToolHelper;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.StackHelper;

public class ItemSkillOrb
extends ItemSL {
    public static final String NBT_ID = "SG_Skill_ID";

    public ItemSkillOrb() {
        super(1, "silentgems", "SkillOrb");
    }

    public ItemStack getStack(SoulSkill skill) {
        ItemStack stack = new ItemStack((Item)this);
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74778_a(NBT_ID, skill.id);
        stack.func_77982_d(tags);
        return stack;
    }

    public SoulSkill getSkill(ItemStack stack) {
        if (StackHelper.isEmpty((ItemStack)stack) || !stack.func_77942_o()) {
            return null;
        }
        return SoulSkill.getById(stack.func_77978_p().func_74779_i(NBT_ID));
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        for (SoulSkill skill : SoulSkill.getSkillList()) {
            list.add(this.getStack(skill));
        }
    }

    public String func_77653_i(ItemStack stack) {
        LocalizationHelper loc = SilentGems.localizationHelper;
        SoulSkill skill = this.getSkill(stack);
        if (skill == null) {
            return this.func_77667_c(stack);
        }
        return loc.getItemSubText("SkillOrb", "name_proper", new Object[]{skill.getLocalizedName(StackHelper.empty(), 0)});
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack offhand = player.func_184592_cb();
        if (hand != EnumHand.MAIN_HAND || StackHelper.isEmpty((ItemStack)offhand) || !(offhand.func_77973_b() instanceof ITool) && !(offhand.func_77973_b() instanceof IArmor)) {
            return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        ItemStack orb = player.func_184614_ca();
        ToolSoul soul = SoulManager.getSoul(offhand);
        if (soul == null) {
            if (!world.field_72995_K) {
                ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.localizationHelper.getItemSubText("SkillOrb", "no_soul", new Object[0]));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)orb);
        }
        SoulSkill skill = this.getSkill(orb);
        if (skill == null) {
            if (!world.field_72995_K) {
                ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.localizationHelper.getItemSubText("SkillOrb", "no_skill", new Object[0]));
            }
            return new ActionResult(EnumActionResult.PASS, (Object)orb);
        }
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (soul.addOrLevelSkill(skill, offhand, player)) {
            ToolHelper.recalculateStats(offhand);
            StackHelper.shrink((ItemStack)orb, (int)1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)orb);
        }
        ChatHelper.sendMessage((EntityPlayer)player, (String)SilentGems.localizationHelper.getItemSubText("SkillOrb", "max_level", new Object[0]));
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }
}

