/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.silentchaos512.gems.api.energy.IChaosStorage;
import net.silentchaos512.gems.util.NBTHelper;
import net.silentchaos512.lib.item.ItemSL;

public class ItemChaosStorage
extends ItemSL
implements IChaosStorage {
    public static final String NBT_CHARGE = "ChaosCharge";
    protected int maxCharge;

    public ItemChaosStorage(int subItemCount, String name, int maxCharge) {
        super(subItemCount, "silentgems", name);
        this.func_77625_d(1);
        this.setNoRepair();
        this.maxCharge = maxCharge;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int energy = this.getCharge(stack);
        int capacity = this.getMaxCharge(stack);
        if (capacity == 0) {
            return 1.0;
        }
        return (double)(capacity - energy) / (double)capacity;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        int charge = this.getCharge(stack);
        int max = this.getMaxCharge(stack);
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)charge / (float)max) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCharge(stack) < this.getMaxCharge(stack);
    }

    protected void setCharge(ItemStack stack, int value) {
        NBTHelper.setTagInt(stack, NBT_CHARGE, value);
    }

    @Override
    public int getCharge(ItemStack stack) {
        return NBTHelper.getTagInt(stack, NBT_CHARGE);
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public int receiveCharge(ItemStack stack, int maxReceive, boolean simulate) {
        int charge = this.getCharge(stack);
        int capacity = this.getMaxCharge(stack);
        int received = Math.min(capacity - charge, maxReceive);
        if (!simulate) {
            NBTHelper.setTagInt(stack, NBT_CHARGE, charge + received);
        }
        return received;
    }

    @Override
    public int extractCharge(ItemStack stack, int maxExtract, boolean simulate) {
        int charge = this.getCharge(stack);
        int capacity = this.getMaxCharge(stack);
        int extracted = Math.min(charge, maxExtract);
        if (!simulate) {
            NBTHelper.setTagInt(stack, NBT_CHARGE, charge - extracted);
        }
        return extracted;
    }
}

