/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemChaosOrb;
import net.silentchaos512.gems.lib.ChaosBuff;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;

public class ItemChaosRune
extends ItemSL {
    public static final String NBT_BUFF = "chaos_buff";

    public ItemChaosRune() {
        super(1, "silentgems", "ChaosRune");
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        ChaosBuff buff = this.getBuff(stack);
        if (buff != null) {
            LocalizationHelper loc = SilentGems.localizationHelper;
            TextFormatting nameColor = buff.getPotion() != null && buff.getPotion().func_76398_f() ? TextFormatting.RED : TextFormatting.GOLD;
            list.add(nameColor + buff.getLocalizedName(1));
            String desc = "  " + buff.getDescription();
            if (!desc.isEmpty()) {
                list.add(TextFormatting.DARK_GRAY + desc);
            }
            list.add("  " + loc.getItemSubText(this.itemName, "maxLevel", new Object[]{buff.getMaxLevel()}));
            list.add("  " + loc.getItemSubText(this.itemName, "slotsUsed", new Object[]{buff.getSlotsUsed(1)}));
            String varCost = buff.hasVariableCost() ? loc.getItemSubText(this.itemName, "variableCost", new Object[0]) : "";
            list.add("  " + loc.getItemSubText(this.itemName, "chaosCost", new Object[]{buff.getChaosCost(1, null), varCost}));
            if (KeyTracker.isAltDown()) {
                list.add(TextFormatting.DARK_GRAY + String.format("Key: %s", buff.getKey()));
                list.add(TextFormatting.DARK_GRAY + String.format("Potion: %s", buff.getPotion()));
                list.add(TextFormatting.DARK_GRAY + String.format("Color: %X", buff.getColor()));
            }
        }
    }

    public void addRecipes(RecipeMaker recipes) {
        this.addRecipe(ChaosBuff.CAPACITY, new ItemStack((Item)ModItems.chaosOrb, 1, ItemChaosOrb.Type.FRAGILE.ordinal()), 1);
        this.addRecipe(ChaosBuff.RECHARGE, ModItems.craftingMaterial.chaosCore, 1);
        this.addRecipe(ChaosBuff.FLIGHT, ModItems.craftingMaterial.shinyPlume, 3);
        this.addRecipe(ChaosBuff.SPEED, Items.field_151102_aT, 3);
        this.addRecipe(ChaosBuff.HASTE, "dustGlowstone", 3);
        this.addRecipe(ChaosBuff.JUMP_BOOST, ModItems.craftingMaterial.plume, 2);
        this.addRecipe(ChaosBuff.STRENGTH, ModItems.craftingMaterial.blazestone, 3);
        this.addRecipe(ChaosBuff.REGENERATION, Items.field_151073_bk, 3);
        this.addRecipe(ChaosBuff.RESISTANCE, "blockIron", 1);
        this.addRecipe(ChaosBuff.FIRE_RESISTANCE, Items.field_151064_bs, 3);
        this.addRecipe(ChaosBuff.WATER_BREATHING, "blockLapis", 2);
        this.addRecipe(ChaosBuff.NIGHT_VISION, Items.field_151150_bK, 2);
        this.addRecipe(ChaosBuff.INVISIBILITY, Items.field_151071_bq, 3);
        this.addRecipe(ChaosBuff.LEVITATION, Items.field_151061_bv, 2);
        this.addRecipe(ChaosBuff.GLOWING, "torch", 3);
        this.addRecipe(ChaosBuff.SLOWNESS, "dirt", 3);
        this.addRecipe(ChaosBuff.MINING_FATIGUE, Blocks.field_150348_b, 3);
        this.addRecipe(ChaosBuff.NAUSEA, "bone", 3);
        this.addRecipe(ChaosBuff.BLINDNESS, "string", 3);
        this.addRecipe(ChaosBuff.HUNGER, Items.field_151078_bh, 3);
        this.addRecipe(ChaosBuff.WEAKNESS, "feather", 3);
        this.addRecipe(ChaosBuff.POISON, Items.field_151070_bp, 2);
        this.addRecipe(ChaosBuff.WITHER, new ItemStack(Items.field_151144_bL, 1, 1), 1);
        if (Loader.isModLoaded((String)"toughasnails")) {
            this.addRecipe(ChaosBuff.COLD_RESISTANCE, new ItemStack(Item.func_111206_d((String)"toughasnails:ice_charge")), 3);
            this.addRecipe(ChaosBuff.HEAT_RESISTANCE, new ItemStack(Items.field_151059_bz), 3);
            this.addRecipe(ChaosBuff.THIRST, new ItemStack(Item.func_111206_d((String)"toughasnails:water_bottle")), 3);
        }
    }

    private void addRecipe(ChaosBuff buff, Object obj, int count) {
        ItemStack result = new ItemStack((Item)this);
        String line1 = count > 1 ? "coc" : "c c";
        String line2 = count != 2 ? "ror" : "r r";
        String line3 = line1;
        this.setBuff(result, buff);
        String name = "chaos_rune_" + buff.getKey().replaceFirst("silentgems:", "").replaceAll(":", "_");
        SilentGems.registry.recipes.addShapedOre(name, result, new Object[]{line1, line2, line3, Character.valueOf('r'), "dustRedstone", Character.valueOf('c'), ModItems.craftingMaterial.chaosEssenceEnriched, Character.valueOf('o'), obj});
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        for (ChaosBuff buff : ChaosBuff.getAllBuffs()) {
            list.add(this.setBuff(new ItemStack((Item)this), buff));
        }
    }

    public ChaosBuff getBuff(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        return ChaosBuff.byKey(stack.func_77978_p().func_74779_i(NBT_BUFF));
    }

    public ItemStack setBuff(@Nonnull ItemStack stack, ChaosBuff buff) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a(NBT_BUFF, buff.getKey());
        return stack;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

