/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.compat.BaublesCompat;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModItems;
import net.silentchaos512.gems.item.ItemChaosStorage;
import net.silentchaos512.gems.lib.ChaosBuff;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.client.render.BufferBuilderSL;
import net.silentchaos512.lib.collection.ItemStackList;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.lib.util.StackHelper;
import org.lwjgl.opengl.GL11;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="baubles"), @Optional.Interface(iface="baubles.api.render.IRenderBauble", modid="baubles")})
public class ItemChaosGem
extends ItemChaosStorage
implements IBauble,
IRenderBauble {
    public static final String NBT_ENABLED = "enabled";
    public static final String NBT_BUFF_LIST = "buff_list";
    public static final String NBT_BUFF_KEY = "key";
    public static final String NBT_BUFF_LEVEL = "level";
    public static final int ID_CHEATY_GEM = EnumGem.values().length;
    public static final int BASE_CAPACITY = 2000000;
    public static final int UPGRADE_CAPACITY = 1000000;
    public static final int SELF_RECHARGE_BASE = 10;
    public static final int MAX_SLOTS = 20;

    public ItemChaosGem() {
        super(EnumGem.values().length + 1, "ChaosGem", 2000000);
        this.func_77625_d(1);
    }

    public void addRecipes(RecipeMaker recipes) {
        for (EnumGem gem : EnumGem.values()) {
            recipes.addSurroundOre("chaos_gem_" + gem.name(), new ItemStack((Item)this, 1, gem.ordinal()), (Object)gem.getBlockOreName(), new Object[]{ModItems.craftingMaterial.chaosEssenceEnriched});
        }
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        if (stack.func_77952_i() == ID_CHEATY_GEM) {
            return 0;
        }
        int capacityLevel = this.getBuffLevel(stack, ChaosBuff.CAPACITY);
        return 2000000 + 1000000 * capacityLevel;
    }

    public int getTotalChargeDrain(ItemStack stack, EntityPlayer player) {
        int total = 0;
        for (Map.Entry<ChaosBuff, Integer> entry : this.getBuffs(stack).entrySet()) {
            total += entry.getKey().getChaosCost(entry.getValue(), player);
        }
        return total;
    }

    public int getSelfRechargeAmount(ItemStack stack) {
        int rechargeLevel = this.getBuffLevel(stack, ChaosBuff.RECHARGE);
        return 10 * rechargeLevel;
    }

    public int getSlotsUsed(ItemStack stack) {
        return this.getSlotsUsed(this.getBuffs(stack));
    }

    public int getSlotsUsed(Map<ChaosBuff, Integer> buffMap) {
        int slotsUsed = 0;
        for (Map.Entry<ChaosBuff, Integer> entry : buffMap.entrySet()) {
            slotsUsed += entry.getKey().getSlotsUsed(entry.getValue());
        }
        return slotsUsed;
    }

    public boolean isEnabled(ItemStack stack) {
        return StackHelper.isValid((ItemStack)stack) && stack.func_77942_o() && stack.func_77978_p().func_74767_n(NBT_ENABLED);
    }

    public void setEnabled(ItemStack stack, boolean val) {
        if (StackHelper.isEmpty((ItemStack)stack)) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (this.getCharge(stack) <= 0) {
            val = false;
        }
        stack.func_77978_p().func_74757_a(NBT_ENABLED, val);
    }

    public int getBuffLevel(ItemStack stack, ChaosBuff buff) {
        Map<ChaosBuff, Integer> buffMap = this.getBuffs(stack);
        if (buffMap.containsKey(buff)) {
            return buffMap.get(buff);
        }
        return 0;
    }

    public Map<ChaosBuff, Integer> getBuffs(ItemStack stack) {
        if (StackHelper.isEmpty((ItemStack)stack) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b(NBT_BUFF_LIST)) {
            return Maps.newHashMap();
        }
        NBTTagList tagList = stack.func_77978_p().func_150295_c(NBT_BUFF_LIST, 10);
        LinkedHashMap map = Maps.newLinkedHashMap();
        if (tagList != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                String key = tagList.func_150305_b(i).func_74779_i(NBT_BUFF_KEY);
                short level = tagList.func_150305_b(i).func_74765_d(NBT_BUFF_LEVEL);
                map.put(ChaosBuff.byKey(key), Integer.valueOf(level));
            }
        }
        return map;
    }

    public boolean addBuff(ItemStack stack, ChaosBuff buff) {
        if (this.canAddBuff(stack, buff)) {
            Map<ChaosBuff, Integer> buffMap = this.getBuffs(stack);
            int currentLevel = 0;
            if (buffMap.containsKey(buff)) {
                currentLevel = buffMap.get(buff);
            }
            buffMap.put(buff, currentLevel + 1);
            this.setBuffs(stack, buffMap);
            return true;
        }
        return false;
    }

    public void setBuffs(ItemStack stack, Map<ChaosBuff, Integer> buffs) {
        if (StackHelper.isEmpty((ItemStack)stack)) {
            return;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b(NBT_BUFF_LIST)) {
            stack.func_77978_p().func_82580_o(NBT_BUFF_LIST);
        }
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<ChaosBuff, Integer> entry : buffs.entrySet()) {
            ChaosBuff buff = entry.getKey();
            int level = entry.getValue();
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a(NBT_BUFF_KEY, buff.getKey());
            compound.func_74777_a(NBT_BUFF_LEVEL, (short)level);
            tagList.func_74742_a((NBTBase)compound);
        }
        stack.func_77978_p().func_74782_a(NBT_BUFF_LIST, (NBTBase)tagList);
    }

    public boolean canAddBuff(ItemStack stack, ChaosBuff buff) {
        if (StackHelper.isEmpty((ItemStack)stack)) {
            return false;
        }
        if (!stack.func_77942_o()) {
            return true;
        }
        Map<ChaosBuff, Integer> buffMap = this.getBuffs(stack);
        if (buffMap.containsKey(buff)) {
            int currentLevel = buffMap.get(buff);
            if (currentLevel >= buff.getMaxLevel()) {
                return false;
            }
            buffMap.put(buff, currentLevel + 1);
        } else {
            buffMap.put(buff, 1);
        }
        return this.getSlotsUsed(buffMap) <= 20;
    }

    public boolean isCheatyGem(ItemStack stack) {
        return stack.func_77952_i() == 32;
    }

    public void applyEffects(ItemStack stack, EntityPlayer player) {
        for (Map.Entry<ChaosBuff, Integer> entry : this.getBuffs(stack).entrySet()) {
            entry.getKey().applyToPlayer(player, entry.getValue(), stack);
        }
    }

    public void removeEffects(ItemStack stack, EntityPlayer player) {
        for (Map.Entry<ChaosBuff, Integer> entry : this.getBuffs(stack).entrySet()) {
            entry.getKey().removeFromPlayer(player, entry.getValue(), stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        boolean enabled = this.isEnabled(stack);
        int totalDrain = this.getTotalChargeDrain(stack, player);
        if (enabled) {
            this.applyEffects(stack, player);
            if (!this.isCheatyGem(stack)) {
                this.extractCharge(stack, totalDrain, false);
                if (this.getCharge(stack) <= 0) {
                    this.setEnabled(stack, false);
                    this.removeEffects(stack, player);
                }
            }
        }
        if (!enabled || totalDrain <= 0) {
            this.receiveCharge(stack, this.getSelfRechargeAmount(stack), false);
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, EntityPlayer player) {
        this.setEnabled(stack, false);
        this.removeEffects(stack, player);
        return true;
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (StackHelper.isValid((ItemStack)stack) && this.getCharge(stack) > 0) {
            this.setEnabled(stack, !this.isEnabled(stack));
            if (this.isEnabled(stack)) {
                this.applyEffects(stack, player);
            } else {
                this.removeEffects(stack, player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        LocalizationHelper loc = SilentGems.localizationHelper;
        for (Map.Entry<ChaosBuff, Integer> entry : this.getBuffs(stack).entrySet()) {
            list.add(TextFormatting.GOLD + entry.getKey().getLocalizedName(entry.getValue()));
        }
        int slotsUsed = this.getSlotsUsed(stack);
        int totalDrain = this.getTotalChargeDrain(stack, SilentGems.proxy.getClientPlayer());
        list.add(loc.getItemSubText(this.itemName, "charge", new Object[]{this.getCharge(stack), this.getMaxCharge(stack)}));
        list.add(loc.getItemSubText(this.itemName, "slots", new Object[]{slotsUsed, 20}));
        list.add(loc.getItemSubText(this.itemName, "drain", new Object[]{totalDrain}));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = this.getCharge(stack);
        double max = this.getMaxCharge(stack);
        return max > 0.0 ? (max - charge) / max : 1.0;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return this.getCharge(stack) < this.getMaxCharge(stack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.isEnabled(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        boolean oldEnabled = this.isEnabled(oldStack);
        boolean newEnabled = this.isEnabled(newStack);
        return slotChanged || oldEnabled != newEnabled || !oldStack.func_77969_a(newStack);
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        for (int i = 0; i < this.subItemCount; ++i) {
            ItemStack stack1 = new ItemStack(item, 1, i);
            list.add(stack1);
            if (this.getMaxCharge(stack1) <= 0) continue;
            ItemStack stack2 = StackHelper.safeCopy((ItemStack)stack1);
            this.receiveCharge(stack2, this.getMaxCharge(stack2), false);
            list.add(stack2);
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.BELT;
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="baubles")
    public boolean willAutoSync(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="baubles")
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType renderType, float partialTicks) {
        if (renderType == IRenderBauble.RenderType.BODY) {
            float scale = 0.5f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            IRenderBauble.Helper.translateToChest();
            GlStateManager.func_179137_b((double)0.0, (double)1.7, (double)0.3);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        }
    }

    public static final class Gui {
        public static final ResourceLocation TEXTURE_FRAME = new ResourceLocation("silentgems", "textures/gui/chaosbarframe.png");
        public static final ResourceLocation TEXTURE_BAR = new ResourceLocation("silentgems", "textures/gui/chaosbar.png");
        public static final int BAR_WIDTH = 40;
        public static final int BAR_HEIGHT = 8;

        @SideOnly(value=Side.CLIENT)
        public static void renderGameOverlay(Minecraft mc) {
            EntityPlayerSP player = mc.field_71439_g;
            ArrayList gems = Lists.newArrayList();
            ItemChaosGem chaosGem = ModItems.chaosGem;
            ItemStackList playerInventory = PlayerHelper.getNonEmptyStacks((EntityPlayer)player);
            playerInventory.addAll(BaublesCompat.getBaubles((EntityPlayer)player, (Predicate<ItemStack>)((Predicate)s -> s.func_77973_b() instanceof ItemChaosGem)));
            for (ItemStack stack : playerInventory) {
                if (!StackHelper.isValid((ItemStack)stack) || !(stack.func_77973_b() instanceof ItemChaosGem) || !chaosGem.isEnabled(stack) || chaosGem.getTotalChargeDrain(stack, (EntityPlayer)player) <= 0) continue;
                gems.add(stack);
            }
            if (gems.isEmpty()) {
                return;
            }
            ScaledResolution res = new ScaledResolution(mc);
            int index = 1;
            for (ItemStack gem : gems) {
                int current = chaosGem.getCharge(gem);
                int max = chaosGem.getMaxCharge(gem);
                float storedFraction = (float)current / (float)max;
                float red = 1.0f;
                float green = 1.0f;
                float blue = 1.0f;
                int gemId = gem.func_77952_i();
                if (gemId >= 0 && gemId < EnumGem.values().length) {
                    int color = EnumGem.values()[gemId].getColor();
                    red = (float)(color >> 16 & 0xFF) / 255.0f;
                    green = (float)(color >> 8 & 0xFF) / 255.0f;
                    blue = (float)(color & 0xFF) / 255.0f;
                }
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                float scale = 1.0f;
                GL11.glPushMatrix();
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                int posX = GemsConfig.CHAOS_GEM_BAR_POS_X;
                posX = (int)((float)(posX < 0 ? res.func_78326_a() + posX - 40 : posX) / scale);
                int posY = GemsConfig.CHAOS_GEM_BAR_POS_Y;
                int signY = posY < 0 ? -1 : 1;
                posY = (int)((float)((posY < 0 ? res.func_78328_b() + posY : posY) + index * signY * 10) / scale);
                GL11.glColor4f((float)red, (float)green, (float)blue, (float)0.5f);
                mc.field_71446_o.func_110577_a(TEXTURE_BAR);
                int barPosWidth = (int)(40.0f * storedFraction);
                int barPosX = posX;
                int barPosHeight = 8;
                int barPosY = posY;
                Gui.drawRect(barPosX, barPosY, 0.0f, 0.0f, barPosWidth, barPosHeight);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                mc.field_71446_o.func_110577_a(TEXTURE_FRAME);
                Gui.drawRect(posX, posY, 0.0f, 0.0f, 40.0f, 8.0f);
                GL11.glEnable((int)3042);
                GL11.glPopMatrix();
                GL11.glPushMatrix();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                scale = 0.7f;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                FontRenderer fontRender = mc.field_71466_p;
                String format = "%.2f%%";
                String str = String.format(format, Float.valueOf(storedFraction * 100.0f));
                posX = GemsConfig.CHAOS_GEM_BAR_POS_X;
                posX = (int)((float)(posX < 0 ? res.func_78326_a() + posX - 40 + 3 : posX + 3) / scale);
                posY = GemsConfig.CHAOS_GEM_BAR_POS_Y;
                signY = posY < 0 ? -1 : 1;
                posY = (int)((float)((posY < 0 ? res.func_78328_b() + posY : posY) + index * signY * 10 + 2) / scale);
                fontRender.func_175063_a(str, (float)posX, (float)posY, 0xFFFFFF);
                GL11.glPopMatrix();
                ++index;
            }
        }

        private static void drawRect(float x, float y, float u, float v, float width, float height) {
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilderSL buff = BufferBuilderSL.INSTANCE.acquireBuffer(tess);
            buff.begin(7, DefaultVertexFormats.field_181707_g);
            buff.pos((double)x, (double)(y + height), 0.0).tex(0.0, 1.0).endVertex();
            buff.pos((double)(x + width), (double)(y + height), 0.0).tex(1.0, 1.0).endVertex();
            buff.pos((double)(x + width), (double)y, 0.0).tex(1.0, 0.0).endVertex();
            buff.pos((double)x, (double)y, 0.0).tex(0.0, 0.0).endVertex();
            tess.func_78381_a();
        }
    }
}

