/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.IBlockPlacer;
import net.silentchaos512.gems.util.NBTHelper;
import net.silentchaos512.lib.item.ItemSL;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.lib.util.ItemHelper;
import net.silentchaos512.lib.util.LocalizationHelper;
import net.silentchaos512.lib.util.PlayerHelper;
import net.silentchaos512.lib.util.StackHelper;

public abstract class ItemBlockPlacer
extends ItemSL
implements IBlockPlacer {
    protected static final int ABSORB_DELAY = 20;
    protected static final String NBT_AUTO_FILL = "AutoFill";
    protected static final String NBT_BLOCK_COUNT = "BlockCount";
    protected int maxBlocks;

    public ItemBlockPlacer(String name, int maxBlocks) {
        super(1, "silentgems", name);
        this.maxBlocks = maxBlocks;
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77655_b(name);
    }

    public void clAddInformation(ItemStack stack, World world, List list, boolean advanced) {
        String blockPlacer = "BlockPlacer";
        LocalizationHelper loc = SilentGems.localizationHelper;
        boolean autoFillOn = this.getAutoFillMode(stack);
        int currentBlocks = this.getRemainingBlocks(stack);
        int maxBlocks = this.getMaxBlocksStored(stack);
        list.add(loc.getItemSubText(blockPlacer, "count", new Object[]{currentBlocks, maxBlocks}));
        String onOrOff = loc.getMiscText("state." + (autoFillOn ? "on" : "off"), new Object[0]);
        list.add(loc.getItemSubText(blockPlacer, "autoFill", new Object[]{onOrOff}));
    }

    @Override
    @Nullable
    public abstract IBlockState getBlockPlaced(ItemStack var1);

    public int getBlockMetaDropped(ItemStack stack) {
        IBlockState state = this.getBlockPlaced(stack);
        return state.func_177230_c().func_176201_c(state);
    }

    @Override
    public int getRemainingBlocks(ItemStack stack) {
        return NBTHelper.getTagInt(stack, NBT_BLOCK_COUNT);
    }

    @Override
    public void setRemainingBlocks(ItemStack stack, int value) {
        value = MathHelper.func_76125_a((int)value, (int)0, (int)this.getMaxBlocksStored(stack));
        NBTHelper.setTagInt(stack, NBT_BLOCK_COUNT, value);
    }

    @Override
    public int getMaxBlocksStored(ItemStack stack) {
        return this.maxBlocks;
    }

    public boolean getAutoFillMode(ItemStack stack) {
        if (!NBTHelper.hasKey(stack, NBT_AUTO_FILL)) {
            NBTHelper.setTagBoolean(stack, NBT_AUTO_FILL, true);
        }
        return NBTHelper.getTagBoolean(stack, NBT_AUTO_FILL);
    }

    public void setAutoFillMode(ItemStack stack, boolean value) {
        NBTHelper.setTagBoolean(stack, NBT_AUTO_FILL, value);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L && entity instanceof EntityPlayer && this.getAutoFillMode(stack)) {
            this.absorbBlocksFromPlayer(stack, (EntityPlayer)entity);
        }
        if (stack.func_77952_i() > 0 && !NBTHelper.hasKey(stack, NBT_BLOCK_COUNT)) {
            int blockCount = this.getMaxBlocksStored(stack) - stack.func_77952_i();
            SilentGems.logHelper.debug(new Object[]{blockCount});
            NBTHelper.setTagInt(stack, NBT_BLOCK_COUNT, blockCount);
            stack.func_77964_b(0);
        }
    }

    protected ItemStack absorbBlocksFromPlayer(ItemStack stack, EntityPlayer player) {
        int maxBlocksStored = this.getMaxBlocksStored(stack);
        if (this.getRemainingBlocks(stack) >= maxBlocksStored) {
            return stack;
        }
        IBlockState statePlaced = this.getBlockPlaced(stack);
        if (statePlaced == null) {
            return stack;
        }
        Block blockPlaced = statePlaced.func_177230_c();
        int metaDropped = this.getBlockMetaDropped(stack);
        Item itemBlock = Item.func_150898_a((Block)blockPlaced);
        for (ItemStack invStack : PlayerHelper.getNonEmptyStacks((EntityPlayer)player, (boolean)true, (boolean)true, (boolean)false)) {
            if (invStack.func_77973_b() != itemBlock || invStack.func_77952_i() != metaDropped) continue;
            int currentBlocks = this.getRemainingBlocks(stack);
            if (currentBlocks + StackHelper.getCount((ItemStack)invStack) > maxBlocksStored) {
                this.setRemainingBlocks(stack, this.maxBlocks);
                StackHelper.shrink((ItemStack)invStack, (int)(maxBlocksStored - currentBlocks));
                return stack;
            }
            SilentGems.logHelper.debug(new Object[]{currentBlocks + StackHelper.getCount((ItemStack)invStack)});
            this.setRemainingBlocks(stack, currentBlocks + StackHelper.getCount((ItemStack)invStack));
            StackHelper.setCount((ItemStack)invStack, (int)0);
            if (StackHelper.getCount((ItemStack)invStack) > 0) continue;
            PlayerHelper.removeItem((EntityPlayer)player, (ItemStack)invStack);
        }
        return stack;
    }

    public int absorbBlocks(ItemStack placer, ItemStack blockStack) {
        int maxBlocksStored;
        int blockCount;
        int placerCount = this.getRemainingBlocks(placer);
        if (placerCount + (blockCount = StackHelper.getCount((ItemStack)blockStack)) > (maxBlocksStored = this.getMaxBlocksStored(placer))) {
            this.setRemainingBlocks(placer, maxBlocksStored);
            return maxBlocksStored - placerCount;
        }
        this.setRemainingBlocks(placer, placerCount + blockCount);
        return blockCount;
    }

    protected ActionResult<ItemStack> clOnItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_70093_af()) {
            boolean mode = !this.getAutoFillMode(stack);
            this.setAutoFillMode(stack, mode);
            LocalizationHelper loc = SilentGems.localizationHelper;
            String onOrOff = loc.getMiscText("state." + (mode ? "on" : "off"), new Object[0]);
            onOrOff = (mode ? TextFormatting.GREEN : TextFormatting.RED) + onOrOff;
            String line = loc.getItemSubText("BlockPlacer", "autoFill", new Object[]{onOrOff});
            ChatHelper.sendStatusMessage((EntityPlayer)player, (String)line, (boolean)true);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    protected EnumActionResult clOnItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.getRemainingBlocks(stack) <= 0 && !player.field_71075_bZ.field_75098_d) {
            return EnumActionResult.PASS;
        }
        IBlockState state = this.getBlockPlaced(stack);
        if (state == null) {
            return EnumActionResult.PASS;
        }
        Block block = state.func_177230_c();
        ItemStack fakeBlockStack = new ItemStack(block, 1, block.func_176201_c(state));
        ItemStack currentOffhand = player.func_184592_cb();
        player.func_184611_a(EnumHand.OFF_HAND, fakeBlockStack);
        EnumActionResult result = ItemHelper.onItemUse((Item)fakeBlockStack.func_77973_b(), (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumHand)EnumHand.OFF_HAND, (EnumFacing)facing, (float)hitX, (float)hitY, (float)hitZ);
        player.func_184611_a(EnumHand.OFF_HAND, currentOffhand);
        if (result == EnumActionResult.SUCCESS) {
            this.setRemainingBlocks(stack, this.getRemainingBlocks(stack) - 1);
        }
        return result;
    }

    public ActionResult<ItemStack> onItemLeftClickSL(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_70093_af() && this.getRemainingBlocks(stack) > 0) {
            IBlockState state = this.getBlockPlaced(stack);
            int meta = this.getBlockMetaDropped(stack);
            ItemStack toDrop = new ItemStack(state.func_177230_c(), 1, meta);
            StackHelper.setCount((ItemStack)toDrop, (int)Math.min(this.getRemainingBlocks(stack), toDrop.func_77976_d()));
            this.setRemainingBlocks(stack, this.getRemainingBlocks(stack) - StackHelper.getCount((ItemStack)toDrop));
            Vec3d vec = player.func_70040_Z().func_186678_a(2.0);
            EntityItem entity = new EntityItem(world, player.field_70165_t + vec.field_72450_a, player.field_70163_u + 1.0 + vec.field_72448_b, player.field_70161_v + vec.field_72450_a, toDrop);
            vec = vec.func_186678_a(-0.125);
            entity.field_70159_w = vec.field_72450_a;
            entity.field_70181_x = vec.field_72448_b;
            entity.field_70179_y = vec.field_72449_c;
            EntityHelper.safeSpawn((Entity)entity);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    protected void clGetSubItems(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (!ItemHelper.isInCreativeTab((Item)item, (CreativeTabs)tab)) {
            return;
        }
        ItemStack stackEmpty = new ItemStack(item);
        ItemStack stackFull = new ItemStack(item);
        this.setRemainingBlocks(stackFull, this.getMaxBlocksStored(stackFull));
        list.add(stackEmpty);
        list.add(stackFull);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        int maxBlocksStored = this.getMaxBlocksStored(stack);
        if (maxBlocksStored <= 0) {
            return 1.0;
        }
        return 1.0 - (double)this.getRemainingBlocks(stack) / (double)maxBlocksStored;
    }
}

