/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.compat.jei.altar;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.compat.jei.SilentGemsPlugin;

public class AltarRecipeCategory
implements IRecipeCategory {
    public static final String CATEGORY = "silentgems:ChaosAltar";
    public static final int GUI_START_X = 42;
    public static final int GUI_START_Y = 28;
    public static final int GUI_WIDTH = 98;
    public static final int GUI_HEIGHT = 47;
    @Nonnull
    protected final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated arrow;
    @Nonnull
    private final String localizedName = SilentGems.localizationHelper.getLocalizedString("jei", "recipe.altar", new Object[0]);

    public AltarRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = new ResourceLocation("silentgems:textures/gui/ChaosAltar.png");
        this.background = SilentGemsPlugin.jeiHelper.getGuiHelper().createDrawable(backgroundLocation, 42, 28, 98, 47);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(backgroundLocation, 176, 14, 24, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawExtras(Minecraft mc) {
        this.arrow.draw(mc, 38, 6);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public String getUid() {
        return CATEGORY;
    }

    public void setRecipe(IRecipeLayout recipeLayout, IRecipeWrapper recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 13, 6);
        recipeLayout.getItemStacks().init(1, false, 68, 6);
        recipeLayout.getItemStacks().init(2, true, 40, 25);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        recipeLayout.getItemStacks().set(1, (List)ingredients.getOutputs(ItemStack.class).get(0));
        recipeLayout.getItemStacks().set(2, (List)ingredients.getInputs(ItemStack.class).get(1));
    }

    public String getModName() {
        return "Silent's Gems";
    }

    public List getTooltipStrings(int arg0, int arg1) {
        return Lists.newArrayList();
    }
}

