/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.BlockTeleporter;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.ModBlocks;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.gems.tile.TileTeleporter;
import net.silentchaos512.lib.registry.RecipeMaker;
import net.silentchaos512.lib.util.DimensionalPosition;

public class BlockTeleporterRedstone
extends BlockTeleporter {
    public BlockTeleporterRedstone(EnumGem.Set set) {
        super(set, false, "TeleporterRedstone");
    }

    @Override
    public void addRecipes(RecipeMaker recipes) {
        if (GemsConfig.RECIPE_TELEPORTER_REDSTONE_DISABLE) {
            return;
        }
        ItemStack[] anyTeleporter = new ItemStack[]{new ItemStack((Block)ModBlocks.teleporterRedstone, 1, Short.MAX_VALUE), new ItemStack((Block)ModBlocks.teleporterRedstoneDark, 1, Short.MAX_VALUE), new ItemStack((Block)ModBlocks.teleporterRedstoneLight, 1, Short.MAX_VALUE)};
        int lastIndex = -1;
        for (int i = 0; i < this.subBlockCount; ++i) {
            EnumGem gem = this.getGem(i);
            ItemStack teleporterRedstone = new ItemStack((Block)this, 1, i);
            ItemStack teleporterBasic = this.getBasicTeleporter(i);
            recipes.addShapelessOre(this.blockName + i, teleporterRedstone, new Object[]{teleporterBasic, "dustRedstone"});
            for (ItemStack stack : anyTeleporter) {
                recipes.addShapelessOre(this.blockName + "_" + ++lastIndex + "_recolor", new ItemStack((Block)this, 1, i), new Object[]{stack, gem.getItemOreName()});
            }
        }
    }

    private ItemStack getBasicTeleporter(int meta) {
        BlockTeleporter block = this == ModBlocks.teleporterRedstone ? ModBlocks.teleporter : (this == ModBlocks.teleporterRedstoneDark ? ModBlocks.teleporterDark : ModBlocks.teleporterLight);
        return new ItemStack((Block)block, 1, meta);
    }

    protected void clOnNeighborChanged(IBlockState state, World world, BlockPos pos, Block block) {
        double searchRange = GemsConfig.TELEPORTER_REDSTONE_SEARCH_RADIUS * GemsConfig.TELEPORTER_REDSTONE_SEARCH_RADIUS;
        TileTeleporter tile = (TileTeleporter)world.func_175625_s(pos);
        if (!world.field_72995_K && world.func_175687_A(pos) != 0) {
            if (!tile.isDestinationAllowedIfDumb(null)) {
                String str = SilentGems.localizationHelper.getBlockSubText("Teleporter", "NoReceiver", new Object[0]);
                return;
            }
            if (!tile.isDestinationSafe(null)) {
                return;
            }
            boolean playSound = false;
            DimensionalPosition source = null;
            for (Entity entity : world.func_175644_a(Entity.class, e -> e.func_174831_c(pos) < searchRange)) {
                EntityPlayer player;
                if (source == null) {
                    source = new DimensionalPosition(pos, entity.field_71093_bK);
                }
                if (entity instanceof EntityPlayer && !tile.checkAndDrainChaos(player = (EntityPlayer)entity) || !tile.teleportEntityToDestination(entity)) continue;
                playSound = true;
            }
            if (playSound) {
                float pitch = 0.7f + 0.3f * SilentGems.random.nextFloat();
                for (BlockPos p : new BlockPos[]{pos, tile.getDestination().toBlockPos()}) {
                    world.func_184133_a(null, p, SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, pitch);
                }
            }
        }
    }
}

