/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.silentchaos512.gems.lib.EnumGem;
import net.silentchaos512.lib.block.BlockSL;

public class BlockGemSubtypes
extends BlockSL {
    public final EnumGem.Set gemSet;

    public BlockGemSubtypes(String name) {
        super(1, "silentgems", name, Material.field_151576_e);
        this.gemSet = EnumGem.Set.CLASSIC;
    }

    public BlockGemSubtypes(EnumGem.Set set, String name) {
        this(16, set, name, Material.field_151576_e);
    }

    public BlockGemSubtypes(EnumGem.Set set, String name, Material material) {
        this(16, set, name, material);
    }

    public BlockGemSubtypes(int subtypeCount, EnumGem.Set set, String name, Material material) {
        super(subtypeCount, "silentgems", name, material);
        this.gemSet = set;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)EnumGem.VARIANT_GEM, (Comparable)((Object)EnumGem.RUBY)));
        this.func_149663_c(name);
    }

    protected static String nameForSet(EnumGem.Set set, String baseName) {
        switch (set) {
            case CLASSIC: {
                return baseName;
            }
            case DARK: {
                return baseName + "Dark";
            }
            case LIGHT: {
                return baseName + "Light";
            }
        }
        return baseName + "Unknown";
    }

    public EnumGem getGem(int meta) {
        if (meta < 0 || meta > 15) {
            return EnumGem.RUBY;
        }
        return EnumGem.values()[meta + this.gemSet.startMeta];
    }

    public boolean hasSubtypes() {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return this.getGem(this.func_176201_c(state)).ordinal() & 0xF;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EnumGem.VARIANT_GEM, (Comparable)((Object)EnumGem.values()[meta & 0xF]));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumGem)((Object)state.func_177229_b((IProperty)EnumGem.VARIANT_GEM))).ordinal() & 0xF;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumGem.VARIANT_GEM});
    }

    public void getModels(Map<Integer, ModelResourceLocation> models) {
        for (int i = 0; i < 16; ++i) {
            EnumGem gem = EnumGem.values()[i];
            models.put(i, new ModelResourceLocation(this.getFullName().toLowerCase(), "gem=" + gem.func_176610_l()));
        }
    }
}

