/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.tool.part;

import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.IArmor;
import net.silentchaos512.gems.api.ITool;
import net.silentchaos512.gems.api.lib.ArmorPartPosition;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.stats.CommonItemStats;
import net.silentchaos512.gems.api.stats.ItemStat;
import net.silentchaos512.gems.api.stats.ItemStatModifier;
import net.silentchaos512.gems.api.tool.ToolStats;
import net.silentchaos512.gems.api.tool.part.ToolPart;
import net.silentchaos512.gems.api.tool.part.ToolPartRegistry;
import net.silentchaos512.gems.config.GemsConfigHC;
import net.silentchaos512.gems.util.ArmorHelper;
import net.silentchaos512.gems.util.ToolHelper;

public abstract class ToolPartMain
extends ToolPart {
    static final float[][] REPAIR_VALUES = new float[][]{{0.5f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.5f, 1.0f, 1.0f}, {0.0f, 0.25f, 1.0f, 1.0f}, {0.0f, 0.125f, 0.5f, 1.0f}};

    public ToolPartMain(String key, ItemStack craftingStack) {
        super(key, craftingStack);
    }

    public ToolPartMain(String key, ItemStack craftingStack, String oreName) {
        super(key, craftingStack, oreName);
    }

    @Override
    public ItemStatModifier getStatModifier(ItemStat stat, EnumMaterialGrade grade) {
        float val = this.stats.getStat(stat);
        if (stat == CommonItemStats.HARVEST_LEVEL) {
            return new ItemStatModifier(this.getUnlocalizedName(), val, ItemStatModifier.Operation.MAX);
        }
        return new ItemStatModifier(this.getUnlocalizedName(), val *= (float)(100 + grade.bonusPercent) / 100.0f, ItemStatModifier.Operation.AVERAGE);
    }

    @Override
    public int getRepairAmount(ItemStack toolOrArmor, ItemStack partRep) {
        EnumMaterialTier stackTier;
        if (this.isBlacklisted(partRep)) {
            return 0;
        }
        if (GemsConfigHC.REPAIR_LOGIC != GemsConfigHC.EnumRepairLogic.CLASSIC) {
            ToolPart repairPart = ToolPartRegistry.fromStack(partRep);
            EnumMaterialGrade repairGrade = EnumMaterialGrade.fromStack(partRep);
            float amount = repairPart.getDurability() * (100 + repairGrade.bonusPercent) / 100;
            if (toolOrArmor.func_77973_b() instanceof IArmor) {
                amount /= 2.0f;
            }
            switch (GemsConfigHC.REPAIR_LOGIC) {
                case HARD_MATERIAL_BASED: {
                    return (int)(amount / 4.0f);
                }
                case MATERIAL_BASED: {
                    return (int)(amount / 2.0f);
                }
                case NOT_ALLOWED: {
                    return 0;
                }
            }
        }
        int max = toolOrArmor.func_77958_k();
        float scale = 0.0f;
        EnumMaterialTier partTier = this.getTier();
        EnumMaterialTier enumMaterialTier = toolOrArmor.func_77973_b() instanceof ITool ? ToolHelper.getToolTier(toolOrArmor) : (stackTier = toolOrArmor.func_77973_b() instanceof IArmor ? ArmorHelper.getArmorTier(toolOrArmor) : null);
        if (stackTier == null) {
            return 0;
        }
        int toolTierIndex = ToolHelper.getToolTier(toolOrArmor).ordinal();
        int partTierIndex = partTier.ordinal();
        scale = REPAIR_VALUES[toolTierIndex][partTierIndex];
        return (int)(scale * (float)max);
    }

    @Override
    public final void applyStats(ToolStats stats) {
    }

    @Override
    public int getDurability() {
        return 0;
    }

    @Override
    public float getHarvestSpeed() {
        return 0.0f;
    }

    @Override
    public int getHarvestLevel() {
        return 0;
    }

    @Override
    public float getMeleeDamage() {
        return 0.0f;
    }

    @Override
    public float getMagicDamage() {
        return 0.0f;
    }

    @Override
    public int getEnchantability() {
        return 0;
    }

    @Override
    public float getMeleeSpeed() {
        return 0.0f;
    }

    @Override
    public float getChargeSpeed() {
        return 0.0f;
    }

    @Override
    public float getProtection() {
        return 0.0f;
    }

    @Override
    public boolean validForPosition(IPartPosition pos) {
        return pos == ToolPartPosition.HEAD || pos == ToolPartPosition.ROD_DECO || pos instanceof ArmorPartPosition && pos != ArmorPartPosition.FRAME;
    }

    @Override
    public boolean validForToolOfTier(EnumMaterialTier toolTier) {
        return this.getTier() == toolTier;
    }
}

