/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.api.tool.part;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.silentchaos512.gems.api.lib.ArmorPartPosition;
import net.silentchaos512.gems.api.lib.EnumMaterialGrade;
import net.silentchaos512.gems.api.lib.EnumMaterialTier;
import net.silentchaos512.gems.api.lib.IPartPosition;
import net.silentchaos512.gems.api.lib.ToolPartPosition;
import net.silentchaos512.gems.api.stats.ItemStat;
import net.silentchaos512.gems.api.stats.ItemStatModifier;
import net.silentchaos512.gems.api.tool.part.ToolPart;

public class ArmorPartFrame
extends ToolPart {
    protected EntityEquipmentSlot armorSlot;

    public ArmorPartFrame(String key, EntityEquipmentSlot slot, ItemStack craftingStack) {
        this(key, slot, craftingStack, "");
    }

    protected ArmorPartFrame(String key, EntityEquipmentSlot slot, ItemStack craftingStack, String craftingOreDictName) throws IllegalArgumentException {
        super(key, craftingStack, craftingOreDictName);
        if (slot.func_188453_a() != EntityEquipmentSlot.Type.ARMOR) {
            throw new IllegalArgumentException("Cannot register armor frame for slot " + slot.func_188450_d());
        }
        this.armorSlot = slot;
    }

    @Override
    public ItemStatModifier getStatModifier(ItemStat stat, EnumMaterialGrade grade) {
        float val = this.stats.getStat(stat);
        return new ItemStatModifier(this.getUnlocalizedName(), val += 1.0f, ItemStatModifier.Operation.MULTIPLY);
    }

    public EntityEquipmentSlot getSlot() {
        return this.armorSlot;
    }

    @Override
    public boolean matchesForDecorating(ItemStack partRep, boolean matchOreDict) {
        return false;
    }

    @Override
    public ModelResourceLocation getModel(ItemStack toolOrArmor, ToolPartPosition pos, int frame) {
        return null;
    }

    @Override
    public int getDurability() {
        return 0;
    }

    @Override
    public float getHarvestSpeed() {
        return 0.0f;
    }

    @Override
    public int getHarvestLevel() {
        return 0;
    }

    @Override
    public float getMeleeDamage() {
        return 0.0f;
    }

    @Override
    public float getMagicDamage() {
        return 0.0f;
    }

    @Override
    public int getEnchantability() {
        return 0;
    }

    @Override
    public float getMeleeSpeed() {
        return 0.0f;
    }

    @Override
    public float getChargeSpeed() {
        return 0.0f;
    }

    @Override
    public float getProtection() {
        return 0.0f;
    }

    @Override
    public boolean validForToolOfTier(EnumMaterialTier targetTier) {
        return this.getTier() == targetTier;
    }

    @Override
    public boolean validForPosition(IPartPosition pos) {
        return pos == ArmorPartPosition.FRAME;
    }
}

