/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal.proxy;

import codechicken.lib.CodeChickenLib;
import codechicken.lib.configuration.ConfigTag;
import codechicken.lib.internal.ModDescriptionEnhancer;
import codechicken.lib.internal.command.client.CCLClientCommand;
import codechicken.lib.internal.network.ClientPacketHandler;
import codechicken.lib.internal.network.PacketDispatcher;
import codechicken.lib.internal.proxy.Proxy;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.loader.bakery.CCBakeryModelLoader;
import codechicken.lib.model.loader.blockstate.CCBlockStateLoader;
import codechicken.lib.model.loader.cube.CCCubeLoader;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.render.CCRenderEventHandler;
import codechicken.lib.render.OpenGLUtils;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.CCBlockRendererDispatcher;
import codechicken.lib.render.item.CCRenderItem;
import codechicken.lib.render.item.entity.WrappedEntityItemRenderer;
import codechicken.lib.render.item.map.MapRenderRegistry;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.texture.TextureUtils;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProxyClient
extends Proxy {
    private static boolean hasSanitized;

    @Override
    public void preInit() {
        super.preInit();
        OpenGLUtils.loadCaps();
        CustomParticleHandler.init();
        CCBlockStateLoader.initialize();
        ModelBakery.init();
        CCRenderEventHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)new TextureUtils());
        MinecraftForge.EVENT_BUS.register((Object)new MapRenderRegistry());
        MinecraftForge.EVENT_BUS.register((Object)new ModelRegistryHelper());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)CCCubeLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)CCBakeryModelLoader.INSTANCE);
        PacketCustom.assignHandler(PacketDispatcher.NET_CHANNEL, new ClientPacketHandler());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CCLClientCommand());
        RenderingRegistry.registerEntityRenderingHandler(DummyEntity.class, manager -> {
            ProxyClient.sanitizeEntityRenderers(manager);
            return new Render<DummyEntity>(manager){

                protected ResourceLocation getEntityTexture(DummyEntity entity) {
                    return null;
                }
            };
        });
    }

    @Override
    public void init() {
        super.init();
        BlockRenderingRegistry.init();
        CCRenderItem.init();
        ModDescriptionEnhancer.init();
    }

    @Override
    public void postInit() {
        super.postInit();
        RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
        Render render = (Render)manager.field_78729_o.get(EntityItem.class);
        if (render == null) {
            throw new RuntimeException("EntityItem does not have a Render bound... This is likely a bug..");
        }
        manager.field_78729_o.put(EntityItem.class, new WrappedEntityItemRenderer(manager, (Render<EntityItem>)render));
        manager.field_78729_o.remove(DummyEntity.class);
    }

    @Override
    public void loadConfig() {
        super.loadConfig();
        ConfigTag clientTag = CodeChickenLib.config.getTag("client");
        ConfigTag brdMisc = clientTag.getTag("block_renderer_dispatcher_misc");
        ConfigTag tag = brdMisc.getTag("catch_all_crashes").setComment("With this enabled, CCL will attempt to catch all crashes from blocks failing to render somehow.");
        CCBlockRendererDispatcher.catchAllCrashes = tag.setDefaultBoolean(false).getBoolean();
        tag = brdMisc.getTag("message_player_on_catch").setComment("With this enabled, the player will be messaged when an exception is caught providing some immediate debug info, the entire exception is printed to console. (This even catches ReportedExceptions!)");
        CCBlockRendererDispatcher.messagePlayerOnCatch = tag.setDefaultBoolean(false).getBoolean();
        clientTag.save();
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void sanitizeEntityRenderers(RenderManager renderManager) {
        if (!hasSanitized) {
            try {
                for (Render render : renderManager.field_78729_o.values()) {
                    if (render == null) continue;
                    for (Field field : render.getClass().getDeclaredFields()) {
                        if (!field.getType().equals(RenderItem.class)) continue;
                        field.setAccessible(true);
                        field.set(render, CCRenderItem.getOverridenRenderItem());
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to reflect an EntityRenderer!", e);
            }
            hasSanitized = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class DummyEntity
    extends Entity {
        public DummyEntity(World worldIn) {
            super(worldIn);
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound compound) {
        }

        protected void func_70014_b(NBTTagCompound compound) {
        }
    }
}

