/*
 * Decompiled with CFR 0.152.
 */
package romelo333.rflux.blocks;

import elucent.albedo.lighting.ILightProvider;
import elucent.albedo.lighting.Light;
import mcjty.lib.bindings.DefaultValue;
import mcjty.lib.bindings.IValue;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.GenericBlock;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import romelo333.rflux.Config;
import romelo333.rflux.ModBlocks;
import romelo333.rflux.blocks.BlockColor;
import romelo333.rflux.blocks.GenericLightBlock;
import romelo333.rflux.blocks.LightMode;

@Optional.InterfaceList(value={@Optional.Interface(iface="elucent.albedo.lighting.ILightProvider", modid="albedo")})
public class LightTE
extends GenericEnergyReceiverTileEntity
implements ITickable,
ILightProvider {
    private BlockColor color = BlockColor.WHITE;
    private Object light = null;
    private boolean lit = false;
    private LightMode mode = LightMode.MODE_NORMAL;
    private int checkLitCounter = 10;
    public static final Key<Integer> VALUE_MODE = new Key("mode", Type.INTEGER);

    public IValue<?>[] getValues() {
        return new IValue[]{new DefaultValue(VALUE_RSMODE, () -> ((LightTE)this).getRSModeInt(), arg_0 -> ((LightTE)this).setRSModeInt(arg_0)), new DefaultValue(VALUE_MODE, () -> this.getMode().ordinal(), v -> this.setMode(LightMode.values()[v]))};
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public LightTE() {
        super((long)Config.LIGHTBLOCK_MAXRF, (long)Config.LIGHTBLOCK_RECEIVEPERTICK);
    }

    public boolean isLit() {
        return this.lit;
    }

    @Optional.Method(modid="albedo")
    public Light provideLight() {
        if (this.light == null && this.lit) {
            this.light = new Light((float)this.field_174879_c.func_177958_n(), (float)this.field_174879_c.func_177956_o(), (float)this.field_174879_c.func_177952_p(), this.color.getR(), this.color.getG(), this.color.getB(), 1.0f, this.mode == LightMode.MODE_NORMAL ? 16.0f : (this.mode == LightMode.MODE_EXTENDED ? 20.0f : 24.0f));
        }
        return (Light)this.light;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            boolean newlit = this.isMachineEnabled();
            if (newlit) {
                int rf = this.mode.getRfUsage();
                if (this.storage.getEnergyStored() >= (long)rf) {
                    this.storage.extractEnergy((long)rf, false);
                } else {
                    newlit = false;
                }
            }
            if (newlit != this.lit) {
                this.lit = newlit;
                this.light = null;
                IBlockState oldState = this.func_145831_w().func_180495_p(this.field_174879_c);
                GenericLightBlock block = (GenericLightBlock)oldState.func_177230_c();
                if (block.getRotationType() == BaseBlock.RotationType.NONE) {
                    if (this.lit) {
                        this.func_145831_w().func_180501_a(this.field_174879_c, block.getLitBlock().func_176223_P(), 3);
                    } else {
                        this.func_145831_w().func_180501_a(this.field_174879_c, block.getUnlitBlock().func_176223_P(), 3);
                    }
                } else if (this.lit) {
                    this.func_145831_w().func_180501_a(this.field_174879_c, block.getLitBlock().func_176223_P().func_177226_a((IProperty)GenericBlock.FACING, oldState.func_177229_b((IProperty)GenericBlock.FACING)), 3);
                } else {
                    this.func_145831_w().func_180501_a(this.field_174879_c, block.getUnlitBlock().func_176223_P().func_177226_a((IProperty)GenericBlock.FACING, oldState.func_177229_b((IProperty)GenericBlock.FACING)), 3);
                }
                this.func_145829_t();
                this.func_145831_w().func_175690_a(this.field_174879_c, (TileEntity)this);
                this.markDirtyClient();
                this.updateLightBlocks(this.lit);
            } else if (this.lit) {
                --this.checkLitCounter;
                if (this.checkLitCounter <= 0) {
                    this.checkLitCounter = 10;
                    this.updateLightBlocks(this.lit);
                }
            }
        }
    }

    private void updateLightBlocks(boolean lit) {
        BlockPos.MutableBlockPos lpos = new BlockPos.MutableBlockPos();
        int range = this.mode.getRange();
        if (range == 0) {
            return;
        }
        for (int x = -range; x <= range; x += range) {
            for (int y = -range; y <= range; y += range) {
                for (int z = -range; z <= range; z += range) {
                    BlockPos npos;
                    if (x == 0 && y == 0 && z == 0) continue;
                    if (lit) {
                        lpos.func_181079_c(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z);
                        if (this.isInvisibleLight((BlockPos)lpos)) continue;
                        if (this.func_145831_w().func_175623_d((BlockPos)lpos)) {
                            this.setInvisibleBlock((BlockPos)lpos);
                            continue;
                        }
                        for (EnumFacing facing : EnumFacing.field_82609_l) {
                            npos = lpos.func_177972_a(facing);
                            if (this.isInvisibleLight(npos) || !this.func_145831_w().func_175623_d(npos)) continue;
                            this.setInvisibleBlock(npos);
                        }
                        continue;
                    }
                    lpos.func_181079_c(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z);
                    if (this.isInvisibleLight((BlockPos)lpos)) {
                        this.func_145831_w().func_175698_g((BlockPos)lpos);
                    }
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        npos = lpos.func_177972_a(facing);
                        if (!this.isInvisibleLight(npos)) continue;
                        this.func_145831_w().func_175698_g(npos);
                    }
                }
            }
        }
    }

    private boolean setInvisibleBlock(BlockPos npos) {
        return this.func_145831_w().func_180501_a(npos, ModBlocks.invisibleLightBlock.func_176223_P(), 3);
    }

    private boolean isInvisibleLight(BlockPos lpos) {
        return this.func_145831_w().func_180495_p(lpos).func_177230_c() == ModBlocks.invisibleLightBlock;
    }

    public void onBlockBreak(World workd, BlockPos pos, IBlockState state) {
        this.updateLightBlocks(false);
    }

    public void setMode(LightMode mode) {
        if (mode == this.mode) {
            return;
        }
        this.light = null;
        boolean oldlit = this.lit;
        this.lit = false;
        this.updateLightBlocks(this.lit);
        this.mode = mode;
        this.lit = oldlit;
        this.func_70296_d();
    }

    public LightMode getMode() {
        return this.mode;
    }

    public BlockColor getColor() {
        return this.color;
    }

    public void setColor(BlockColor color) {
        this.color = color;
        this.light = null;
        this.markDirtyClient();
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.lit = tagCompound.func_74767_n("lit");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74757_a("lit", this.lit);
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.mode = LightMode.values()[tagCompound.func_74771_c("mode")];
        this.color = BlockColor.values()[tagCompound.func_74762_e("color")];
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("color", this.color.ordinal());
        tagCompound.func_74774_a("mode", (byte)this.mode.ordinal());
    }
}

