/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.network.packet;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.network.packet.SendAbilityStorePacket;

public class RequestAbilityStorePacket
extends PacketCodec {
    @CodecField
    private String entityUuid;

    public RequestAbilityStorePacket() {
    }

    public RequestAbilityStorePacket(String entityUuid) {
        this.entityUuid = entityUuid;
    }

    public boolean isAsync() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
    }

    public void actionServer(World world, EntityPlayerMP player) {
        try {
            UUID uuid = UUID.fromString(this.entityUuid);
            Entity entity = ((WorldServer)world).func_175733_a(uuid);
            if (entity != null && entity.hasCapability(MutableAbilityStoreConfig.CAPABILITY, null)) {
                IMutableAbilityStore abilityStore = (IMutableAbilityStore)entity.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
                NBTBase contents = MutableAbilityStoreConfig.CAPABILITY.writeNBT((Object)abilityStore, null);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74782_a("contents", contents);
                EverlastingAbilities._instance.getPacketHandler().sendToPlayer((PacketBase)new SendAbilityStorePacket(entity.func_145782_y(), tag), player);
            }
        }
        catch (IllegalArgumentException e) {
            EverlastingAbilities.clog(Level.ERROR, e.getMessage());
        }
    }
}

