/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.item;

import java.util.Random;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.LootHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.everlastingabilities.EverlastingAbilities;
import org.cyclops.everlastingabilities.ability.AbilityHelpers;
import org.cyclops.everlastingabilities.api.Ability;
import org.cyclops.everlastingabilities.api.IAbilityType;
import org.cyclops.everlastingabilities.api.capability.IMutableAbilityStore;
import org.cyclops.everlastingabilities.capability.MutableAbilityStoreConfig;
import org.cyclops.everlastingabilities.item.ItemAbilityTotem;

public class ItemAbilityTotemConfig
extends ItemConfig {
    public static ItemAbilityTotemConfig _instance;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If totems should spawn in loot chests.")
    public static boolean lootChests;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="This many totems combined in a crafting grid produces a new random totem (0 to disable)")
    public static int totemCraftingCount;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="When combining totems, percentage chance of getting one higher rarity than normal.")
    public static int totemCraftingRarityIncreasePercent;

    public ItemAbilityTotemConfig() {
        super((ModBase)EverlastingAbilities._instance, true, "ability_totem", null, ItemAbilityTotem.class);
    }

    public void onRegistered() {
        super.onRegistered();
        if (lootChests) {
            LootHelpers.addVanillaLootChestLootEntry((LootEntryItem[])new LootEntryItem[]{new LootEntryItem(this.getItemInstance(), 1, 5, new LootFunction[]{new LootFunction(new LootCondition[0]){

                public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
                    EnumRarity rarity = AbilityHelpers.getRandomRarity(rand);
                    IAbilityType abilityType = AbilityHelpers.getRandomAbility(rand, rarity).get();
                    IMutableAbilityStore mutableAbilityStore = (IMutableAbilityStore)stack.getCapability(MutableAbilityStoreConfig.CAPABILITY, null);
                    mutableAbilityStore.addAbility(new Ability(abilityType, 1), true);
                    return stack;
                }
            }}, new LootCondition[0], this.getMod().getModId() + ":" + this.getSubUniqueName())});
        }
    }

    static {
        lootChests = true;
        totemCraftingCount = 3;
        totemCraftingRarityIncreasePercent = 15;
    }
}

