/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.everlastingabilities.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.everlastingabilities.api.IAbilityType;

public class Ability
implements Comparable<Ability> {
    private final IAbilityType abilityType;
    private final int level;

    public Ability(@Nonnull IAbilityType abilityType, int level) {
        this.abilityType = Objects.requireNonNull(abilityType);
        this.level = level;
    }

    public IAbilityType getAbilityType() {
        return this.abilityType;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return String.format("[%s @ %s]", L10NHelpers.localize((String)this.abilityType.getUnlocalizedName(), (Object[])new Object[0]), this.level);
    }

    @Override
    public int compareTo(Ability other) {
        return this.toString().compareTo(other.toString());
    }
}

