/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.tesla;

import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.tech.common.blocks.lift.EventLiftUpdate;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.entity.EventLiftConsumePower;
import thut.tech.common.handlers.ConfigHandler;

public class TeslaHandler {
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<ITeslaConsumer> TESLA_CONSUMER = null;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<ITeslaProducer> TESLA_PRODUCER = null;
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<ITeslaHolder> TESLA_HOLDER = null;

    public TeslaHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTileEntityCapabilityAttach(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof TileEntityLiftAccess) {
            class Provider
            implements ICapabilitySerializable<NBTTagCompound>,
            ITeslaConsumer,
            ITeslaProducer,
            ITeslaHolder {
                private long stored = 0L;
                private long capacity = 5000000L;
                private long inputRate = 5000L;
                private long outputRate = 5000L;

                public void deserializeNBT(NBTTagCompound nbt) {
                    this.stored = nbt.func_74763_f("TeslaPower");
                    if (nbt.func_74764_b("TeslaCapacity")) {
                        this.capacity = nbt.func_74763_f("TeslaCapacity");
                    }
                    if (nbt.func_74764_b("TeslaInput")) {
                        this.inputRate = nbt.func_74763_f("TeslaInput");
                    }
                    if (nbt.func_74764_b("TeslaOutput")) {
                        this.outputRate = nbt.func_74763_f("TeslaOutput");
                    }
                    if (this.stored > this.capacity) {
                        this.stored = this.capacity;
                    }
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (TESLA_HOLDER != null && capability == TESLA_HOLDER) {
                        return (T)TESLA_HOLDER.cast((Object)this);
                    }
                    if (TESLA_PRODUCER != null && capability == TESLA_PRODUCER && facing == null) {
                        return (T)TESLA_PRODUCER.cast((Object)this);
                    }
                    if (TESLA_CONSUMER != null && capability == TESLA_CONSUMER) {
                        return (T)TESLA_CONSUMER.cast((Object)this);
                    }
                    return null;
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return TESLA_HOLDER != null && capability == TESLA_HOLDER || TESLA_PRODUCER != null && capability == TESLA_PRODUCER && facing == null || TESLA_CONSUMER != null && capability == TESLA_CONSUMER;
                }

                public NBTTagCompound serializeNBT() {
                    NBTTagCompound dataTag = new NBTTagCompound();
                    dataTag.func_74772_a("TeslaPower", this.stored);
                    dataTag.func_74772_a("TeslaCapacity", this.capacity);
                    dataTag.func_74772_a("TeslaInput", this.inputRate);
                    dataTag.func_74772_a("TeslaOutput", this.outputRate);
                    return dataTag;
                }

                public long getStoredPower() {
                    return this.stored;
                }

                public long getCapacity() {
                    return this.capacity;
                }

                public long takePower(long power, boolean simulated) {
                    long removedPower = Math.min(this.stored, Math.min(this.outputRate, power));
                    if (!simulated) {
                        this.stored -= removedPower;
                    }
                    return removedPower;
                }

                public long givePower(long power, boolean simulated) {
                    long acceptedTesla = Math.min(this.capacity - this.stored, Math.min(this.inputRate, power));
                    if (!simulated) {
                        this.stored += acceptedTesla;
                    }
                    return acceptedTesla;
                }
            }
            event.addCapability(new ResourceLocation("thuttech:tesla"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLift) {
            class Provider
            implements ICapabilitySerializable<NBTTagCompound>,
            ITeslaConsumer,
            ITeslaHolder {
                private long stored = 0L;
                private long capacity = 5000000L;
                private long inputRate = 5000L;

                public void deserializeNBT(NBTTagCompound nbt) {
                    this.stored = nbt.func_74763_f("TeslaPower");
                    if (nbt.func_74764_b("TeslaCapacity")) {
                        this.capacity = nbt.func_74763_f("TeslaCapacity");
                    }
                    if (nbt.func_74764_b("TeslaInput")) {
                        this.inputRate = nbt.func_74763_f("TeslaInput");
                    }
                    if (this.stored > this.capacity) {
                        this.stored = this.capacity;
                    }
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    if (TESLA_HOLDER != null && capability == TESLA_HOLDER) {
                        return (T)TESLA_HOLDER.cast((Object)this);
                    }
                    if (TESLA_CONSUMER != null && capability == TESLA_CONSUMER) {
                        return (T)TESLA_CONSUMER.cast((Object)this);
                    }
                    return null;
                }

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return TESLA_HOLDER != null && capability == TESLA_HOLDER || TESLA_CONSUMER != null && capability == TESLA_CONSUMER;
                }

                public NBTTagCompound serializeNBT() {
                    NBTTagCompound dataTag = new NBTTagCompound();
                    dataTag.func_74772_a("TeslaPower", this.stored);
                    dataTag.func_74772_a("TeslaCapacity", this.capacity);
                    dataTag.func_74772_a("TeslaInput", this.inputRate);
                    return dataTag;
                }

                public long getStoredPower() {
                    return this.stored;
                }

                public long getCapacity() {
                    return this.capacity;
                }

                public long givePower(long power, boolean simulated) {
                    long acceptedTesla = Math.min(this.capacity - this.stored, Math.min(this.inputRate, power));
                    if (!simulated) {
                        this.stored += acceptedTesla;
                    }
                    return acceptedTesla;
                }
            }
            event.addCapability(new ResourceLocation("thuttech:tesla"), (ICapabilityProvider)new Provider());
        }
    }

    @SubscribeEvent
    public void liftPowerUseUpdate(EventLiftConsumePower evt) {
        if (!EntityLift.ENERGYUSE || evt.lift == null) {
            return;
        }
        ITeslaHolder lift = (ITeslaHolder)evt.lift.getCapability(TESLA_HOLDER, null);
        if (lift instanceof ITeslaConsumer) {
            ITeslaConsumer liftCap = (ITeslaConsumer)lift;
            liftCap.givePower(-evt.toConsume, false);
        }
    }

    @SubscribeEvent
    public void livingUpdate(EventLiftUpdate evt) {
        if (!EntityLift.ENERGYUSE || evt.getTile().lift == null) {
            return;
        }
        ITeslaHolder tile = (ITeslaHolder)evt.getTile().getCapability(TESLA_HOLDER, null);
        ITeslaHolder lift = (ITeslaHolder)evt.getTile().lift.getCapability(TESLA_HOLDER, null);
        if (tile instanceof ITeslaProducer && tile instanceof ITeslaHolder && lift instanceof ITeslaConsumer && lift instanceof ITeslaHolder) {
            ITeslaConsumer tileCap = (ITeslaConsumer)tile;
            ITeslaConsumer liftCap = (ITeslaConsumer)lift;
            tileCap.givePower((long)ConfigHandler.controllerProduction, false);
            long tilePower = tile.getStoredPower();
            long toAdd = liftCap.givePower(tilePower, true);
            toAdd = ((ITeslaProducer)tile).takePower(toAdd, false);
            liftCap.givePower(toAdd, false);
            evt.getTile().lift.setEnergy((int)lift.getStoredPower());
        }
    }
}

