/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.entity.blockentity.BlockEntityWorld;
import thut.api.entity.blockentity.IBlockEntity;
import thut.api.maths.Vector3;
import thut.api.network.PacketHandler;
import thut.lib.CompatWrapper;
import thut.tech.common.blocks.lift.BlockLift;
import thut.tech.common.blocks.lift.EventLiftUpdate;
import thut.tech.common.entity.EntityLift;
import thut.tech.common.network.PacketPipeline;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileEntityLiftAccess
extends TileEntity
implements ITickable,
SimpleComponent {
    public int power = 0;
    public int prevPower = 1;
    public EntityLift lift;
    public IBlockState copiedState = null;
    boolean listNull = false;
    List<Entity> list = new ArrayList<Entity>();
    Vector3 here;
    public TileEntityLiftAccess rootNode;
    public Vector<TileEntityLiftAccess> connected = new Vector();
    EnumFacing sourceSide;
    public double energy;
    boolean loaded = false;
    public int floor = 0;
    public int calledYValue = -1;
    public int calledFloor = 0;
    public int currentFloor = 0;
    public UUID liftID = null;
    UUID empty = new UUID(0L, 0L);
    private byte[] sides = new byte[6];
    private byte[] sidePages = new byte[6];
    int tries = 0;
    public boolean toClear = false;
    public boolean first = true;
    public boolean read = false;
    public boolean redstone = true;
    public boolean powered = false;
    public boolean[] callFaces = new boolean[6];
    public boolean[] editFace = new boolean[6];
    public boolean[] floorDisplay = new boolean[6];
    public boolean callPanel = false;

    public void buttonPress(int button, boolean callPanel) {
        if (callPanel && this.lift != null) {
            this.lift.call(this.floor);
        } else if (button != 0 && button <= this.lift.floors.length && this.lift != null && this.lift.hasFloors[button - 1]) {
            if (button != this.floor && this.lift.getCurrentFloor() == this.floor) {
                this.lift.setCurrentFloor(-1);
            }
            this.lift.call(button);
        }
    }

    public void setWorldObj(World worldIn) {
        IBlockEntity blockEntity;
        this.field_145850_b = worldIn;
        if (worldIn instanceof BlockEntityWorld && (blockEntity = ((BlockEntityWorld)worldIn).getEntity()) instanceof EntityLift) {
            this.setLift((EntityLift)blockEntity);
        }
    }

    public boolean checkSides() {
        List check = this.field_145850_b.func_72872_a(EntityLift.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() + 0.5 - 1.0, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5 - 1.0, (double)this.func_174877_v().func_177958_n() + 0.5 + 1.0, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5 + 1.0));
        if (check != null && check.size() > 0) {
            this.lift = (EntityLift)((Object)check.get(0));
            this.liftID = this.lift.getPersistentID();
        }
        return check != null && !check.isEmpty();
    }

    public String connectionInfo() {
        String ret = "";
        return ret;
    }

    public boolean doButtonClick(EntityLivingBase clicker, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean valid;
        if (this.liftID != null && !this.liftID.equals(this.empty) && this.lift != EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b)) {
            this.lift = EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b);
        }
        int button = this.getButtonFromClick(side, hitX, hitY, hitZ);
        boolean bl = valid = this.lift != null && this.lift.hasFloors[button - 1];
        if (this.lift != null && this.isSideOn(side)) {
            if (this.editFace[side.ordinal()]) {
                if (!this.func_145831_w().field_72995_K) {
                    String message = "msg.callPanel.name";
                    switch (button) {
                        case 1: {
                            this.callFaces[side.ordinal()] = !this.callFaces[side.ordinal()];
                            this.floorDisplay[side.ordinal()] = false;
                            clicker.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{this.callFaces[side.ordinal()]}));
                            break;
                        }
                        case 2: {
                            this.floorDisplay[side.ordinal()] = !this.floorDisplay[side.ordinal()];
                            this.callFaces[side.ordinal()] = false;
                            message = "msg.floorDisplay.name";
                            clicker.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{this.floorDisplay[side.ordinal()]}));
                            break;
                        }
                        case 16: {
                            this.editFace[side.ordinal()] = false;
                            message = "msg.editMode.name";
                            clicker.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[]{false}));
                        }
                    }
                    if (clicker instanceof EntityPlayerMP) {
                        this.sendUpdate((EntityPlayerMP)clicker);
                    }
                }
                return true;
            }
            if (this.floorDisplay[side.ordinal()]) {
                return false;
            }
            if (this.func_145831_w() instanceof BlockEntityWorld) {
                this.buttonPress(button, this.callFaces[side.ordinal()]);
                this.calledFloor = this.lift.getDestinationFloor();
            } else if (this.func_145831_w().field_72995_K) {
                PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)32));
                buffer.func_179255_a(this.func_174877_v());
                buffer.writeInt(button);
                buffer.writeBoolean(this.callFaces[side.ordinal()]);
                PacketPipeline.ServerPacket packet = new PacketPipeline.ServerPacket((ByteBuf)buffer);
                PacketPipeline.sendToServer(packet);
            }
        }
        if (clicker instanceof EntityPlayerMP) {
            this.sendUpdate((EntityPlayerMP)clicker);
        }
        return valid;
    }

    public int getButtonFromClick(EnumFacing side, float hitX, float hitY, float hitZ) {
        int ret = 0;
        int page = this.getSidePage(side);
        switch (side.func_176745_a()) {
            case 0: {
                return 0 + 16 * page;
            }
            case 1: {
                ret = 1 + (int)((1.0f - hitX) * 4.0f % 4.0f) + 4 * (int)((1.0f - hitZ) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 2: {
                ret = 1 + (int)((1.0f - hitX) * 4.0f % 4.0f) + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 3: {
                ret = 1 + (int)(hitX * 4.0f % 4.0f) + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 4: {
                ret = 1 + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f) + (int)(hitZ * 4.0f % 4.0f);
                return ret + 16 * page;
            }
            case 5: {
                ret = 1 + 4 * (int)((1.0f - hitY) * 4.0f % 4.0f) + (int)((1.0f - hitZ) * 4.0f % 4.0f);
                return ret + 16 * page;
            }
        }
        return 0 + 16 * page;
    }

    public String getComponentName() {
        return "lift";
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, this.func_189517_E_());
    }

    public int getSidePage(EnumFacing side) {
        return this.sidePages[side.func_176745_a()];
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public boolean isSideOn(EnumFacing side) {
        byte state = 1;
        byte byte0 = this.sides[side.func_176745_a()];
        return (byte0 & state) != 0;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbttagcompound = pkt.func_148857_g();
        this.func_145839_a(nbttagcompound);
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        this.floor = par1.func_74762_e("floor");
        this.liftID = new UUID(par1.func_74763_f("idMost"), par1.func_74763_f("idLess"));
        this.sides = par1.func_74770_j("sides");
        for (EnumFacing face : EnumFacing.field_176754_o) {
            this.callFaces[face.ordinal()] = par1.func_74767_n(face + "Call");
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            this.editFace[face.ordinal()] = par1.func_74767_n(face + "Edit");
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            this.floorDisplay[face.ordinal()] = par1.func_74767_n(face + "Display");
        }
        if (this.sides.length != 6) {
            this.sides = new byte[6];
        }
        this.sidePages = par1.func_74770_j("sidePages");
        if (this.sidePages.length != 6) {
            this.sidePages = new byte[6];
        }
        if (par1.func_74764_b("state")) {
            NBTTagCompound state = par1.func_74775_l("state");
            String key = state.func_74779_i("K");
            int meta = state.func_74762_e("M");
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(key));
            if (block != null) {
                this.copiedState = CompatWrapper.getBlockStateFromMeta((Block)block, (int)meta);
            }
        }
    }

    public void setEnergy(double energy) {
    }

    public void setFloor(int floor) {
        if (this.lift != null && floor <= this.lift.floors.length && floor > 0) {
            this.lift.setFoor(this, floor);
            this.floor = floor;
            this.func_70296_d();
        }
    }

    public void setLift(EntityLift lift) {
        this.lift = lift;
        this.liftID = lift.func_110124_au();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            PacketHandler.sendTileUpdate((TileEntity)this);
        }
    }

    public void setSide(EnumFacing side, boolean flag) {
        byte state = 1;
        byte byte0 = this.sides[side.func_176745_a()];
        if (side.func_176745_a() < 2) {
            return;
        }
        this.sides[side.func_176745_a()] = flag ? (byte)(byte0 | state) : (byte)(byte0 & -state - 1);
        this.func_70296_d();
    }

    public void setSidePage(EnumFacing side, int page) {
        this.sidePages[side.func_176745_a()] = (byte)page;
    }

    public void func_73660_a() {
        if (this.here == null) {
            this.here = Vector3.getNewVector();
        }
        this.here.set((Object)this);
        if (this.field_145850_b instanceof BlockEntityWorld) {
            return;
        }
        if (this.lift == null || this.lift.field_70128_L) {
            this.calledYValue = -1;
            this.calledFloor = 0;
            this.currentFloor = 0;
        }
        if (this.lift != null && !this.field_145850_b.field_72995_K) {
            boolean check = this.lift.getCurrentFloor() == this.floor && (int)(this.lift.field_70181_x * 16.0) == 0;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            boolean old = (Boolean)state.func_177229_b((IProperty)BlockLift.CURRENT);
            boolean callPanel = false;
            if (!old && !this.lift.getCalled()) {
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    callPanel |= this.callFaces[face.ordinal()];
                }
            }
            if (callPanel && !old && !this.lift.getCalled() && !check && this.field_145850_b.func_175640_z(this.func_174877_v())) {
                this.lift.call(this.floor);
            }
            if (check != old) {
                state = state.func_177226_a((IProperty)BlockLift.CURRENT, (Comparable)Boolean.valueOf(check));
                this.field_145850_b.func_175656_a(this.func_174877_v(), state);
            }
            if (this.lift.field_70181_x == 0.0 || this.lift.getDestinationFloor() == this.floor) {
                old = (Boolean)state.func_177229_b((IProperty)BlockLift.CALLED);
                boolean bl = check = this.lift.getDestinationFloor() == this.floor;
                if (check != old) {
                    state = state.func_177226_a((IProperty)BlockLift.CALLED, (Comparable)Boolean.valueOf(check));
                    this.field_145850_b.func_175656_a(this.func_174877_v(), state);
                }
            }
            MinecraftForge.EVENT_BUS.post((Event)new EventLiftUpdate(this));
        }
        if (this.lift != null && this.floor > 0) {
            if ((int)Math.round(this.lift.field_70163_u) == this.lift.floors[this.floor - 1]) {
                this.lift.setCurrentFloor(this.floor);
            } else if (this.lift.getCurrentFloor() == this.floor) {
                this.lift.setCurrentFloor(-1);
            }
            if (!this.lift.hasFloors[this.floor - 1]) {
                this.lift.setFoor(this, this.floor);
            }
            this.calledFloor = this.lift.getDestinationFloor();
            this.currentFloor = this.lift.getCurrentFloor();
        }
        EntityLift tempLift = EntityLift.getLiftFromUUID(this.liftID, this.field_145850_b);
        if (this.liftID != null && !this.liftID.equals(this.empty) && (this.lift == null || this.lift.field_70128_L || tempLift != this.lift)) {
            this.lift = tempLift;
            if (this.lift == null || this.lift.field_70128_L) {
                return;
            }
        }
        if (this.floor > 0 && (this.lift == null || this.lift.field_70128_L)) {
            this.lift = null;
            this.floor = 0;
        }
        if (this.lift == null) {
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity t = this.here.getTileEntity((IBlockAccess)this.field_145850_b, side);
                Block b = this.here.getBlock((IBlockAccess)this.field_145850_b, side);
                if (b != this.func_145838_q() || !(t instanceof TileEntityLiftAccess)) continue;
                TileEntityLiftAccess te = (TileEntityLiftAccess)t;
                if (te.lift == null) continue;
                this.lift = te.lift;
                this.floor = te.floor;
                this.func_70296_d();
                break;
            }
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound par1) {
        super.func_189515_b(par1);
        par1.func_74768_a("floor", this.floor);
        par1.func_74773_a("sides", this.sides);
        par1.func_74773_a("sidePages", this.sidePages);
        for (EnumFacing face : EnumFacing.field_176754_o) {
            par1.func_74757_a(face + "Call", this.callFaces[face.ordinal()]);
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            par1.func_74757_a(face + "Edit", this.editFace[face.ordinal()]);
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            par1.func_74757_a(face + "Display", this.floorDisplay[face.ordinal()]);
        }
        if (this.lift != null) {
            this.liftID = this.lift.getPersistentID();
        }
        if (this.liftID != null) {
            par1.func_74772_a("idLess", this.liftID.getLeastSignificantBits());
            par1.func_74772_a("idMost", this.liftID.getMostSignificantBits());
        }
        if (this.copiedState != null) {
            NBTTagCompound state = new NBTTagCompound();
            state.func_74778_a("K", this.copiedState.func_177230_c().getRegistryName().toString());
            state.func_74768_a("M", this.copiedState.func_177230_c().func_176201_c(this.copiedState));
            par1.func_74782_a("state", (NBTBase)state);
        }
        return par1;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = INFINITE_EXTENT_AABB;
        return bb;
    }

    public void sendUpdate(EntityPlayerMP player) {
        if (this.field_145850_b instanceof BlockEntityWorld) {
            return;
        }
        player.field_71135_a.func_147359_a((Packet)this.func_189518_D_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Callback(doc="function(floor:number) -- Calls the Lift to the specified Floor")
    @Optional.Method(modid="opencomputers")
    public Object[] callFloor(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            this.lift.call(args.checkInteger(0));
            return new Object[0];
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="function(yValue:number) -- Calls the Lift to the specified Y level")
    @Optional.Method(modid="opencomputers")
    public Object[] callYValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            this.lift.setDestY(args.checkInteger(0));
            return new Object[0];
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="function(xValue:number) -- Calls the Lift to thespecified X location")
    @Optional.Method(modid="opencomputers")
    public Object[] callXValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            this.lift.setDestX(args.checkInteger(0));
            return new Object[0];
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="function(zValue:number) -- Calls the Lift to thespecified Z location")
    @Optional.Method(modid="opencomputers")
    public Object[] callZValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            this.lift.setDestZ(args.checkInteger(0));
            return new Object[0];
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="function(floor:number) -- Sets the floor assosiated tothe Controller")
    @Optional.Method(modid="opencomputers")
    public Object[] setFloor(Context context, Arguments args) {
        this.floor = args.checkInteger(0);
        return new Object[]{this.floor};
    }

    @Callback(doc="returns the current Y value of the lift.")
    @Optional.Method(modid="opencomputers")
    public Object[] getYValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            return new Object[]{Float.valueOf((float)this.lift.field_70163_u)};
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="returns the current X value of the lift.")
    @Optional.Method(modid="opencomputers")
    public Object[] getXValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            return new Object[]{Float.valueOf((float)this.lift.field_70165_t)};
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="returns the current Z value of the lift.")
    @Optional.Method(modid="opencomputers")
    public Object[] getZValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            return new Object[]{Float.valueOf((float)this.lift.field_70161_v)};
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="returns the Floor assigned to the Controller")
    @Optional.Method(modid="opencomputers")
    public Object[] getFloor(Context context, Arguments args) {
        return new Object[]{this.floor};
    }

    @Callback(doc="function(floor:number) -- returns the y value of the specified floor")
    @Optional.Method(modid="opencomputers")
    public Object[] getFloorYValue(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            int floor = args.checkInteger(0);
            if (floor > 0 && floor <= this.lift.floors.length) {
                int value = this.lift.floors[floor - 1];
                if (!this.lift.hasFloors[floor - 1]) {
                    throw new Exception("floor " + floor + " is not assigned");
                }
                return new Object[]{value};
            }
            throw new Exception("floor out of bounds");
        }
        throw new Exception("no connected lift");
    }

    @Callback(doc="returns if the elevator is not currently called to afloor")
    @Optional.Method(modid="opencomputers")
    public Object[] isReady(Context context, Arguments args) throws Exception {
        if (this.lift != null) {
            return new Object[]{!this.lift.getCalled()};
        }
        throw new Exception("no connected lift");
    }
}

